/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedSuspendableRouteMBean;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.model.ModelCamelContext;

@ManagedResource(description="Managed Suspendable Route")
public class ManagedSuspendableRoute
extends ManagedRoute
implements ManagedSuspendableRouteMBean {
    public ManagedSuspendableRoute(ModelCamelContext context, Route route) {
        super(context, route);
    }

    @Override
    public void suspend() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.suspendRoute(this.getRouteId());
    }

    @Override
    public void suspend(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.suspendRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public void resume() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.resumeRoute(this.getRouteId());
    }
}

