/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CustomizableThreadCreator;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;
    private final boolean allowQuickStop;
    private volatile TaskExecutor taskExecutor;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this(endpoint, true);
    }

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint, boolean allowQuickStop) {
        this.endpoint = endpoint;
        this.allowQuickStop = allowQuickStop;
    }

    protected boolean isAllowQuickStop() {
        return this.allowQuickStop;
    }

    @Override
    protected boolean runningAllowed() {
        boolean quickStop = false;
        if (this.isAllowQuickStop() && !this.endpoint.isAcceptMessagesWhileStopping()) {
            quickStop = this.endpoint.getCamelContext().getStatus().isStopping();
        }
        if (quickStop) {
            this.logger.debug("runningAllowed() -> false due CamelContext is stopping and endpoint configured to not accept messages while stopping");
            return false;
        }
        boolean answer = this.endpoint.isRunning();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("runningAllowed() -> " + answer);
        }
        return answer;
    }

    @Override
    protected TaskExecutor createDefaultTaskExecutor() {
        CustomizableThreadCreator answer;
        String beanName;
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String string = beanName = this.getBeanName() == null ? this.endpoint.getThreadName() : this.getBeanName();
        if (this.endpoint.getDefaultTaskExecutorType() == DefaultTaskExecutorType.ThreadPool) {
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setBeanName(beanName);
            executor.setThreadFactory(new CamelThreadFactory(pattern, beanName, true));
            executor.setCorePoolSize(this.endpoint.getConcurrentConsumers());
            executor.setQueueCapacity(0);
            executor.initialize();
            answer = executor;
        } else {
            SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor(beanName);
            executor.setThreadFactory(new CamelThreadFactory(pattern, beanName, true));
            answer = executor;
        }
        this.taskExecutor = answer;
        return answer;
    }

    @Override
    public void stop() throws JmsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stopping listenerContainer: " + this + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled());
        }
        super.stop();
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            executor.destroy();
        }
    }

    @Override
    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying listenerContainer: " + this + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled());
        }
        super.destroy();
        if (this.taskExecutor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor executor = (ThreadPoolTaskExecutor)this.taskExecutor;
            executor.destroy();
        }
    }

    @Override
    protected void stopSharedConnection() {
        if (this.logger.isDebugEnabled() && this.sharedConnectionEnabled()) {
            this.logger.debug("Stopping shared connection on listenerContainer: " + this);
        }
        super.stopSharedConnection();
    }
}

