## Silverstripe Framework

[![CI](https://github.com/silverstripe/silverstripe-framework/actions/workflows/ci.yml/badge.svg)](https://github.com/silverstripe/silverstripe-framework/actions/workflows/ci.yml)
[![Silverstripe supported module](https://img.shields.io/badge/silverstripe-supported-0071C4.svg)](https://www.silverstripe.org/software/addons/silverstripe-commercially-supported-module-list/)

PHP framework forming the base for the Silverstripe CMS ([https://silverstripe.org](https://silverstripe.org)). 
Requires a [`silverstripe-installer`](https://github.com/silverstripe/silverstripe-installer) base project. Typically used alongside the [`cms`](https://github.com/silverstripe/silverstripe-cms) module.

## Installation

See [getting started](https://docs.silverstripe.org/en/getting_started/)
for instructions on how to start the installation process.

## Bugtracker

Bugs are tracked on [github.com](https://github.com/silverstripe/silverstripe-framework/issues). 
Please read our [issue reporting guidelines](https://docs.silverstripe.org/en/contributing/issues_and_bugs/).

## Development and Contribution

If you would like to make changes to the Silverstripe core codebase, we have an extensive [guide to contributing code](https://docs.silverstripe.org/en/contributing/code/).

## Links

 * [Server Requirements](https://docs.silverstripe.org/en/getting_started/server_requirements/)
 * [Changelogs](https://docs.silverstripe.org/en/changelogs/)
 * [Bugtracker: Framework](https://github.com/silverstripe/silverstripe-framework/issues)
 * [Bugtracker: CMS](https://github.com/silverstripe/silverstripe-cms/issues)
 * [Bugtracker: Installer](https://github.com/silverstripe/silverstripe-installer/issues)
 * [Forums](https://forum.silverstripe.org/)
 * [Developer Mailinglist](https://groups.google.com/forum/#!forum/silverstripe-dev)
 * [License](./LICENSE)
	
## Attribution

 * Some icons by [Yusuke Kamiyamane](https://p.yusukekamiyamane.com/). All rights reserved. Licensed under a [Creative Commons Attribution 3.0 License](https://creativecommons.org/licenses/by/3.0/).
 * default_media.png by Thibault Geffroy from [The Noun Project](https://thenounproject.com/). All rights reserved. Licensed under a [Creative Commons Attribution 3.0 License](https://creativecommons.org/licenses/by/3.0/).
