CREATE TABLE `counters` ( `counter_id` int(11) NOT NULL AUTO_INCREMENT, `device_id` int(11) NOT NULL, `poller_type` enum('snmp','agent','ipmi') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'snmp', `counter_class` varchar(64) COLLATE utf8_unicode_ci NOT NULL, `counter_oid` varchar(255) COLLATE utf8_unicode_ci NOT NULL, `counter_mib` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_object` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_index` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_descr` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_unit` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_multiplier` float NOT NULL DEFAULT 1, `counter_limit` float DEFAULT NULL, `counter_limit_warn` float DEFAULT NULL, `counter_limit_low` float DEFAULT NULL, `counter_limit_low_warn` float DEFAULT NULL, `counter_custom_limit` tinyint(1) NOT NULL DEFAULT 0, `entPhysicalIndex_measured` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL, `measured_class` enum('port','outlet','printersupply') COLLATE utf8_unicode_ci DEFAULT NULL, `measured_entity` int(11) DEFAULT NULL, `entPhysicalIndex` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL, `entPhysicalClass` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_ignore` tinyint(1) NOT NULL DEFAULT 0, `counter_disable` tinyint(1) NOT NULL DEFAULT 0, `counter_deleted` tinyint(1) NOT NULL DEFAULT 0, `counter_value` float(14,5) DEFAULT NULL, `counter_rate` float(14,5) DEFAULT NULL, `counter_event` enum('ok','warning','alert','ignore') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ignore', `counter_status` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL, `counter_polled` int(11) DEFAULT NULL, `counter_last_change` int(11) DEFAULT NULL, PRIMARY KEY (`counter_id`), KEY `counter_device` (`device_id`), KEY `counter_class` (`counter_class`), KEY `counter_oid` (`counter_oid`), KEY `counter_cache` (`counter_id`,`device_id`,`counter_class`, `counter_ignore`,`counter_disable`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
ALTER TABLE `counters` ADD `counter_rate_hour` FLOAT(14,5) NULL DEFAULT NULL AFTER `counter_rate`, ADD `counter_history` TEXT CHARACTER SET latin1 COLLATE latin1_general_ci NULL DEFAULT NULL AFTER `counter_rate_hour`;
ALTER TABLE `counters` ADD CONSTRAINT `counter_devices` FOREIGN KEY (`device_id`) REFERENCES `devices`(`device_id`) ON DELETE CASCADE ON UPDATE NO ACTION;
