DROP TABLE IF EXISTS `wifi_aps`;
CREATE TABLE `wifi_aps` (  `wifi_ap_id` int(11) NOT NULL,  `device_id` int(11) NOT NULL,  `ap_mib` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ap_index` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ap_number` int(11) DEFAULT NULL,  `ap_name` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `ap_serial` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `ap_model` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `ap_location` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `ap_fingerprint` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `ap_status` varchar(8) COLLATE utf8_unicode_ci NOT NULL,  `deleted` tinyint(1) DEFAULT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `wifi_radios`;
CREATE TABLE `wifi_radios` (  `wifi_radio_id` int(11) NOT NULL,  `device_id` int(11) NOT NULL,  `radio_mib` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `radio_number` int(11) NOT NULL,  `radio_type` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_protection` varchar(8) COLLATE utf8_unicode_ci DEFAULT 'none',  `radio_bsstype` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_status` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_ap` int(11) NOT NULL,  `radio_clients` int(11) DEFAULT NULL,  `radio_txpower` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_channel` int(11) DEFAULT NULL,  `radio_util` int(11) NOT NULL,  `radio_mac` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_assoc_clients` int(11) DEFAULT NULL,  `radio_mon_clients` int(11) DEFAULT NULL,  `radio_ht_mode` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_ht_extchan` varchar(8) COLLATE utf8_unicode_ci DEFAULT NULL,  `radio_ht_chan` varchar(4) COLLATE utf8_unicode_ci DEFAULT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
DROP TABLE IF EXISTS `wifi_wlans`;
CREATE TABLE `wifi_wlans` (  `wlan_id` int(11) NOT NULL,  `device_id` int(11) NOT NULL,  `wlan_index` int(11) NOT NULL,  `wlan_name` varchar(128) DEFAULT NULL,  `wlan_admin_status` tinyint(1) NOT NULL DEFAULT '1',  `wlan_ssid` varchar(64) NOT NULL,  `wlan_ssid_bcast` tinyint(1) NOT NULL,  `wlan_bssid` varchar(64) NOT NULL,  `wlan_bss_type` varchar(32) NOT NULL,  `wlan_channel` int(11) NOT NULL,  `wlan_dtim_period` int(11) NOT NULL,  `wlan_beacon_period` int(11) NOT NULL,  `wlan_frag_thresh` int(11) NOT NULL,  `wlan_igmp_snoop` tinyint(1) NOT NULL,  `wlan_prot_mode` varchar(32) NOT NULL,  `wlan_radio_mode` varchar(32) NOT NULL,  `wlan_rts_thresh` int(11) NOT NULL,  `wlan_vlan_id` int(11) NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8;
ALTER TABLE `wifi_aps`  ADD PRIMARY KEY (`wifi_ap_id`);
ALTER TABLE `wifi_radios`  ADD PRIMARY KEY (`wifi_radio_id`),  ADD UNIQUE KEY `unique_dev_ap_number` (`device_id`,`radio_ap`,`radio_number`);
ALTER TABLE `wifi_wlans`  ADD PRIMARY KEY (`wlan_id`),  ADD KEY `device_id` (`device_id`);
ALTER TABLE `wifi_aps`  MODIFY `wifi_ap_id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `wifi_radios`  MODIFY `wifi_radio_id` int(11) NOT NULL AUTO_INCREMENT;
ALTER TABLE `wifi_wlans`  MODIFY `wlan_id` int(11) NOT NULL AUTO_INCREMENT;
