-- 0.10.7.1
ALTER TABLE `bills` MODIFY COLUMN `bill_autoadded` BOOLEAN NOT NULL DEFAULT '0';
DROP TABLE IF EXISTS `graph_types`;
CREATE TABLE IF NOT EXISTS `graph_types` (  `graph_type` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `graph_subtype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `graph_section` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `graph_descr` varchar(64) COLLATE utf8_unicode_ci NOT NULL,  `graph_order` int(11) NOT NULL,  KEY `graph_type` (`graph_type`),  KEY `graph_subtype` (`graph_subtype`),  KEY `graph_section` (`graph_section`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `graph_types` (`graph_type`, `graph_subtype`, `graph_section`, `graph_descr`, `graph_order`) VALUES('device', 'bits', 'netstats', 'Total Traffic', 0),('device', 'hr_users', 'system', 'Users Logged In', 0),('device', 'ucd_load', 'system', 'Load Averages', 0),('device', 'ucd_cpu', 'system', 'Detailed Processor Usage', 0),('device', 'ucd_memory', 'system', 'Detailed Memory Usage', 0),('device', 'netstat_tcp', 'netstats', 'TCP Statistics', 0),('device', 'netstat_icmp_info', 'netstats', 'ICMP Informational Statistics', 0),('device', 'netstat_icmp_stat', 'netstats', 'ICMP Statistics', 0),('device', 'netstat_ip', 'netstats', 'IP Statistics', 0),('device', 'netstat_ip_frag', 'netstats', 'IP Fragmentation Statistics', 0),('device', 'netstat_udp', 'netstats', 'UDP Statistics', 0),('device', 'netstat_snmp', 'netstats', 'SNMP Statistics', 0),('device', 'temperatures', 'system', 'Temperatures', 0),('device', 'mempools', 'system', 'Memory Pool Usage', 0),('device', 'processors', 'system', 'Processor Usage', 0),('device', 'storage', 'system', 'Filesystem Usage', 0),('device', 'hr_processes', 'system', 'Running Processes', 0),('device', 'uptime', 'system', 'System Uptime', 0),('device', 'ipsystemstats_ipv4', 'netstats', 'IPv4 Packet Statistics', 0),('device', 'ipsystemstats_ipv6_frag', 'netstats', 'IPv6 Fragmentation Statistics', 0),('device', 'ipsystemstats_ipv6', 'netstats', 'IPv6 Packet Statistics', 0),('device', 'ipsystemstats_ipv4_frag', 'netstats', 'IPv4 Fragmentation Statistics', 0),('device', 'fortigate_sessions', 'firewall', 'Active Sessions', 0), ('device',  'screenos_sessions',  'firewall', 'Active Sessions', 0), ('device',  'fdb_count',  'system',  'MAC Addresses Learnt', 0),('device', 'cras_sessions', 'firewall', 'Remote Access Sessions', 0);
DROP TABLE `frequency`;
ALTER TABLE `mempools` CHANGE  `mempool_index`  `mempool_index` VARCHAR( 16 ) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL;
ALTER TABLE `vrfs` CHANGE `mplsVpnVrfRouteDistinguisher` `mplsVpnVrfRouteDistinguisher` VARCHAR(26)  NOT NULL;
-- Change port rrds
ALTER TABLE `devices` MODIFY COLUMN `timeout` INT NULL DEFAULT NULL AFTER  `port`;
ALTER TABLE `devices` MODIFY COLUMN `retries` INT NULL DEFAULT NULL AFTER `timeout`;
ALTER TABLE `perf_times` CHANGE  `duration`  `duration` DOUBLE( 8, 2 ) NOT NULL;
-- Extend port descriptions
ALTER TABLE ports MODIFY port_descr_circuit VARCHAR(255);
ALTER TABLE ports MODIFY port_descr_descr VARCHAR(255);
ALTER TABLE ports MODIFY port_descr_notes VARCHAR(255);
ALTER TABLE devices MODIFY community VARCHAR(255);
ALTER TABLE users MODIFY password VARCHAR(34);
ALTER TABLE sensors MODIFY sensor_descr VARCHAR(255);
ALTER TABLE `vrfs` MODIFY  `mplsVpnVrfRouteDistinguisher` VARCHAR(128);
ALTER TABLE `vrfs` MODIFY  `vrf_name` VARCHAR(128);
ALTER TABLE `ports` MODIFY  `ifDescr` VARCHAR(255);
CREATE TABLE IF NOT EXISTS `vminfo` (`id` int(11) NOT NULL AUTO_INCREMENT, `device_id` int(11) NOT NULL, `vmwVmVMID` int(11) NOT NULL, `vmwVmDisplayName` varchar(128) NOT NULL, `vmwVmGuestOS` varchar(128) NOT NULL, `vmwVmMemSize` int(11) NOT NULL, `vmwVmCpus` int(11) NOT NULL, `vmwVmState` varchar(128) NOT NULL, PRIMARY KEY  (`id`), KEY `device_id` (`device_id`), KEY `vmwVmVMID` (`vmwVmVMID`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
ALTER TABLE `ports` MODIFY  `port_descr_type` VARCHAR(255);
DROP TABLE `vmware_vminfo`;
CREATE TABLE IF NOT EXISTS `cef_switching` (  `device_id` int(11) NOT NULL,  `entPhysicalIndex` int(11) NOT NULL,  `afi` varchar(4) COLLATE utf8_unicode_ci NOT NULL,  `cef_index` int(11) NOT NULL,  `cef_path` varchar(16) COLLATE utf8_unicode_ci NOT NULL,  `drop` int(11) NOT NULL,  `punt` int(11) NOT NULL,  `punt2host` int(11) NOT NULL,  `drop_prev` int(11) NOT NULL,  `punt_prev` int(11) NOT NULL,  `punt2host_prev` int(11) NOT NULL,`updated` INT NOT NULL ,  `updated_prev` INT NOT NULL )  ENGINE=InnoDB DEFAULT CHARSET=utf8;
UPDATE sensors SET sensor_class='frequency' WHERE sensor_class='freq';
CREATE TABLE IF NOT EXISTS `ospf_areas` (  `device_id` int(11) NOT NULL,  `ospfAreaId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfAuthType` varchar(64) COLLATE utf8_unicode_ci NOT NULL,  `ospfImportAsExtern` varchar(128) COLLATE utf8_unicode_ci NOT NULL,  `ospfSpfRuns` int(11) NOT NULL,  `ospfAreaBdrRtrCount` int(11) NOT NULL,  `ospfAsBdrRtrCount` int(11) NOT NULL,  `ospfAreaLsaCount` int(11) NOT NULL,  `ospfAreaLsaCksumSum` int(11) NOT NULL,  `ospfAreaSummary` varchar(64) COLLATE utf8_unicode_ci NOT NULL,  `ospfAreaStatus` varchar(64) COLLATE utf8_unicode_ci NOT NULL,  UNIQUE KEY `device_area` (`device_id`,`ospfAreaId`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE IF NOT EXISTS `ospf_instances` (  `device_id` int(11) NOT NULL,  `ospf_instance_id` int(11) NOT NULL,  `ospfRouterId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfAdminStat` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfVersionNumber` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfAreaBdrRtrStatus` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfASBdrRtrStatus` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfExternLsaCount` int(11) NOT NULL,  `ospfExternLsaCksumSum` int(11) NOT NULL,  `ospfTOSSupport` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfOriginateNewLsas` int(11) NOT NULL,  `ospfRxNewLsas` int(11) NOT NULL,  `ospfExtLsdbLimit` int(11) DEFAULT NULL,  `ospfMulticastExtensions` int(11) DEFAULT NULL,  `ospfExitOverflowInterval` int(11) DEFAULT NULL,  `ospfDemandExtensions` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  UNIQUE KEY `device_id` (`device_id`,`ospf_instance_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE IF NOT EXISTS `ospf_ports` (  `device_id` int(11) NOT NULL,  `interface_id` int(11) NOT NULL,  `ospf_port_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfIfIpAddress` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfAddressLessIf` int(11) NOT NULL,  `ospfIfAreaId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfIfType` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfAdminStat` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfRtrPriority` int(11) DEFAULT NULL,  `ospfIfTransitDelay` int(11) DEFAULT NULL,  `ospfIfRetransInterval` int(11) DEFAULT NULL,  `ospfIfHelloInterval` int(11) DEFAULT NULL,  `ospfIfRtrDeadInterval` int(11) DEFAULT NULL,  `ospfIfPollInterval` int(11) DEFAULT NULL,  `ospfIfState` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfDesignatedRouter` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfBackupDesignatedRouter` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfEvents` int(11) DEFAULT NULL,  `ospfIfAuthKey` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfStatus` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfMulticastForwarding` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfDemand` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  `ospfIfAuthType` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,  UNIQUE KEY `device_id` (`device_id`,`interface_id`,`ospf_port_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
CREATE TABLE IF NOT EXISTS `ospf_nbrs` (  `device_id` int(11) NOT NULL,  `interface_id` int(11) NOT NULL,  `ospf_nbr_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbrIpAddr` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbrAddressLessIndex` int(11) NOT NULL,  `ospfNbrRtrId` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbrOptions` int(11) NOT NULL,  `ospfNbrPriority` int(11) NOT NULL,  `ospfNbrState` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbrEvents` int(11) NOT NULL,  `ospfNbrLsRetransQLen` int(11) NOT NULL,  `ospfNbmaNbrStatus` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbmaNbrPermanence` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  `ospfNbrHelloSuppressed` varchar(32) COLLATE utf8_unicode_ci NOT NULL,  UNIQUE KEY `device_id` (`device_id`,`ospf_nbr_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;