<?php

/**
 * Observium
 *
 *   This file is part of Observium.
 *
 * @package    observium
 * @subpackage poller
 * @copyright  (C) 2006-2013 Adam Armstrong, (C) 2013-2019 Observium Limited
 *
 */

$table_defs['NS-ROOT-MIB']['nsTcpStatsGroup'] = array(
  'table'      => 'nsTcpStatsGroup',
  'mib'        => 'NS-ROOT-MIB',
  'mib_dir'    => 'citrix',
  'file'       => 'netscaler-stats-tcp.rrd',
  'ds_rename'  => array("tcp" => "", "Active" => "Ac", "Passive" => "Ps", "Zombie" => "Zom"),
  'graphs'     => array('netscaler_tcp_conn', 'netscaler_tcp_bits', 'netscaler_tcp_pkts', 'netscaler_tcp_errretransmit',
                        'netscaler_tcp_errretransmitgiveup', 'netscaler_tcp_errfullretransmit', 'netscaler_tcp_errpartialretransmit',
                        'netscaler_tcp_errfastretransmissions', 'netscaler_tcp_errxretransmissions',
                        'netscaler_conn_zombie_flushed', 'netscaler_retransmission_error',
                        'netscaler_common_errors', 'netscaler_conn_zombie_halfclosed', 'netscaler_retransmit_err',
                        'netscaler_conn_client', 'netscaler_conn_zombie_halfopen', 'netscaler_rst_errors',
                        'netscaler_conn_clientserver', 'netscaler_conn_zombie_packets', 'netscaler_syn_errors',
                        'netscaler_conn_current', 'netscaler_cookie_rejected', 'netscaler_syn_stats',
                        'netscaler_conn_server', 'netscaler_data_errors', 'netscaler_conn_spare', 'netscaler_out_of_order'),

  'oids'    => array(
    'tcpCurServerConn'                            => array('ds_type' => 'GAUGE'),
    'tcpCurClientConn'                            => array('ds_type' => 'GAUGE'),
    'tcpActiveServerConn'                         => array('ds_type' => 'GAUGE'),
    'tcpCurClientConnClosing'                     => array('ds_type' => 'GAUGE'),
    'tcpCurServerConnEstablished'                 => array('ds_type' => 'GAUGE'),
    'tcpCurClientConnOpening'                     => array('ds_type' => 'GAUGE'),
    'tcpCurClientConnEstablished'                 => array('ds_type' => 'GAUGE'),
    'tcpCurServerConnClosing'                     => array('ds_type' => 'GAUGE'),
    'tcpSpareConn'                                => array('ds_type' => 'GAUGE'),
    'tcpSurgeQueueLen'                            => array('ds_type' => 'GAUGE'),
    'tcpCurServerConnOpening'                     => array('ds_type' => 'GAUGE'),
    'tcpCurPhysicalServers'                       => array('ds_type' => 'GAUGE'),
    'tcpReuseHit'                                 => array('ds_type' => 'GAUGE'),
    'tcpTotServerConnOpened'                      => array(),
    'tcpTotServerConnClosed'                      => array(),
    'tcpTotClientConnOpened'                      => array(),
    'tcpTotClientConnClosed'                      => array(),
    'tcpTotSyn'                                   => array(),
    'tcpTotSynProbe'                              => array(),
    'tcpTotSvrFin'                                => array(),
    'tcpTotCltFin'                                => array(),
    'tcpTotRxPkts'                                => array(),
    'tcpTotRxBytes'                               => array(),
    'tcpTotTxPkts'                                => array(),
    'tcpTotTxBytes'                               => array(),
    'tcpWaitToSyn'                                => array(),
    'tcpTotZombieCltConnFlushed'                  => array(),
    'tcpTotZombieSvrConnFlushed'                  => array(),
    'tcpTotZombieHalfOpenCltConnFlushed'          => array(),
    'tcpTotZombieHalfOpenSvrConnFlushed'          => array(),
    'tcpTotZombieActiveHalfCloseCltConnFlushed'   => array(),
    'tcpTotZombieActiveHalfCloseSvrConnFlushed'   => array(),
    'tcpTotZombiePassiveHalfCloseCltConnFlushed'  => array(),
    'tcpTotZombiePassiveHalfCloseSrvConnFlushed'  => array(),
    'tcpErrBadCheckSum'                           => array(),
    'tcpErrSynInSynRcvd'                          => array(),
    'tcpErrSynInEst'                              => array(),
    'tcpErrSynGiveUp'                             => array(),
    'tcpErrSynSentBadAck'                         => array(),
    'tcpErrSynRetry'                              => array(),
    'tcpErrFinRetry'                              => array(),
    'tcpErrFinGiveUp'                             => array(),
    'tcpErrFinDup'                                => array(),
    'tcpErrRst'                                   => array(),
    'tcpErrRstNonEst'                             => array(),
    'tcpErrRstOutOfWindow'                        => array(),
    'tcpErrRstInTimewait'                         => array(),
    'tcpErrSvrRetrasmit'                          => array(),
    'tcpErrCltRetrasmit'                          => array(),
    'tcpErrFullRetrasmit'                         => array(),
    'tcpErrPartialRetrasmit'                      => array(),
    'tcpErrSvrOutOfOrder'                         => array(),
    'tcpErrCltOutOfOrder'                         => array(),
    'tcpErrCltHole'                               => array(),
    'tcpErrSvrHole'                               => array(),
    'tcpErrCookiePktSeqReject'                    => array(),
    'tcpErrCookiePktSigReject'                    => array(),
    'tcpErrCookiePktSeqDrop'                      => array(),
    'tcpErrCookiePktMssReject'                    => array(),
    'tcpErrRetransmit'                            => array(),
    'tcpErrRetransmitGiveUp'                      => array(),
    'pcbTotZombieCall'                            => array(),
    'tcpTotSynHeld'                               => array(),
    'tcpTotSynFlush'                              => array(),
    'tcpTotFinWaitClosed'                         => array(),
    'tcpErrAnyPortFail'                           => array(),
    'tcpErrIpPortFail'                            => array(),
    'tcpErrSentRst'                               => array(),
    'tcpErrBadStateConn'                          => array(),
    'tcpErrFastRetransmissions'                   => array(),
    'tcpErrFirstRetransmissions'                  => array(),
    'tcpErrSecondRetransmissions'                 => array(),
    'tcpErrThirdRetransmissions'                  => array(),
    'tcpErrForthRetransmissions'                  => array(),
    'tcpErrFifthRetransmissions'                  => array(),
    'tcpErrSixthRetransmissions'                  => array(),
    'tcpErrSeventhRetransmissions'                => array(),
    'tcpErrDataAfterFin'                          => array(),
    'tcpErrRstThreshold'                          => array(),
    'tcpErrOutOfWindowPkts'                       => array(),
    'tcpErrSynDroppedCongestion'                  => array(),
    'tcpWaitData'                                 => array(),
    'tcpErrStrayPkt'                              => array()
  )
);

// EOF
