<?php

/**
 * Observium
 *
 *   This file is part of Observium.
 *
 * @package    observium
 * @subpackage poller
 * @copyright  (C) 2006-2013 Adam Armstrong, (C) 2013-2019 Observium Limited
 *
 */

$table_defs['NS-ROOT-MIB']['nsSslStatsGroup'] = array (
  'table'     => 'nsSslStatsGroup',
  'mib'       => 'NS-ROOT-MIB',
  'mib_dir'   => 'citrix',
  'file'      => 'netscaler-SslStats.rrd',
  'graphs'    => array('nsSslTransactions', 'nsSslHandshakes', 'nsSslSessions'),
  'ds_rename' => array('sslBeTot' => 'Be', 'sslTot' => '', 'ssl' => '', 'Session' => 'Sess', 'Multiplex' => 'Mplx', 'Attempt' => 'Att',
                       'Success' => 'Succ', 'Authentications' => 'Auths', 'Authorizations' => 'Auths', 'Ciphers' => 'Ciphs',
                       'ReNegotiate' => 'ReNeg', 'Exchanges' => 'Exch'),
  'oids'   => array (
    'sslCardStatus'                => array('ds_type' => 'GAUGE'),
    'sslEngineStatus'              => array('ds_type' => 'GAUGE'),
    'sslSessionsPerSec'            => array('ds_type' => 'GAUGE'),
    'sslTotTransactions'            => array(),
    'sslTotSSLv2Transactions'            => array(),
    'sslTotSSLv3Transactions'            => array(),
    'sslTotTLSv1Transactions'            => array(),
    'sslTotSessions'            => array(),
    'sslTotSSLv2Sessions'            => array(),
    'sslTotSSLv3Sessions'            => array(),
    'sslTotTLSv1Sessions'            => array(),
    'sslTotExpiredSessions'            => array(),
    'sslTotNewSessions'            => array(),
    'sslTotSessionHits'            => array(),
    'sslTotSessionMiss'            => array(),
    'sslTotRenegSessions'            => array(),
    'sslTotSSLv3RenegSessions'            => array(),
    'sslTotTLSv1RenegSessions'            => array(),
    'sslTotSSLv2Handshakes'            => array(),
    'sslTotSSLv3Handshakes'            => array(),
    'sslTotTLSv1Handshakes'            => array(),
    'sslTotSSLv2ClientAuthentications'            => array(),
    'sslTotSSLv3ClientAuthentications'            => array(),
    'sslTotTLSv1ClientAuthentications'            => array(),
    'sslTotRSA512keyExchanges'            => array(),
    'sslTotRSA1024keyExchanges'            => array(),
    'sslTotRSA2048keyExchanges'            => array(),
    'sslTotDH512keyExchanges'            => array(),
    'sslTotDH1024keyExchanges'            => array(),
    'sslTotDH2048keyExchanges'            => array(),
    'sslTotRSAAuthorizations'            => array(),
    'sslTotDHAuthorizations'            => array(),
    'sslTotDSSAuthorizations'            => array(),
    'sslTotNULLAuthorizations'            => array(),
    'sslTot40BitRC4Ciphers'            => array(),
    'sslTot56BitRC4Ciphers'            => array(),
    'sslTot64BitRC4Ciphers'            => array(),
    'sslTot128BitRC4Ciphers'            => array(),
    'sslTot40BitDESCiphers'            => array(),
    'sslTot56BitDESCiphers'            => array(),
    'sslTot168Bit3DESCiphers'            => array(),
    'sslTot40BitRC2Ciphers'            => array(),
    'sslTot56BitRC2Ciphers'            => array(),
    'sslTot128BitRC2Ciphers'            => array(),
    'sslTot128BitIDEACiphers'            => array(),
    'sslTotNULLCiphers'            => array(),
    'sslTotMD5Mac'            => array(),
    'sslTotSHAMac'            => array(),
    'sslTotOffloadBulkDES'            => array(),
    'sslTotOffloadRSAKeyExchanges'            => array(),
    'sslTotOffloadDHKeyExchanges'            => array(),
    'sslTotOffloadSignRSA'            => array(),
    'sslBeTotSessions'            => array(),
    'sslBeTotSSLv3Sessions'            => array(),
    'sslBeTotTLSv1Sessions'            => array(),
    'sslBeExpiredSessions'            => array(),
    'sslBeTotSessionMultiplexAttempts'            => array(),
    'sslBeTotSessionMultiplexAttemptSuccess'            => array(),
    'sslBeTotSessionMultiplexAttemptFails'            => array(),
    'sslBeMaxMultiplexedSessions'            => array('ds_type' => 'GAUGE'),
    'sslBeTotSSLv3Handshakes'            => array(),
    'sslBeTotTLSv1Handshakes'            => array(),
    'sslBeTotSSLv3ClientAuthentications'            => array(),
    'sslBeTotTLSv1ClientAuthentications'            => array(),
    'sslBeTotRSA512keyExchanges'            => array(),
    'sslBeTotRSA1024keyExchanges'            => array(),
    'sslBeTotRSA2048keyExchanges'            => array(),
    'sslBeTotDH512keyExchanges'            => array(),
    'sslBeTotDH1024keyExchanges'            => array(),
    'sslBeTotDH2048keyExchanges'            => array(),
    'sslBeTotRSAAuthorizations'            => array(),
    'sslBeTotDHAuthorizations'            => array(),
    'sslBeTotDSSAuthorizations'            => array(),
    'sslBeTotNULLAuthorizations'            => array(),
    'sslBeTot40BitRC4Ciphers'            => array(),
    'sslBeTot56BitRC4Ciphers'            => array(),
    'sslBeTot64BitRC4Ciphers'            => array(),
    'sslBeTot128BitRC4Ciphers'            => array(),
    'sslBeTot40BitDESCiphers'            => array(),
    'sslBeTot56BitDESCiphers'            => array(),
    'sslBeTot168Bit3DESCiphers'            => array(),
    'sslBeTot40BitRC2Ciphers'            => array(),
    'sslBeTot56BitRC2Ciphers'            => array(),
    'sslBeTot128BitRC2Ciphers'            => array(),
    'sslBeTot128BitIDEACiphers'            => array(),
    'sslBeTotNULLCiphers'            => array(),
    'sslBeTotMD5Mac'            => array(),
    'sslBeTotSHAMac'            => array(),
    'sslCurSessions'            => array('ds_type' => 'GAUGE'),
    'sslTotOffloadBulkAES'            => array(),
    'sslTotOffloadBulkRC4'            => array(),
    'sslNumCardsUP'            => array('ds_type' => 'GAUGE'),
    'sslCards'            => array('ds_type' => 'GAUGE'),
    'sslTotBkendSessionReNegotiate'            => array(),
    'sslTotCipherAES128'            => array(),
    'sslTotBkendSslV3Renego'            => array(),
    'sslTotBkendTlSvlRenego'            => array(),
    'sslTotCipherAES256'            => array(),
    'sslTotBkendCipherAES128'            => array(),
    'sslTotBkendCipherAES256'            => array(),
    'sslTotHwEncBE'            => array(),
    'sslTotDec'            => array(),
    'sslTotSwEncFE'            => array(),
    'sslTotEncFE'            => array(),
    'sslTotEnc'            => array(),
    'sslTotDecHw'            => array(),
    'sslTotSwDecBE'            => array(),
    'sslTotHwDecFE'            => array(),
    'sslTotEncHw'            => array(),
    'sslTotDecSw'            => array(),
    'sslTotSwEncBE'            => array(),
    'sslTotEncSw'            => array(),
    'sslTotSwDecFE'            => array(),
    'sslTotEncBE'            => array(),
    'sslTotDecBE'            => array(),
    'sslTotHwDecBE'            => array(),
    'sslTotDecFE'            => array(),
    'sslTotHwEncFE'            => array(),
    'sslTotRSA4096keyExchanges'            => array(),
    'sslCurQSize'            => array('ds_type' => 'GAUGE'),
    'sslChipReinitCount'            => array(),
    'sslTotECDHE224keyExchanges'            => array(),
    'sslTotECDHE256keyExchanges'            => array(),
    'sslTotECDHE384keyExchanges'            => array(),
    'sslTotECDHE521keyExchanges'            => array(),
    'sslTotTransactionsRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.333)', 'descr' => 'SSL Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslTotSSLv2TransactionsRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.334)', 'descr' => 'SSLv2 Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslTotSSLv3TransactionsRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.335)', 'descr' => 'SSLv3 Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslTotTLSv1TransactionsRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.336)', 'descr' => 'TLSv1 Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslBeTotEcdheCurve521' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.337)', 'descr' => 'Number of back-end ECDHE 521 curve Key exchanges on the NetScaler appliance.'),
    'sslBeTotEcdheCurve384' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.338)', 'descr' => 'Number of back-end ECDHE 384 curve Key exchanges on the NetScaler appliance.'),
    'sslBeTotEcdheCurve256' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.339)', 'descr' => 'Number of back-end ECDHE 256 curve Key exchanges on the NetScaler appliance.'),
    'sslBeTotEcdheCurve224' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.340)', 'descr' => 'Number of back-end ECDHE 224 curve Key exchanges on the NetScaler appliance.'),
    'sslTotTLSv11Handshakes' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.341)', 'descr' => 'Number of SSL handshakes on TLSv1.1 on the NetScaler appliance.'),
    'sslTotTLSv12Handshakes' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.342)', 'descr' => 'Number of SSL handshakes on TLSv1.2 on the NetScaler appliance.'),
    'sslTotTLSv11Transactions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.343)', 'descr' => 'Number of TLSv1.1 transactions on the NetScaler appliance.'),
    'sslTotTLSv12Transactions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.344)', 'descr' => 'Number of TLSv1.2 transactions on the NetScaler appliance.'),
    'sslTotTLSv11Sessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.345)', 'descr' => 'Number of TLSv1.1 sessions on the NetScaler appliance.'),
    'sslTotTLSv12Sessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.346)', 'descr' => 'Number of TLSv1.2 sessions on the NetScaler appliance.'),
    'sslTotTLSv11RenegSessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.347)', 'descr' => 'Number of SSL session renegotiations done on TLSv1.1.'),
    'sslTotTLSv12RenegSessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.348)', 'descr' => 'Number of SSL session renegotiations done on TLSv1.2.'),
    'sslTotTLSv11ClientAuthentications' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.349)', 'descr' => 'Number of client authentications done on TLSv1.1.'),
    'sslTotTLSv12ClientAuthentications' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.350)', 'descr' => 'Number of client authentications done on TLSv1.2.'),
    'sslTotTLSv11TransactionRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.351)', 'descr' => 'TLSv1.1 Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslTotTLSv12TransactionRate' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.352)', 'descr' => 'TLSv1.2 Transactions rate per second.', 'ds_type' => 'GAUGE'),
    'sslTot128BitAESGCMCiphers' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.353)', 'descr' => 'Number of AEC-GCM 128-bit cipher encryptions on the NetScaler appliance.'),
    'sslTot256BitAESGCMCiphers' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.354)', 'descr' => 'Number of AEC-GCM 256-bit cipher encryptions on the NetScaler appliance.'),
    'sslTotOffloadBulkAESGCM128' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.355)', 'descr' => 'Number of AES-GCM 128-bit encryptions offloaded to the cryptography card.'),
    'sslTotOffloadBulkAESGCM256' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.356)', 'descr' => 'Number of AES-GCM 256-bit encryptions offloaded to the cryptography card.'),
    'sslBeTotTLSv11Sessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.357)', 'descr' => 'Number of back-end TLSv1.1 sessions on the NetScaler appliance.'),
    'sslBeTotTLSv12Sessions' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.358)', 'descr' => 'Number of back-end TLSv1.2 sessions on the NetScaler appliance.'),
    'sslBeTotTLSv11Handshakes' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.359)', 'descr' => 'Number of back-end TLSv1.1 handshakes on the NetScaler appliance.'),
    'sslBeTotTLSv12Handshakes' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.360)', 'descr' => 'Number of back-end TLSv1.2 handshakes on the NetScaler appliance.'),
    'sslBeTotTLSv11ClientAuthentications' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.361)', 'descr' => 'Number of back-end TLSv1.1 client authentications on the NetScaler appliance.'),
    'sslBeTotTLSv12ClientAuthentications' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.362)', 'descr' => 'Number of back-end TLSv1.2 client authentications on the NetScaler appliance.'),
    'sslTotBkendTlSv11Renego' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.363)', 'descr' => 'Number of back-end TLSv1.1 session renegotiations on the NetScaler appliance.'),
    'sslTotBkendTlSv12Renego' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.364)', 'descr' => 'Number of back-end TLSv1.2 session renegotiations on the NetScaler appliance.'),
    'sslCryptoUtilization' => array('numeric' => '(1.3.6.1.4.1.5951.4.1.1.47.365)', 'descr' => 'Utilization of the hardware crypto resource. Only valid values are 0-100%. Only works for platform with N3 chips A value of 4294967295 is displayed for a platform without a N3 chip', 'ds_type' => 'GAUGE'),
  )
);

