<?php
/**
 * Observium
 *
 *   This file is part of Observium.
 *
 * @package    observium
 * @subpackage config
 * @copyright  (C) 2006-2013 Adam Armstrong, (C) 2013-2022 Observium Limited
 *
 */

/**

 _________________________________________________________
(  ____   ___    _   _  ___ _____   _____ ____ ___ _____  )
( |  _ \ / _ \  | \ | |/ _ \_   _| | ____|  _ \_ _|_   _| )
( | | | | | | | |  \| | | | || |   |  _| | | | | |  | |   )
( | |_| | |_| | | |\  | |_| || |   | |___| |_| | |  | |   )
( |____/ \___/  |_| \_|\___/ |_|   |_____|____/___| |_|   )
(                                                         )
(  _____ _   _ ___ ____    _____ ___ _     _____          )
( |_   _| | | |_ _/ ___|  |  ___|_ _| |   | ____|         )
(   | | | |_| || |\___ \  | |_   | || |   |  _|           )
(   | | |  _  || | ___) | |  _|  | || |___| |___          )
(   |_| |_| |_|___|____/  |_|   |___|_____|_____|         )
(                                                         )
 ---------------------------------------------------------
        o   ^__^
         o  (oo)\_______
            (__)\       )\/\
                ||----w |
                ||     ||



 * DO NOT edit this file -- make changes to the configuration array in config.php
 * Also, DO NOT copy simply this file to config.php.
 * Only place the configuration options you are changing into config.php
 *
 * Even better, use the web-based configuration system!
*/

error_reporting(E_ERROR | E_PARSE | E_CORE_ERROR | E_COMPILE_ERROR);

/** @global array $config */
//$config = [];

// Database settings

// FIXME. Migrate to $config['db']['option']
#$config['db_extension']     = 'mysqli';    // The PHP MySQL extension to use ('mysql' or 'mysqli')
#$config['db_port']          = '';          // MySQL port (leave blank for default port: 3306)
#$config['db_socket']        = '';          // Path to the socket (leave blank for default socket)
#$config['db_persistent']    = FALSE;       // Whether persistent connections should be used or not. WARNING use at own risk!
#$config['db_compress']      = FALSE;       // Use compressed protocol for the MySQL connection
// Optionally SSL (only for MySQLi)
$config['db_ssl']           = FALSE;       // If TRUE mysql connection uses ssl (only available with mysqli engine)
$config['db_ssl_verify']    = TRUE;        // disables SSL certificate validation on mysqlnd
#$config['db_ssl_key']       = '';          // path to ssl key file
#$config['db_ssl_cert']      = '';          // path to ssl certificate file
#$config['db_ssl_ca']        = '';          // path to ssl ca file
#$config['db_ssl_ca_path']   = '';          // path to ca files
#$config['db_ssl_ciphers']   = '';          // allowed ciphers to use for ssl connection

$config['db']['debug']      = TRUE;        // If TRUE store errors in DB queries into logs/db.log

#$config['db_host']          = 'localhost'; // DB hostname (default: localhost)
#$config['db_user']          = 'USERNAME';
#$config['db_pass']          = 'PASSWORD';
#$config['db_name']          = 'observium'; // DB base name (default: observium)

// Default directories

#$config['install_dir']   = "/opt/observium";
#$config['html_dir']      = $config['install_dir'] . "/html";
#$config['rrd_dir']       = $config['install_dir'] . "/rrd";
#$config['template_dir']  = $config['install_dir'] . "/templates";
#$config['log_file']      = $config['install_dir'] . "/observium.log";
#$config['log_dir']       = $config['install_dir'] . "/logs";
#$config['temp_dir']      = "/tmp";
#$config['cache_dir']     = $config['temp_dir']    . "/observium_cache";
#$config['nagplug_dir']   = '/usr/lib/nagios/plugins'; // Debian/Ubuntu
#$config['nagplug_dir']   = '/usr/lib64/nagios/plugins'; // CentOS/RedHat/Fedora

// What is my own hostname (used so observium can identify its host in its own database)
#$config['own_hostname'] = "localhost"; // By default equals `hostname -f`

// Location of executables

$config['rrdtool']        = "/usr/bin/rrdtool";
$config['fping']          = "/usr/bin/fping";
$config['fping6']         = "/usr/bin/fping6"; // Note, for version 4+ not required
$config['snmpwalk']       = "/usr/bin/snmpwalk";
$config['snmpget']        = "/usr/bin/snmpget";
$config['snmpgetnext']    = "/usr/bin/snmpgetnext";
$config['snmpbulkget']    = "/usr/bin/snmpbulkget";
$config['snmpbulkwalk']   = "/usr/bin/snmpbulkwalk";
$config['snmptranslate']  = "/usr/bin/snmptranslate";
$config['whois']          = "/usr/bin/whois";
$config['mtr']            = "/usr/bin/mtr";
$config['nmap']           = "/usr/bin/nmap";
$config['ipmitool']       = "/usr/bin/ipmitool";
$config['virsh']          = "/usr/bin/virsh";
$config['dot']            = "/usr/bin/dot";
$config['unflatten']      = "/usr/bin/unflatten";
$config['neato']          = "/usr/bin/neato";
$config['sfdp']           = "/usr/bin/sfdp";
$config['svn']            = "/usr/bin/svn";
$config['git']            = "/usr/bin/git"; // Used in show device config feature for git-enabled repos and rancid >= 3.2
$config['wmic']           = "/bin/wmic";
$config['file']           = "/usr/bin/file";
$config['wc']             = "/usr/bin/wc";
$config['sudo']           = "/usr/bin/sudo";
$config['tail']           = "/usr/bin/tail";
$config['cut']            = "/usr/bin/cut";
$config['tr']             = "/usr/bin/tr";



// RRD Format Settings

// NOTE: These should not normally be changed
// Though one could conceivably increase or decrease the size of each RRA if one had performance problems
// Or if one had a very fast I/O subsystem with no performance worries.

// These settings make quite large RRDs.
// They store 4 years of 1-day resolution data.

// Default Poller Interval (in seconds)
$config['rrd']['step'] = 300;

// http://eccentric.slavery.cx/misc/rrdcalc.html
// 185kB per DS                           7 days of 5 min          62 days of 30 min       120 days of 2 hour       4 years of 1 day
$config['rrd']['rra_300']['default']   = "RRA:AVERAGE:0.5:1:2016   RRA:AVERAGE:0.5:6:2976  RRA:AVERAGE:0.5:24:1440  RRA:AVERAGE:0.5:288:1440 ";
$config['rrd']['rra_300']['default']  .= "                         RRA:MIN:0.5:6:1440      RRA:MIN:0.5:96:360       RRA:MIN:0.5:288:1440 ";
$config['rrd']['rra_300']['default']  .= "                         RRA:MAX:0.5:6:1440      RRA:MAX:0.5:96:360       RRA:MAX:0.5:288:1440 ";
// 925kB per DS                           93 days of 5 min         187.5 days of 30 min    366 days of 2 hour       4 years of 1 day
$config['rrd']['rra_300']['accurate']  = "RRA:AVERAGE:0.5:1:26784  RRA:AVERAGE:0.5:6:9000  RRA:AVERAGE:0.5:24:4392  RRA:AVERAGE:0.5:288:1460 ";
$config['rrd']['rra_300']['accurate'] .= "                         RRA:MIN:0.5:6:9000      RRA:MIN:0.5:24:4392      RRA:MIN:0.5:288:1460 ";
$config['rrd']['rra_300']['accurate'] .= "                         RRA:MAX:0.5:6:9000      RRA:MAX:0.5:24:4392      RRA:MAX:0.5:288:1460 ";

// 468kB per DS                           7 days of 1 min        14 days of 5 min         62 days of 30 min        120 days of 2 hour       4 years of 1 day
$config['rrd']['rra_60']['default']   = "RRA:AVERAGE:0.5:1:10080 RRA:AVERAGE:0.5:5:4032   RRA:AVERAGE:0.5:30:2976  RRA:AVERAGE:0.5:120:1440  RRA:AVERAGE:0.5:1440:1440 ";
$config['rrd']['rra_60']['default']  .= "                                                 RRA:MIN:0.5:30:1440      RRA:MIN:0.5:120:360       RRA:MIN:0.5:1440:1440 ";
$config['rrd']['rra_60']['default']  .= "                                                 RRA:MAX:0.5:30:1440      RRA:MAX:0.5:120:360       RRA:MAX:0.5:1440:1440 ";
// 1212kB per DS                         7 days of 1 min         93 days of 5 min         187.5 days of 30 min     366 days of 2 hour        4 years of 1 day
$config['rrd']['rra_60']['accurate']  = "RRA:AVERAGE:0.5:1:10080 RRA:AVERAGE:0.5:5:26784  RRA:AVERAGE:0.5:30:9000  RRA:AVERAGE:0.5:120:4392  RRA:AVERAGE:0.5:1440:1460 ";
$config['rrd']['rra_60']['accurate'] .= "                        RRA:MIN:0.5:5:26784      RRA:MIN:0.5:30:9000      RRA:MIN:0.5:120:4392      RRA:MIN:0.5:1440:1460 ";
$config['rrd']['rra_60']['accurate'] .= "                        RRA:MAX:0.5:5:26784      RRA:MAX:0.5:30:9000      RRA:MAX:0.5:120:4392      RRA:MAX:0.5:1440:1460 ";

$config['rrd']['rra']  = $config['rrd']['rra_300']['default'];

// RRDCacheD - Make sure it can write to your RRD dir!
#$config['rrdcached']    = "unix:/var/run/rrdcached.sock";
$config['rrd']['cache'] = TRUE;         // Use extra caching for remote RRDcacheD. WARNING. Don't change this until you know what you are doing

$config['rrd_override'] = TRUE;         // Allow adding of devices if RRD directory already exists.

// Debugging / Profiling Settings

$config['profile_sql']            = FALSE;   // Store MySQL queries and performance data.
$config['snmp']['hide_auth']      = TRUE;    // If TRUE hide SNMPv1/2 community and SNMPv3 auth from debug and web output
$config['snmp']['errors']         = TRUE;    // Collect and (auto)disable snmp queries with invalid response (empty/broken/etc)
//$config['ping']['debug']        = TRUE;    // If TRUE store ping errors into logs/debug.log file
//$config['syslog']['debug']      = TRUE;    // If TRUE store RAW syslog lines into logs/debug.log file
//$config['rrd']['debug']         = TRUE;    // If TRUE store RRD errors in logs/rrd.log
//$config['debug_port'][0]        = TRUE;    // List of port IDs for debug (each port ID as key), written to /tmp/port_debug_ID.txt
$config['debug_port']['spikes']   = FALSE;   // Additional only spikes debug, written to /tmp/port_debug_spikes.txt
$config['unix-agent']['debug']    = TRUE;    // Store raw unix-agent output. See it on device showtech page
$config['check_process']['alerter'] = TRUE;  // Ability for skip process checking. USE AT OWN RISK.
$config['alerts']['reduce_db_updates'] = FALSE; // Ability for reduce updates in alert_table. This option disable update last_ok and broke "alert duration" USE AT OWN RISK.
$config['web_debug_unprivileged'] = FALSE;   // Allow show debug information for Unprivileged (userlevel < 7) users in Web UI
$config['php_debug']              = FALSE;   // Store all php errors in logs/php-error.log

$config['require_hostname']       = FALSE;   // If TRUE, devices must have valid resolvable hostname (in DNS or /etc/hosts)
$config['use_ip']                 = FALSE;   // If TRUE, snmp and other services request device by resolved ip instead hostname

// Web Interface Settings

#$config['base_url']        = "http://localhost/";    // Not recommend change this, only if autodetect wrong. Used in WUI
#$config['web_url']         = "http://localhost:80/"; // This same as base_url but used only in cli for example in alerts

$config['mono_font']         = "DroidSansMono,DejaVuSansMono";
$config['favicon']           = "images/observium-icon.png";
$config['page_refresh']      = "300";     // Refresh the page every xx seconds, 0 to disable
$config['front_page']        = "pages/front/default.php";
$config['page_title_prefix'] = "Observium";
$config['page_title_suffix'] = "";
$config['page_title_separator'] = ' - ';
$config['timestamp_format']  = 'Y-m-d H:i:s';
$config['date_format']       = 'Y-m-d';
$config['login_message']     = "Unauthorised access or use shall render the user liable to criminal and/or civil prosecution.";
$config['login_remember_me'] = TRUE;        // Enable or disable the remember me feature.

// User editable settings
$config['web_mouseover']     = TRUE;        // Enable or disable mouseover popups.
$config['web_mouseover_mobile'] = FALSE;    // Enable mouseover popups on Mobile phones and tablets. Disabled by default.
$config['web_show_disabled'] = TRUE;        // Show or not disabled devices on major pages.
$config['web_device_name']   = 'hostname';  // Default name to display device name. Allowed: hostname, sysname, purpose/description
$config['web_pagesize']      = 100;         // Default pagesize for tables (items per page)
$config['web_theme_default'] = 'light';     // Default theme 'light', 'dark', 'darkblue' or 'system' (based on MacOS/Windows system settings)

$config['web_session_lifetime']     = 86400;     // Default user sessions lifetime in seconds (86400 - one day). This lifetime actual for sessions without "remember me" checkbox.
$config['web_session_ip']           = TRUE;      // Bind user sessions to his IP address
$config['web_session_ipv6_prefix']  = 128;       // Bind user session to prefix limited IPv6 address
$config['web_session_cidr']         = [];        // Allow user authorisation from certain IP ranges (if empty allow from any)
$config['web_session_ip_by_header'] = FALSE;     // Allow to use alternative Remote Address header for Session Auth (DANGEROUS)
$config['web_remote_addr_header']   = 'default'; // Remote Address header for Web session logging (CF-Connecting-IP, X-Real-IP, Client-IP, X-Forwarded-For)

$config['web_enable_showtech']	= FALSE;    // Enable display of 'show tech' menu option. Currently only for device entries.

$config['web_show_bgp_asdot']   = FALSE;    // Display BGP 32bit ASNs in asdot format (ie 5.20 instead 327700)

$config['show_overview_tab']    = TRUE;     // FIXME. Not sure, still required?
$config['overview_show_sysDescr'] = TRUE;   // FIXME. Not sure, still required?


// Graphs Settings

$config['rrdgraph_real_95th']             = FALSE;     // Set to TRUE if you want to display the 95% based on the highest value. (aka real 95%)
$config['graphs']['style']                = "default"; // Possible values: default, mrtg
$config['graphs']['size']                 = 'normal';  // Possible values: normal, big
$config['graphs']['ports_scale_force']    = 1;         // Force scale also if real data more than selected scale
$config['graphs']['ports_scale_default']  = "auto";    // Possible values: auto, speed, scales from $config['graphs']['ports_scale_list']
$config['graphs']['ports_scale_list']     = [ '100Gbit', '50Gbit', '40Gbit', '25Gbit', '10Gbit', '5Gbit', '2.5Gbit', '1Gbit', '100Mbit', '10Mbit' ];
$config['graphs']['stacked_processors']   = TRUE;
$config['graphs']['always_draw_max']      = FALSE;     // Allow suppression of MAX region for aesthetic reasons on graphs < 1 week long

$config['int_customers']           = 1;  // Enable Customer Port Parsing
$config['int_customers_graphs' ]   = 1;  // Enable Customer Port List Graphs
$config['int_transit']             = 1;  // Enable Transit Types
$config['int_peering']             = 1;  // Enable Peering Types
$config['int_core']                = 1;  // Enable Core Port Types
$config['int_l2tp']                = 0;  // Enable L2TP Port Types
$config['int_groups']              = array();  // Custom Interface Types

$config['show_locations']          = 1;  // Enable Locations on menu
$config['ports_page_default']      = "details"; // eg "details" or "basic"

// PING Settings - Retries/Timeouts (default timeout same as for fping)
$config['ping']['retries'] = 3;             // How many times to retry ping (1 - 10)
$config['ping']['timeout'] = 500;           // Timeout in milliseconds (50 - 2000)

// SNMP Settings - Timeouts/Retries disabled by default (this is same as in net-snmp)
#$config['snmp']['timeout']    = 1;          // timeout in seconds
#$config['snmp']['retries']    = 5;          // how many times to retry the query
$config['snmp']['max-rep']    = FALSE;      // allow use of -Cr in snmpbulkwalk vastly increasing walk speed
$config['snmp']['version']    = "v2c";      // Default version to use

// SNMPv1/2c default settings
$config['snmp']['community'][0] = "public"; // Communities to try during adding hosts and discovery

// SNMPv3 default settings
// The array can be expanded to give another set of parameters
$config['snmp']['v3'] = array();
// $config['snmp']['v3'][0]['authlevel']  = "noAuthNoPriv"; // noAuthNoPriv | authNoPriv | authPriv
// $config['snmp']['v3'][0]['authname']   = "observium";    // User Name (required even for noAuthNoPriv)
// $config['snmp']['v3'][0]['authpass']   = "";             // Auth Passphrase
// $config['snmp']['v3'][0]['authalgo']   = "MD5";          // MD5 | SHA | SHA-224 | SHA-256 | SHA-384 | SHA-512
// $config['snmp']['v3'][0]['cryptopass'] = "";             // Privacy (Encryption) Passphrase
// $config['snmp']['v3'][0]['cryptoalgo'] = "AES";          // DES | AES | AES-192 | AES-192-C | AES-256 | AES-256-C

// Autodiscovery Settings

$config['autodiscovery']['xdp']            = TRUE;   // Autodiscover hosts via discovery protocols (CDP, LLDP, FDP, AMAP and other)
$config['autodiscovery']['ospf']           = TRUE;   // Autodiscover hosts via OSPF
$config['autodiscovery']['bgp']            = TRUE;   // Autodiscover hosts via iBGP
$config['autodiscovery']['bgp_as_private'] = FALSE;  //Autodiscovery hosts via eBGP a Private AS (64512 - 65535)
$config['autodiscovery']['bgp_as_whitelist'] = array(); // Array of ASNs we will try to auto-discover hosts for. (eg for confederations).
$config['autodiscovery']['snmp_scan']      = TRUE;   // Autodiscover hosts via SNMP scanning - currently not implemented. (FIXME)
$config['autodiscovery']['libvirt']        = TRUE;   // Autodiscover hosts found via libvirt
$config['autodiscovery']['vmware']         = TRUE;   // Autodiscover hosts found via vmware
$config['autodiscovery']['proxmox']        = FALSE;  // Autodiscover hosts found via Proxmox VE agent app (beware timeouts during poller!)
$config['autodiscovery']['ip_nets']        = [ "127.0.0.0/8", "192.168.0.0/16", "10.0.0.0/8", "172.16.0.0/12" ];  // Networks to permit autodiscovery
$config['autodiscovery']['ping_skip']      = FALSE;  // Skip icmp echo checks during autodiscovery (beware timeouts during discovery!)
$config['autodiscovery']['recheck_interval'] = 86400; // If host is found, but it is not discovered by any reason, the interval, when you can try another check (default 24 hours)
$config['autodiscovery']['require_hostname'] = TRUE; // If TRUE, devices must have valid resolvable hostname (in DNS or /etc/hosts)

// Mailer backend Settings

$config['email']['enable']          = TRUE;                 // Enable/Disable email globally
$config['email']['from']            = NULL;                 // Mail from. Default: "Observium" <observium@`hostname`>
$config['email']['default']         = NULL;                 // Default alert recipient
$config['email']['default_only']    = FALSE;                // Only use default recipient (all alerts send to default recipient)
$config['email']['default_syscontact'] = FALSE;             // By default always sent alerts by device sysContact email
$config['email']['graphs']          = TRUE;                 // Allow graphs in mail body
$config['email']['backend']         = 'mail';               // Mail backend. Allowed: "mail" (PHP's built-in), "sendmail", "smtp", "mx".
// sendmail backend specific options
$config['email']['sendmail_path']   = '/usr/sbin/sendmail'; // The location of the sendmail program.
// smtp backend specific options
$config['email']['smtp_host']       = 'localhost';          // Outgoing SMTP server name.
$config['email']['smtp_port']       = 25;                   // The port to connect.
$config['email']['smtp_timeout']    = 10;                   // SMTP connection timeout in seconds.
$config['email']['smtp_secure']     = NULL;                 // Enable encryption. Use 'tls' or 'ssl'
$config['email']['smtp_auth']       = FALSE;                // Whether or not to use SMTP authentication.
$config['email']['smtp_username']   = NULL;                 // SMTP username.
$config['email']['smtp_password']   = NULL;                 // Password for SMTP authentication.

// Kannel SMSBox settings

$config['smsbox']['scheme']   = 'http';                 // URL scheme, http or https.
$config['smsbox']['host']     = 'localhost';            // Name of host on which SMSBox is running.
$config['smsbox']['port']     = '13013';                // Port number on which SMSBox host receives requests.
$config['smsbox']['user']     = 'kannel';               // SMSBox username.
$config['smsbox']['password'] = '';                     // SMSBox password.
$config['smsbox']['from']     = '';                     // Phone number of sender, usually overridden by SMSC.

// Alerting Settings

$config['alerts']['bgp']['whitelist']      = NULL;      // Populate as an array() with ASNs to alert on.

$config['alerts']['interval']              = 86400;     // How frequently to re-send a notification for a continuing alert condition
                                                        // In seconds. Default is 1 day.

$config['alerts']['suppress']              = FALSE;     // Suppress all notifications.
$config['alerts']['disable']['all']        = FALSE;     // Disable all notifications.

// Poller wrapper settings
#$config['poller-wrapper']['threads']       = 0;         // The number of poller threads that should run simultaneously. Default: CPU count x 2
$config['poller-wrapper']['max_running']   = 4;         // The number of maximum allowed simultaneously running wrapper processes. This prevents race and too high LA on server
$config['poller-wrapper']['max_la']        = 10;        // Maximum allowed server Load Average for run wrapper processes. This prevents race and too high LA on server
$config['poller-wrapper']['alerter']       = TRUE;      // Execute alerter.php after poller.php
$config['poller-wrapper']['stats']         = TRUE;      // Enable poller wrapper statistics in RRD (can be seen at page http://your_observium/pollerlog/)

$config['uptime_warning']                  = "86400";   // Time in seconds to display a "Device Rebooted" Alert. 0 to disable warnings.

// HTTP/HTTPS options
#$config['http_ip_version']                 = '4';       // In dual stack environment, preferred IPv6 requests, for force specify IP version (4/6)
// FIXME - make sure this doens't break if it's set to FALSE, and set it to false, rather than commenting it.
#$config['http_proxy'] = "yourproxy:80";                // Proxy for HTTP/HTTPS requests (e.g. for geocoding)
#$config['proxy_user'] = '';                            // Proxy username (basic auth)
#$config['proxy_password'] = '';                        // Proxy password
#$config['proxy_fulluri'] = TRUE;                       // Proxy Full URI. Default TRUE, because mostly required by Squid.

// Carbon/Ceres/StatsD configuration

$config['statsd']['enable']                = FALSE;
$config['statsd']['host']                  = '127.0.0.1';
$config['statsd']['port']                  = '8125';

// Data caching
$config['cache']['enable']                 = FALSE;     // Can enable/disable caching
$config['cache']['enable_cli']             = TRUE;      // Can enable/disable caching in CLI (used for fast remote rrdcaching)
$config['cache']['ttl']                    = 300;       // Default time to live for cache objects (5 min)
$config['cache']['driver']                 = 'auto';    // Driver for use caching (auto, zendshm, apcu, sqlite, files)

// amqp Configuration
// This is very alpha, please do not use it unless you want it to eat your children

$config['amqp']['enable']                  = FALSE;
$config['amqp']['conn']['host']            = "localhost";
$config['amqp']['conn']['port']            = "5672";
$config['amqp']['conn']['user']            = "guest";
$config['amqp']['conn']['pass']            = "guest";
$config['amqp']['conn']['vhost']           = "/";
$config['amqp']['conn']['debug']           = FALSE;
$config['amqp']['proxy']['host']           = "localhost";
$config['amqp']['proxy']['port']           = "36603";

$config['amqp']['modules']['ports']        = TRUE;
$config['amqp']['modules']['sensors']      = TRUE;
$config['amqp']['modules']['processor']    = TRUE;
$config['amqp']['modules']['mempools']     = TRUE;

// Geocoding Configuration

$config['geocoding']['enable']             = TRUE;                  // Enable Geocoding
$config['geocoding']['api']                = 'geocodefarm';         // Which GEO API use ('geocodefarm', 'arcgis', 'google', 'mapquest', 'openstreetmap', 'yandex')
#$config['geocoding']['api_key']            = '';                   // API KEY if required (deprecated)
$config['geocoding']['dns']                = FALSE;                 // Use DNS LOC records for geolocation
$config['geocoding']['default']['lat']     =  "37.7463058";         // Default latitude
$config['geocoding']['default']['lon']     =  "-25.6668573";        // Default longitude

// GEO API keys (this options in definitions, here just copied for know which user editable)

//$config['geo_api']['geocodefarm']['enable']    = TRUE;
//$config['geo_api']['geocodefarm']['key']       = '';

//$config['geo_api']['google']['enable']         = TRUE;
//$config['geo_api']['google']['key']            = '';

//$config['geo_api']['yandex']['enable']         = TRUE;
//$config['geo_api']['yandex']['key']            = '';

//$config['geo_api']['mapquest']['enable']       = TRUE;
//$config['geo_api']['mapquest']['key']          = '';

// Location
$config['location']['menu']['type'] = 'geocoded'; // geocoded, nested, plain
$config['location']['menu']['nested_reversed'] = FALSE; // set to TRUE if your locations are most-to-least significant
$config['location']['menu']['nested_split_char'] = ','; // splitting character for nested location hierarchy
$config['location']['menu']['nested_max_depth'] = 4; // maximum levels in nested location hierarchy

// Location Mapping
// Use this feature to map ugly locations to pretty locations
// Here KEY must exactly match to device sysLocation
//$config['location']['map']['Under the Sink']          = "Under The Sink, The Office, London, UK";
// Here KEY is regular expression
//$config['location']['map_regexp']['/Under the Sink/'] = "Under The Sink, The Office, London, UK";
//$config['location']['map_regexp']['/^$/']             = "Some Empty Location Rewrite";


// Cosmetics

$config['rrdgraph']['light']  = "-c BACK#EEEEEE00 -c SHADEA#EEEEEE00 -c SHADEB#EEEEEE00 -c FONT#000000 -c CANVAS#FFFFFF00";
$config['rrdgraph']['light'] .= " -c GRID#a5a5a5 -c MGRID#FF9999 -c FRAME#5e5e5e -c ARROW#5e5e5e -R normal";

$config['rrdgraph']['dark']  = "-c BACK#00000000 -c SHADEA#00000000 -c SHADEB#00000000 -c FONT#CCCCCC -c CANVAS#00000000";
$config['rrdgraph']['dark'] .= " -c GRID#ffffff00 -c MGRID#ffffff10 -c FRAME#CCCCCC -c AXIS#BBBBBB -c ARROW#BBBBBB -R normal";

#$config['graph_colours'] = [ "000066","330066","990066","990066","CC0033","FF0000" ]; // Purple to Red
#$config['graph_colours'] = [ "006600","336600","996600","996600","CC3300","FF0000" ]; // Green to Red
#$config['graph_colours'] = [ "002200","004400","006600","008800","00AA00","00CC00" ]; // Green
#$config['graph_colours'] = [ "220000","440000","660000","880000","AA0000","CC0000" ]; // Red
#$config['graph_colours'] = [ "001122","002244","003366","004488","0055AA","0066CC" ]; // Blue
#$config['graph_colours'] = [ "002233","004466","006699","0088CC","0099FF" ];          // Sky-Blue
#$config['graph_colours'] = [ "110022","330066","440088","6600AA","8800FF" ];          // Purple
#$config['graph_colours'] = [ "002200","004400","006600","008800","00AA00","00AA00","00CC00" ]; // Forest Greens

// FIXME. How to see palete: https://javier.xyz/cohesive-colors/?src=A6CEE3,1F78B4,B2DF8A,33A02C,FB9A99,E31A1C,FDBF6F,FF7F00,CAB2D6,6A3D9A&overlay=FF9C00&intensity=0.31
$config['graph_colours']['mixed-5']   = [ '1F78B4', '33A02C', 'E31A1C', 'FF7F00', '6A3D9A' ];
$config['graph_colours']['mixed-6']   = [ '1F78B4', '33A02C', 'E31A1C', 'FF7F00', '6A3D9A', 'B15928' ];
$config['graph_colours']['mixed-7']   = [ 'CC0000', '008C00', '4096EE', '73880A', 'F03F5C', '36393D', 'FF0084' ]; // old mixed                  // CC0000,008C00,4096EE,73880A,F03F5C,36393D,FF0084
$config['graph_colours']['mixed-10']  = [ 'A6CEE3', '1F78B4', 'B2DF8A', '33A02C', 'FB9A99', 'E31A1C', 'FDBF6F', 'FF7F00', 'CAB2D6', '6A3D9A' ]; // A6CEE3,1F78B4,B2DF8A,33A02C,FB9A99,E31A1C,FDBF6F,FF7F00,CAB2D6,6A3D9A
$config['graph_colours']['mixed-10b'] = [ 'A6CEE3', 'B2DF8A', 'FB9A99', 'FDBF6F', 'CAB2D6', '1F78B4', '33A02C', 'E31A1C', 'FF7F00', '6A3D9A' ]; // A6CEE3,B2DF8A,FB9A99,FDBF6F,CAB2D6,1F78B4,33A02C,E31A1C,FF7F00,6A3D9A
$config['graph_colours']['mixed-10c'] = [ '1F78B4', '33A02C', 'E31A1C', 'FF7F00', '6A3D9A', 'A6CEE3', 'B2DF8A', 'FB9A99', 'FDBF6F', 'CAB2D6' ]; // 1F78B4,33A02C,E31A1C,FF7F00,6A3D9A,A6CEE3,B2DF8A,FB9A99,FDBF6F,CAB2D6
$config['graph_colours']['mixed-q12'] = [ '8DD3C7', 'FFFFB3', 'BEBADA', 'FB8072', '80B1D3', 'FDB462', 'B3DE69', 'FCCDE5', 'D9D9D9', 'BC80BD', 'CCEBC5', 'FFED6F' ];
$config['graph_colours']['mixed-18']  = [ '365C81', 'D8929F', 'A99DCB', '6CA4D5', '8BA15F', 'E9CA5D', 'DF9933', 'D33627', '881C45', 'C74379', '9B2F82', '345AA8', '88C3C9', '519466', 'A7C662', 'BA723D', '864A23', '253371' ];
$config['graph_colours']['mixed']     = $config['graph_colours']['mixed-18'];

$config['graph_colours']['oranges']   = [ 'FFC344', 'FCB53D', 'F9A836', 'F69A2F', 'F48D28', 'F17F22', 'EE721B', 'EC6414', 'E9570D', 'E64906', 'E43C00' ];
$config['graph_colours']['greens']    = [ 'B6D14B', 'A4C445', '92B73F', '80AA39', '6E9D33', '5C902E', '4A8328', '387622', '26691C', '145C16', '034F11' ];
$config['graph_colours']['reds']      = [ 'FF7373', 'F66767', 'ED5C5C', 'E45050', 'DB4545', 'D23939', 'C92E2E', 'C02222', 'B71616', 'AE0B0B', 'A60000' ];
$config['graph_colours']['pinks']     = [ 'E881B1', 'DE76A7', 'D46C9D', 'CA6293', 'C15889', 'B74E7F', 'AD4475', 'A43A6B', '9A3061', '902657', '871C4E' ];
$config['graph_colours']['blues']     = [ 'A0A0E5', '9090D3', '8080C1', '7070AF', '60609D', '50508C', '40407A', '303068', '1F1F56', '0F0F44', '000033' ];
$config['graph_colours']['purples']   = [ 'CC7CCC', 'BD6FBD', 'AF63AF', 'A156A1', '934A93', '853E85', '773177', '692569', '5B185B', '4D0C4D', '3F003F' ];
$config['graph_colours']['peach']     = [ 'FC998C', 'F38E81', 'EA8476', 'E1796B', 'D86F61', 'CF6456', 'C65A4B', 'BD4F41', 'B44536', 'AB3A2B', 'A23021' ];
$config['graph_colours']['yellow']    = [ 'FFD683', 'FACF79', 'F5C970', 'F0C267', 'EBBC5D', 'E6B554', 'E1AF4B', 'DCA841', 'D7A238', 'D29B2F', 'CD9526' ];
$config['graph_colours']['red2']      = [ 'FD627A', 'F05870', 'E34E66', 'D7455C', 'CA3B52', 'BE3248', 'B1283E', 'A41E34', '98152A', '8B0B20', '7F0216' ];
$config['graph_colours']['bluegrey']  = [ 'CFD8DC', 'B0BEC5', '90A4AE', '78909C', '607D8B', '546E7A', '455A64', '37474F', '263238' ];
$config['graph_colours']['lgreen']    = [ 'C5E1A5', '33691E' ];
$config['graph_colours']['reds_8']    = [ 'FEE0D2', 'FCBBA1', 'FC9272', 'FB6A4A', 'EF3B2C', 'CB181D', 'A50F15', '67000D' ];
$config['graph_colours']['default']   = $config['graph_colours']['blues'];

$config['graph_colours']['juniperive'] = [ 'F7C729', '52A6EF' ];
$config['graph_colours']['percents']  = [ '55FF00', '00FFD5', '00D5FF', '00AAFF', '0080FF', '0055FF', '0000FF', '8000FF', 'D400FF', 'FF00D4', 'FF0080', 'FF0000' ];

// Uniform "data" graph colours

$config['colours']['graphs']['data'] = ['in_area'  => '84BB5C', 'in_line'  => '357F44', 'in_max'  => 'C4E5AC60',
                                        'out_area' => '7394CB', 'out_line' => '284C7F', 'out_max' => 'ACC2E560'];

$config['colours']['graphs']['pkts'] = ['in_area'  => 'AA66AA', 'in_line'  => '553355', 'in_max'  => 'CC88CC60',
                                        'out_area' => 'FFDD88', 'out_line' => 'FF6600', 'out_max' => 'FFEFAA60'];

$config['colours']['graphs']['errors'] = ['in_area'  => 'FF3300CC', 'in_line'  => 'FF3300', 'in_max'  => 'FF330060',
                                          'out_area' => 'FF6633CC', 'out_line' => 'FF6633', 'out_max' => 'FF330060'];


$config['group_colours'][] = [ 'in' => 'blues',  'out' => 'purples' ];
$config['group_colours'][] = [ 'in' => 'greens', 'out' => 'greens' ];
$config['group_colours'][] = [ 'in' => 'reds',   'out' => 'oranges' ];
$config['group_colours'][] = [ 'in' => 'blues',  'out' => 'purples' ];
$config['group_colours'][] = [ 'in' => 'greens', 'out' => 'greens' ];
$config['group_colours'][] = [ 'in' => 'reds',   'out' => 'oranges' ];

// Front page settings

// General settings
$config['frontpage']['eventlog']['items']          = 15;           // Only show the last XX items of the eventlog view
$config['frontpage']['syslog']['items']            = 25;           // Only show the last XX items of the syslog view
$config['frontpage']['syslog']['priority']         = [ 'emerg','alert','crit','err','warning','notice' ]; // Show syslog entries only with this priorities (default: Notification)

// Map overview settings
$config['frontpage']['map']['api']                 = "carto";      // Set to google-mc if you have a lot of devices. (Allowed: carto, google, google-mc)
// Options common for any map apis.
$config['frontpage']['map']['center']['lat']       = "auto";       // Latitude center of map, default 'auto'
$config['frontpage']['map']['center']['lng']       = "auto";       // Longitude center of map, default 'auto'
$config['frontpage']['map']['zoom']                = "auto";       // Initial zoom level (2: min zoom, 10: max zoom),
$config['frontpage']['map']['zooms_per_click']     = 1;            // The google-mc map is optimized for a big touchscreen. Set this higher to zoom more aggressively.
// Options for old google map api.
$config['frontpage']['map']['region']              = "world";      // See https://developers.google.com/chart/interactive/docs/gallery/geochart for region settings
$config['frontpage']['map']['resolution']          = "countries";  // Some region types such as US States (US-NY) require this to be changed to "provinces"
$config['frontpage']['map']['dotsize']             = 10;           // Set the dotsize you want
$config['frontpage']['map']['realworld']           = false;        // Enable/Disable the realworld view (blue/green), if disabled default map view
$config['frontpage']['map']['height']              = 400;          // Default Google map height
$config['frontpage']['map']['clouds']              = false;         // Enable the clouds layer
// Options for carto and other leaflet map api providers.
$config['frontpage']['map']['tiles']               = 'carto-base-light';

$config['frontpage']['map']['okmarkersize']             = 24;           // Set the dotsize you want
$config['frontpage']['map']['alertmarkersize']          = 32;           // Set the dotsize you want


// Device status settings
// Show the status messages you want
$config['frontpage']['device_status']['max']['interval'] = 24;     // Maximal interval for which to display devices status (in hours)
$config['frontpage']['device_status']['max']['count'] = 200;       // Maximal count for which to display devices status (in items)
$config['frontpage']['device_status']['devices']   = true;         // Show the down devices
$config['frontpage']['device_status']['ports']     = true;         // Show the down ports
$config['frontpage']['device_status']['neighbours'] = true;        // Show the down inter-device neighbours (with CDP/LLDP linked devices)
$config['frontpage']['device_status']['errors']    = true;         // Show the ports with interface errors
$config['frontpage']['device_status']['services']  = false;        // Show the down services
$config['frontpage']['device_status']['bgp']       = true;         // Show the bgp status
$config['frontpage']['device_status']['uptime']    = true;         // Show the uptime status

// Custom traffic graphs
$config['frontpage']['custom_traffic']['ids']      = "";           // COMMA SEPARATED PORT ID FOR EXAMPLE: "1,2,3,4,5"
$config['frontpage']['custom_traffic']['title']    = "";           // Your own title for the custom traffic graphs

// Custom mini graphs
$config['frontpage']['minigraphs']['ids']          = "";           // Comma and semicolon separated array list, first the device id or graph id followed by the image type and the text header you want (example: "2,device_processor,CPU Usage;10,diskio_bits,IOPS")
$config['frontpage']['minigraphs']['legend']       = false;        // Enable/Disable the legend on custom mini graph view
$config['frontpage']['minigraphs']['title']        = "Mini Graphs Overview";
$config['frontpage']['minigraphs']['width']        = 210;
$config['frontpage']['minigraphs']['height']       = 100;

// Custom micro graphs
//$config['frontpage']['micrographs']['GROUPNAME']['ids']        = "";             // Comma and semicolon separated array list, first the device id or graph id followed by the image type and the text header you want (example: "2,device_processor,CPU Usage;10,diskio_bits,IOPS"); text header may be empty
//$config['frontpage']['micrographs']['GROUPNAME']['legend']     = false;          // Enable/Disable the legend on custom micro graph view; not used unless you make the size quite large
//$config['frontpage']['micrographs']['GROUPNAME']['title']      = "GROUP TITLE";  // may be empty string
$config['frontpage']['micrograph_settings']['width']           = 125;
$config['frontpage']['micrograph_settings']['height']          = 30;

// Frontpage order you can use: status_summary, map, device_status_boxes, overall_traffic, custom_traffic, minigraphs, splitlog, syslog, eventlog
$config['frontpage']['order']           = [ 'status_summary', 'map', 'device_status_boxes', 'device_status', 'eventlog' ];


// Enable version checker & stats
$config['version_check']                = 1; // Enable checking of version in discovery
                                             // and submittal of basic stats used
                                             // to prioritise development effort :)

$config['version_check_revs']           = 100; // How many revisions to wait before we notify about new releases

$config['version_check_days']           = 30;  // How many days to wait before we notify about new releases

// Poller/Discovery Modules

$config['enable_bgp']                   = 1; // Enable BGP session collection and display
$config['enable_rip']                   = 1; // Enable RIP session collection and display
$config['enable_ospf']                  = 1; // Enable OSPF session collection and display
$config['enable_isis']                  = 1; // Enable ISIS session collection and display
$config['enable_eigrp']                 = 1; // Enable EIGRP session collection and display
$config['enable_syslog']                = 0; // Enable Syslog
$config['enable_vrfs']                  = 1; // Enable VRFs
$config['enable_sla']                   = 1; // Enable SLA/RPM collection and display
$config['enable_pseudowires']           = 1; // Enable Pseudowires

// Billing System Configuration

$config['enable_billing']               = 0; // Enable Billing
$config['billing']['customer_autoadd']  = 0; // Enable Auto-add bill per customer
$config['billing']['circuit_autoadd']   = 0; // Enable Auto-add bill per circuit_id
$config['billing']['bill_autoadd']      = 0; // Enable Auto-add bill per bill_id
$config['billing']['base']              = 1000; // Set the base to divider bytes to kB, MB, GB ,... (1000|1024)

// External Integration

// Rancid
#$config['rancid_version']               = '2'; // In generate-rancid.php use delimeter ':' (by default) and ';' for v3
#$config['rancid_configs'][]             = '/var/lib/rancid/network/configs/';
#$config['rancid_suffix']                = 'yourdomain.com'; // Domain suffix for non-FQDN device names
$config['rancid_ignorecomments']        = 0; // Ignore lines starting with #
$config['rancid_revisions']             = 10; // Show such last count revisions in device page

// Collectd
#$config['collectd_dir']                 = '/var/lib/collectd/rrd';

// Smokeping
#$config['smokeping']['dir']             = '/var/lib/smokeping/';
$config['smokeping']['split_char']      = '_';
#$config['smokeping']['master_hostname'] = 'smokeping.yourdomain.com';
#$config['smokeping']['suffix']          = '.yourdomain.com';
#$config['smokeping']['slaves'][] = 'slave01'; // Used in the generate-smokeping script only

// Weathermap Builtin
//$config['weathermap']['enable']          = TRUE; // Enable Builtin PHP Weathermap

// NFSen RRD dir.
$config['nfsen_enable'] = 0;
#$config['nfsen_split_char']   = "_";
#$config['nfsen_rrds']   = "/var/nfsen/profiles-stat/live/";
#$config['nfsen_prefix']   = "";
#$config['nfsen_suffix']   = "_yourdomain_com";

// Entities specific config options

$config['devices']['serverscheck']['temp_f']  = FALSE; // Specifies that any ServersCheck devices will return temperature sensors in Fahrenheit.

// Ignore sysNames in discovery or associations
$config['devices']['ignore_sysname'][]        = '(none)';
$config['devices']['ignore_sysname'][]        = 'unknown';
$config['devices']['ignore_sysname'][]        = '(unknown)';
$config['devices']['ignore_sysname'][]        = 'default';
$config['devices']['ignore_sysname'][]        = 'default_config';
$config['devices']['ignore_sysname'][]        = 'defaultname';
$config['devices']['ignore_sysname'][]        = 'defaulthost';
$config['devices']['ignore_sysname'][]        = 'host';
$config['devices']['ignore_sysname'][]        = 'localhost';
$config['devices']['ignore_sysname'][]        = 'target';
$config['devices']['ignore_sysname'][]        = 'vxtarget';
$config['devices']['ignore_sysname'][]        = 'tp-link';
$config['devices']['ignore_sysname'][]        = 'd-link';
$config['devices']['ignore_sysname'][]        = 'mikrotik';
$config['devices']['ignore_sysname'][]        = 'heartofgold';
$config['devices']['ignore_sysname'][]        = 'openwrt';
$config['devices']['ignore_sysname'][]        = 'rt-is-prober';
$config['devices']['ignore_sysname'][]        = 'dd-wrt';
$config['devices']['ignore_sysname'][]        = 'router';
$config['devices']['ignore_sysname'][]        = 'switch';
$config['devices']['ignore_sysname'][]        = 'ubnt';
$config['devices']['ignore_sysname'][]        = 'ubnt edgeswitch';
$config['devices']['ignore_sysname'][]        = 'huawei';
$config['devices']['ignore_sysname'][]        = 'internet';
$config['devices']['ignore_sysname'][]        = 'sonicwall';
$config['devices']['ignore_sysname'][]        = 'firewall';
$config['devices']['ignore_sysname'][]        = 'm0n0wall';
$config['devices']['ignore_sysname'][]        = 'zywall';

$config['sensors']['port']['power_to_dbm']    = FALSE; // Convert power Port DOM sensors to dBm
$config['sensors']['port']['ignore_shutdown'] = TRUE;  // Set ignore sensor state instead alert for entities in shutdown state (admin down)
$config['sensors']['limits_events']           = FALSE; // Store sensors limit changes in eventlog

// Ignores & Allows
// Has to be lowercase

// FIXME. Migrate to regex for correct ignores
$config['bad_if'][] = "voip-null";
$config['bad_if'][] = "virtual-";
$config['bad_if'][] = "unrouted";
$config['bad_if'][] = "eobc";
$config['bad_if'][] = "lp0";
$config['bad_if'][] = "-atm";
$config['bad_if'][] = "faith0";
$config['bad_if'][] = "container";
$config['bad_if'][] = "async";
$config['bad_if'][] = "plip";
$config['bad_if'][] = "-physical";
$config['bad_if'][] = "bluetooth";
$config['bad_if'][] = "isatap";
//$config['bad_if'][] = "ras"; // FIXME. Need to see exactly interfaces and use regexp, currently incorrectly ignore "infrastructure"
$config['bad_if'][] = "qos";
$config['bad_if'][] = "span rp";
$config['bad_if'][] = "span sp";
$config['bad_if'][] = "sslvpn";
$config['bad_if'][] = "pppoe-";
$config['bad_if'][] = "ovs-system";
$config['bad_if'][] = "BRG-ET"; // Bridged Ethernet on Juniper
#$config['bad_if'][] = "control plane";  // Example for cisco control plane

// FIXME. Rename to $config['ports']['ignore_name_regexp']
$config['bad_if_regexp'][] = "/^ng[0-9]+$/i";
$config['bad_if_regexp'][] = "/^sl[0-9]/i";
$config['bad_if_regexp'][] = "/^<(none|invalid)>$/i";              // calix: <none>, <invalid>
$config['bad_if_regexp'][] = "/^<(invalid|ethportany):[\d-]+>$/i"; // calix: <INVALID:0-0-0-1-0-0-0-4-91-219>, <EthPortAny:0-0-0-0-0-0-0-0-0-0>
$config['bad_if_regexp'][] = "/^(ZTPCONFIG|TopoNode|SYSLOG)=/i";   // iqnos: ZTPCONFIG=ZTPCFG, TopoNode=1.1.1.1, SYSLOG=SYSLOG-1

// Ignore ports based on ifType. Case-sensitive.
// FIXME. Rename to $config['ports']['ignore_type']
$config['bad_iftype'][] = "voiceEncap";
$config['bad_iftype'][] = "voiceEM";
#$config['bad_iftype'][] = "voiceFXO";  // show Voice Foreign Exchange Office
#$config['bad_iftype'][] = "voiceFXS";  // show Voice Foreign Exchange Station
$config['bad_iftype'][] = "voiceOverAtm";
$config['bad_iftype'][] = "voiceOverFrameRelay";
$config['bad_iftype'][] = "voiceOverIp";
$config['bad_iftype'][] = "ds0";
$config['bad_iftype'][] = "ds1";
$config['bad_iftype'][] = "ds3";
#$config['bad_iftype'][] = "isdn";       //show signaling traffic
#$config['bad_iftype'][] = "lapd";       //show signaling traffic
#$config['bad_iftype'][] = "sonet";      //show sonet interfaces
$config['bad_iftype'][] = "atmSubInterface"; // Cisco IOS
$config['bad_iftype'][] = "aal5";            // Cisco IOS
$config['bad_iftype'][] = "shdsl";
$config['bad_iftype'][] = "mpls";
$config['bad_iftype'][] = "usb";        // Ignore USB pseudo interface (BSD)

// Ignore ports based on ifAlias
// FIXME. Rename to $config['ports']['ignore_alias_regexp']
$config['bad_ifalias_regexp'] = array();

$config['ports']['ignore_errors_iftype'] = ['ieee80211'];

// Neighbour discovery/autodiscovery options
// Ignore discover remote devices via discovery protocols (CDP, LLDP, FDP, AMAP and other)
// Note. Hostname ignored by both neighbours discovery and autodiscovery new device,
//       platform ignored only by autodiscovery
#$config['xdp']['ignore_hostname'][]       = "badhost.donotwant"; // by hostname
#$config['xdp']['ignore_hostname_regex'][] = "/^SIP.*/";          // by hostname regex
#$config['xdp']['ignore_hostname_regex'][] = "/^$/";
#$config['xdp']['ignore_hostname_regex'][] = "/^mikrotik$/";
$config['xdp']['ignore_platform'][]       = "Cisco IP Phone";    // by platform (not case sensitive)
#$config['xdp']['ignore_platform'][]       = "Cisco AIR-CAP";
#$config['xdp']['ignore_platform'][]       = "Cisco AIR-LAP";
$config['xdp']['ignore_platform_regex'][] = "/^Not received$/";  // by platform  regex
$config['xdp']['ignore_platform_regex'][] = "/^SIP\-CP\d+/";


// Filesystems ignore
// FIXME. Rename to $config['storages']['ignore_removable']
// FIXME. Rename to $config['storages']['ignore_network']
// FIXME. Rename to $config['storages']['ignore_optical']
$config['ignore_mount_removable']  = 1; // Ignore removable disk storage
$config['ignore_mount_network']    = 1; // Ignore network mounted storage
$config['ignore_mount_optical']    = 1; // Ignore mounted optical discs

// FIXME. Rename to $config['storages']['ignore_mount']
$config['ignore_mount'][] = "/kern";
$config['ignore_mount'][] = "/mnt/cdrom";
$config['ignore_mount'][] = "/proc";
$config['ignore_mount'][] = "/dev";
$config['ignore_mount'][] = "/dev/shm";
$config['ignore_mount'][] = "/run";

// FIXME. Rename to $config['storages']['ignore_mount_string']
$config['ignore_mount_string'][] = "packages";
$config['ignore_mount_string'][] = "devfs";
$config['ignore_mount_string'][] = "procfs";
$config['ignore_mount_string'][] = "UMA";
$config['ignore_mount_string'][] = "MALLOC";

// FIXME. Rename to $config['storages']['ignore_mount_regexp']
$config['ignore_mount_regexp'][] = '/on: (\/\.mount)?\/packages/';  // /dev/md5.uzip, mounted on: /.mount/packages/mnt/py-base32-26e85274
$config['ignore_mount_regexp'][] = '/on: \/dev/';                   // devfs: dev file system, mounted on: /dev
$config['ignore_mount_regexp'][] = '/on: (\/\.mount)?\/proc/';      // procfs: process file system, mounted on: /.mount/proc
$config['ignore_mount_regexp'][] = '/on: (\/\.mount)?\/tmp/';       // tmpfs, mounted on: /.mount/tmp
$config['ignore_mount_regexp'][] = '/on: \/junos^/';
$config['ignore_mount_regexp'][] = '/on: \/junos\/dev/';
$config['ignore_mount_regexp'][] = '/on: \/jail\/dev/';
$config['ignore_mount_regexp'][] = '/^(dev|proc)fs/';               // devfs: dev file system, mounted on: /.mount/dev
$config['ignore_mount_regexp'][] = '/^\/dev\/md0/';
$config['ignore_mount_regexp'][] = '/^\/var\/dhcpd\/dev,/';
$config['ignore_mount_regexp'][] = '/UMA/';
$config['ignore_mount_regexp'][] = '!/\.snapshot!';         // Netapp: dfFileSys.10:-->/vol/volssg2/.snapshot
$config['ignore_mount_regexp'][] = '/dfc#\d+\-bootflash/';  // Cisco DFC bootflash is used for the crash files, always free
$config['ignore_mount_regexp'][] = '/^DFC/';
$config['ignore_mount_regexp'][] = '/^\/run\//';
$config['ignore_mount_regexp'][] = '/^\/sys\//';


// Mempools ignore
// FIXME. Rename to $config['mempools']['ignore_name']
// FIXME. Rename to $config['mempools']['ignore_name_string']
// FIXME. Rename to $config['mempools']['ignore_name_regexp']
#$config['ignore_mempool'][] = 'EXAMPLE';
#$config['ignore_mempool'][] = 'Cached Memory';
#$config['ignore_mempool'][] = 'Shared Memory';
#$config['ignore_mempool'][] = 'Physical Memory';
#$config['ignore_mempool_string'][] = 'EXAMPLE';
$config['ignore_mempool_string'][] = 'MEMPOOL_GLOBAL_SHARED'; // Ignored for cisco virtualised platforms
$config['ignore_mempool_regexp'][] = '/ - (reserved|image)$/';
$config['ignore_mempool_regexp'][] = '/ \((reserved|image)\)$/';


// Processors ignore
// FIXME. Rename to $config['processors']['ignore_name']
// FIXME. Rename to $config['processors']['ignore_name_string']
// FIXME. Rename to $config['processors']['ignore_name_regexp']
#$config['ignore_processor'][] = 'EXAMPLE';
#$config['ignore_processor_string'][] = 'EXAMPLE';
#$config['ignore_processor_regexp'][] = '/^ExampleCPU$/';

// Sensors ignore
// FIXME. Rename to $config['sensors']['ignore_name']
// FIXME. Rename to $config['sensors']['ignore_name_string']
// FIXME. Rename to $config['sensors']['ignore_name_regexp']
#$config['ignore_sensor'][] = 'EXAMPLE';
#$config['ignore_sensor_string'][] = 'EXAMPLE';
// OSR-7600 Clock FRU 1 OK Sensor - Clock 1 OK Sensor
// OSR-7600 Clock FRU 1 In Using Sensor - Clock 1 In Using Sensor
$config['ignore_sensor_regexp'][] = '/(OSR\-7600|C6K) Clock FRU \d/'; // Always ignore Cisco Clock 2 sensors
// Chassis 2 clock 2 clock-inuse Sensor
$config['ignore_sensor_regexp'][] = '/^Chassis \d+ clock \d clock/';

// Toner ignore
// FIXME. Rename to $config['toners']['ignore_name']
// FIXME. Rename to $config['toners']['ignore_name_string']
// FIXME. Rename to $config['toners']['ignore_name_regexp']
#$config['ignore_toner'][] = 'EXAMPLE';
#$config['ignore_toner_string'][] = 'EXAMPLE';
#$config['ignore_toner_regexp'][] = '/^Fuchsia$/';

// Common subnet ignore
$config['ignore_common_subnet'][] = '127.0.0.1/32';   // Common on Juniper
$config['ignore_common_subnet'][] = '127.0.0.0/8';    // Common on Linux
$config['ignore_common_subnet'][] = '127.0.0.0/16';   // Common on ZyXEL
$config['ignore_common_subnet'][] = '169.254.0.0/16'; // DHCP fallback range
#$config['ignore_common_subnet'][] = '128.0.0.1/32';  // Common on Juniper
#$config['ignore_common_subnet'][] = '128.0.1.16/32'; // Common on Juniper
$config['ignore_common_subnet'][] = '::/0';
$config['ignore_common_subnet'][] = '::/64';
$config['ignore_common_subnet'][] = '::1/128';        // Common on Linux

// Per-device interface graph filters (this regex always case-insensitive)

$config['device_traffic_iftype'][] = '/loopback/';
$config['device_traffic_iftype'][] = '/tunnel/';
$config['device_traffic_iftype'][] = '/virtual/';
$config['device_traffic_iftype'][] = '/mpls/';
$config['device_traffic_iftype'][] = '/ieee8023adLag/';
$config['device_traffic_iftype'][] = '/l2vlan/';
$config['device_traffic_iftype'][] = '/ppp/';
$config['device_traffic_iftype'][] = '/propMultiplexor/';

$config['device_traffic_descr'][]  = '/loopback/';
$config['device_traffic_descr'][]  = '/vlan/';
$config['device_traffic_descr'][]  = '/tunnel/';
#$config['device_traffic_descr'][]  = '/:\d+/';   #// this breaks on xos (ifName = 1:1)
$config['device_traffic_descr'][]  = '/^bond\d+/'; // Linux
$config['device_traffic_descr'][]  = '/^team\d+/'; // Linux
$config['device_traffic_descr'][]  = '/null/';
$config['device_traffic_descr'][]  = '/dummy/';
$config['device_traffic_descr'][]  = '/^dwdm/';

// IP address options
// Ignore IP address discovery by type
$config['ip-address']['ignore_type'][] = 'unspecified'; // ::, 0.0.0.0
$config['ip-address']['ignore_type'][] = 'broadcast';   // IPv4 Broadcasts
$config['ip-address']['ignore_type'][] = 'link-local';  // IPv6 Link Local fe80::200:5aee:feaa:20a2

// IRC Bot configuration

$config['irc_host'] = "irc.oftc.net";
$config['irc_port'] = 6667;
$config['irc_nick'] = "Observium" . mt_rand(1, 99999);
$config['irc_chan'][] = "";
$config['irc_chankey'] = "";
$config['irc_ssl'] = FALSE;

// Authentication

$config['allow_unauth_graphs']      = 0;       // Allow graphs to be viewed by anyone
$config['allow_unauth_graphs_cidr'] = array(); // Allow graphs to be viewed without authorisation from certain IP ranges
$config['auth_mechanism']           = "mysql"; // Available mechanisms: mysql (default), ldap, radius, http-auth

$config['auth']['remote_user'] = FALSE;        // Trust Apache server to authenticate user, READ DOCUMENTATION FIRST!!

// LDAP Authentication

$config['auth_ldap_version'] = 3;                     // LDAP client version (2 or 3)
$config['auth_ldap_referrals'] = 0;                   // Follow LDAP referrals
$config['auth_ldap_server'] = "ldap.yourserver";      // LDAP server name, or array of LDAP server names tried in order.
#$config['auth_ldap_ad_domain'] = "ad.yourcorp";      // AD domain name (fqdn form), used to determine DCs if server list is unset
$config['auth_ldap_port']   = 389;                    // LDAP server port
$config['auth_ldap_starttls'] = 'no';                 // Use STARTTLS ('no', 'optional' or 'require')
$config['auth_ldap_recursive'] = TRUE;                // Active Directory recursive lookup for nested groups
$config['auth_ldap_recursive_maxdepth'] = 3;          // Max depth for recursive lookup
$config['auth_ldap_prefix'] = "uid=";
$config['auth_ldap_suffix'] = ",ou=People,dc=example,dc=com";
#$config['auth_ldap_group']  = [ "cn=observium,ou=groups,dc=example,dc=com" ];
$config['auth_ldap_groupbase'] = "ou=groups,dc=example,dc=com";
$config['auth_ldap_groupreverse'] = FALSE;            // Enable/disable resolving of group memberships using the 'memberOf' attribute on the user

$config['auth_ldap_binddn'] = "";                     // Initial LDAP bind dn and password, leave empty for anonymous bind
$config['auth_ldap_bindpw'] = "";
$config['auth_ldap_bindanonymous'] = FALSE;

$config['auth_ldap_attr']['uid'] = "uid";             // LDAP attribute containing the user login name
$config['auth_ldap_attr']['uidNumber'] = "uidNumber"; // LDAP attribute containing the numeric user ID
$config['auth_ldap_attr']['cn'] = "cn";               // LDAP attribute containing the user's full name
$config['auth_ldap_attr']['dn'] = "dn";               // LDAP attribute containing the user's DN
$config['auth_ldap_attr']['memberOf'] = "memberOf";   // LDAP attribute containing the user's associated group DN's
$config['auth_ldap_attr']['group'] = "group";         // LDAP attribute containing the group name, can be 'group', 'groupOfNames', 'groupOfUniqueNames'

$config['auth_ldap_objectclass'] = "posixAccount";    // objectClass to filter out valid users, use * for all objects under ldap_suffix tree

$config['auth_ldap_groupmembertype'] = "nodn";        // Available membertypes: 'nodn' (default, uses $username);
                                                      // 'fulldn' ($config['auth_ldap_prefix'] . $username . $config['auth_ldap_suffix'])
$config['auth_ldap_groupmemberattr'] = "memberUid";   // Use your unique attribute for username, example "uniqueMember".

// Assign user levels to certain LDAP groups
#$config['auth_ldap_groups']['admin']['level']  = 10; // Full administrative access
#$config['auth_ldap_groups']['cto']['level']     = 7; // Global read access with secured info (ie rancid configs)
#$config['auth_ldap_groups']['pfy']['level']     = 5; // Global read access
#$config['auth_ldap_groups']['support']['level'] = 1; // Only login access, for access to devices/entities require bind entity permissions

// RADIUS Authentication
$config['auth_radius_server']  = [ '127.0.0.1' ]; // RADIUS server list
$config['auth_radius_port']    = 1812;               // Server port
$config['auth_radius_timeout'] = 5;                  // Timeout in seconds
$config['auth_radius_retries'] = 2;                  // Number of retries to reconnect to RADIUS server

$config['auth_radius_id']      = '';                 // RADIUS NAS Identifier (if empty, used local hostname)
$config['auth_radius_nas_address'] = '';             // RADIUS NAS IP Address (if empty, used server ip address)
$config['auth_radius_secret']  = 'secret';           // RADIUS authentication secret
$config['auth_radius_method']  = 'PAP';              // Authentication method to use: PAP (default, unencrypted), CHAP (windows radius not supported), MSCHAPv1, MSCHAPv2

// Assign user levels to certain RADIUS groups
$config['auth_radius_groupmemberattr'] = 'Filter-Id';  // Attribute number or name containing the name of a group. Allowed: Filter-Id (11), Reply-Message (18)
#$config['auth_radius_groups']['admin']['level']  = 10; // Full administrative access
#$config['auth_radius_groups']['cto']['level']     = 7; // Global read access with secured info (ie rancid configs)
#$config['auth_radius_groups']['pfy']['level']     = 5; // Global read access
#$config['auth_radius_groups']['support']['level'] = 1; // Only login access, for access to devices/entities require bind entity permissions

// Syslog Settings

$config['syslog']['unknown_hosts']    = FALSE;       // Allow collect syslog messages from unknown hosts (Work in Progress)

$config['syslog']['timestamp']        = 'system';    // Use timestamp from Observium system or from syslog server.
                                                     // You can set this param to number of seconds,
                                                     // when diff timestams of system and syslog greater this use syslog (instead system)

// Mapping (unknown) syslog hosts to device (id or hostname)
//$config['syslog']['host_map']['localhost'] = 'my.device.name'; // device hostname/sysname
//$config['syslog']['host_map']['127.0.0.1'] = 1;                // or device id
// Mapping syslog hosts by regexps, see examples:
//$config['syslog']['host_map_regexp']['/^(\w[^\.\s]+)$/'] = '$1.mydomain.com'; // host -> host.mydomain.com
//$config['syslog']['host_map_regexp']['/^(\S+)-re\d+/']   = '$1';              // junos-re0 -> junos

$config['syslog']['filter'][]         = 'last message repeated';
$config['syslog']['filter'][]         = 'Connection from UDP: [';
$config['syslog']['filter'][]         = 'ipSystemStatsTable node ipSystemStatsOutFragOKs not implemented';
$config['syslog']['filter'][]         = 'diskio.c';  // Ignore some crappy stuff from SNMP daemon
$config['syslog']['filter'][]         = '/run/user/lightdm/gvfs: Permission denied';
$config['syslog']['filter'][]         = "Could not open output pipe '/dev/xconsole'";

$config['syslog']['fifo']             = FALSE;       // Set this to a FIFO to take input from FIFO

// Realtime graph settings
$config['realtime_interval'] = 2; // Default interval when not set in per-os definitions (seconds)

// Housekeeping settings

/**
 * Minumum allowed age 24 hours (except 'deleted_ports')
 * For ages you can use values such as 31d, 240h, 1.5d etc.
 * Accepted age scales are:
 * y (years), M (months), w (weeks), d (days), h (hours), m (minutes), s (seconds)
 * NOTE, for month use CAPITAL 'M'
 * By default, age in numeric value are seconds
 */

$config['housekeeping']['syslog']['age'] = '1M';         // Maximum age of syslog entries; 0 to disable
$config['housekeeping']['eventlog']['age'] = '6M';       // Maximum age of event log entries; 0 to disable
$config['housekeeping']['alertlog']['age'] = '6M';       // Maximum age of alert log entries; 0 to disable
$config['housekeeping']['authlog']['age'] = '1Y';        // Maximum age of authlog entries; 0 to disable
$config['housekeeping']['inventory']['age'] = '1M';      // Maximum age of deleted inventory entries; 0 to disable
$config['housekeeping']['deleted_ports']['age'] = '1M';  // Maximum age of deleted ports before automatically purging; 0 to disable
$config['housekeeping']['rrd']['age'] = '3M';            // Maximum age of unused rrd files before automatically purging; 0 to disable
$config['housekeeping']['rrd']['notmodified'] = TRUE;    // Delete .rrd files not modified more than age (eg removed entities)
$config['housekeeping']['rrd']['invalid'] = TRUE;        // Delete .rrd files that are not valid RRD files (eg created with a full disk)
$config['housekeeping']['rrd']['deleted'] = FALSE;       // Delete rrd dirs for not exist hostnames (deleted from db)
$config['housekeeping']['rrd']['disabled'] = FALSE;      // Delete rrd dirs for disabled devices (device still in db, but disabled by some reasons)

// Virtualization

$config['enable_libvirt'] = 0; // Enable Libvirt VM support
$config['libvirt_protocols']    = [ "qemu+ssh","xen+ssh" ]; // Mechanisms used, add or remove if not using this on any of your machines.

// Unix Agent settings
$config['unix-agent']['port']       = 36602; // Default agent port

// WMI poller settings
$config['wmi']['domain']    = "";             // Shorthand Domain/Workgroup (ie. NOT domain.local.com)
$config['wmi']['realm']     = "";             // FQDN
$config['wmi']['user']      = "";             // Username
$config['wmi']['pass']      = "";             // Password
$config['wmi']['delimiter'] = "##";           // Wouldn't change
$config['wmi']['namespace'] = "root\CIMV2";   // Wouldn't change

$config['wmi']['modules']['os']           = 1;
$config['wmi']['modules']['processors']   = 1;
$config['wmi']['modules']['storage']      = 1;
$config['wmi']['modules']['winservices']  = 1;
$config['wmi']['modules']['exchange']     = 0;
$config['wmi']['modules']['mssql']        = 0;
$config['wmi']['service_permit'] = array();

// Hardcoded ASN descriptions
$config['astext'][65332] = "Cymru FullBogon Feed";
$config['astext'][65333] = "Cymru Bogon Feed";

/* WIP. Base template for convert modules config
$config['modules']['system']['description']               = 'Device system information (ie location, contact, hardware, version, others)';
$config['modules']['system']['poller']                    = 1;
//$config['modules']['system']['discovery']                 = 0; // Not exist

$config['modules']['processes']['description']            = 'List of running processes on device';
$config['modules']['processes']['poller']                 = 0;
//$config['modules']['processes']['discovery']              = 0; // Not exist
*/

// List of poller modules. Need to be in the array to be
// considered for execution.
// NOTE. Modules 'os', 'system' is base and run always.

$config['poller_modules']['system']                       = 1;
$config['poller_modules']['os']                           = 1;
$config['poller_modules']['unix-agent']                   = 0;
$config['poller_modules']['wmi']                          = 0;
$config['poller_modules']['ipmi']                         = 1;
$config['poller_modules']['sensors']                      = 1;
$config['poller_modules']['status']                       = 1;
$config['poller_modules']['counter']                      = 1;
$config['poller_modules']['processors']                   = 1;
$config['poller_modules']['mempools']                     = 1;
$config['poller_modules']['storage']                      = 1;
$config['poller_modules']['netstats']                     = 1;
$config['poller_modules']['ucd-mib']                      = 1;
$config['poller_modules']['ipSystemStats']                = 1;
$config['poller_modules']['ports']                        = 1;
$config['poller_modules']['bgp-peers']                    = 1;
$config['poller_modules']['junose-atm-vp']                = 1;
$config['poller_modules']['printersupplies']              = 1;
$config['poller_modules']['ucd-diskio']                   = 1;
$config['poller_modules']['wifi']                         = 1;
$config['poller_modules']['p2p-radios']                   = 1;
$config['poller_modules']['ospf']                         = 1;
$config['poller_modules']['cisco-ipsec-flow-monitor']     = 1;
$config['poller_modules']['cisco-remote-access-monitor']  = 1;
$config['poller_modules']['cisco-cef']                    = 1;
$config['poller_modules']['sla']                          = 1;
$config['poller_modules']['lsp']                          = 0;
$config['poller_modules']['pseudowires']                  = 1;
$config['poller_modules']['mac-accounting']               = 1;
$config['poller_modules']['arista-software-ip-forwarding']= 1;
$config['poller_modules']['cipsec-tunnels']               = 1;
$config['poller_modules']['loadbalancer']                 = 1;
$config['poller_modules']['cisco-cbqos']                  = 1;
$config['poller_modules']['cisco-eigrp']                  = 1;
$config['poller_modules']['aruba-controller']             = 1;
$config['poller_modules']['entity-physical']              = 1;
$config['poller_modules']['applications']                 = 1;
$config['poller_modules']['fdb-table']                    = 1;
$config['poller_modules']['graphs']                       = 1;
$config['poller_modules']['oids']                         = 1;
$config['poller_modules']['cisco-vpdn']                   = 0;
$config['poller_modules']['probes']                       = 1;

// List of discovery modules. Need to be in this array to be
// considered for execution.

$config['discovery_modules']['os']                        = 1;
$config['discovery_modules']['mibs']                      = 1; // Discovery supported additional MIBs by sysORID or definition checks
$config['discovery_modules']['vrf']                       = 1; // Must be before all other modules (ie ports, ip-addresses)
$config['discovery_modules']['ports']                     = 1;
$config['discovery_modules']['ports-stack']               = 1;
$config['discovery_modules']['vlans']                     = 1;
$config['discovery_modules']['oids']                      = 1;
$config['discovery_modules']['ip-addresses']              = 1;
$config['discovery_modules']['processors']                = 1;
$config['discovery_modules']['mempools']                  = 1;
$config['discovery_modules']['inventory']                 = 1; // Inventory should be before sensors
$config['discovery_modules']['printersupplies']           = 1; // Printer Supplies should be before sensors
//$config['discovery_modules']['outlets']                   = 1; // Outlets should be before sensors
$config['discovery_modules']['sensors']                   = 1;
$config['discovery_modules']['storage']                   = 1;
$config['discovery_modules']['neighbours']                = 1;
$config['discovery_modules']['arp-table']                 = 1;
$config['discovery_modules']['junose-atm-vp']             = 1;
$config['discovery_modules']['bgp-peers']                 = 1; // Must be after ip-addresses
$config['discovery_modules']['mac-accounting']            = 1;
#$config['discovery_modules']['cisco-cef']                = 1;
$config['discovery_modules']['sla']                       = 1;
$config['discovery_modules']['lsp']                       = 0;
$config['discovery_modules']['pseudowires']               = 1;
$config['discovery_modules']['virtual-machines']          = 1;
$config['discovery_modules']['cisco-cbqos']               = 1;
$config['discovery_modules']['ucd-diskio']                = 1;
$config['discovery_modules']['wifi']                      = 1;
$config['discovery_modules']['p2p-radios']                = 1;
$config['discovery_modules']['graphs']                    = 1;
$config['discovery_modules']['raid']                      = 0;

// Ports extension modules

$config['port_descr_parser']                              = "includes/port-descr-parser.inc.php"; // Parse port descriptions into fields
$config['port_descr_regexp']                              = [ "/^(?<type>\w+):\s*(?<descr>\w[^\[\(\{]*)(\s*\[(?<speed>.+)\])?(\s*\((?<notes>.+)\))?(\s*\{(?<circuit>.+)\})?/" ];
$config['enable_ports_etherlike']                      = 0; // Enable Polling EtherLike-MIB (doubles interface processing time)
$config['enable_ports_junoseatmvp']                    = 0; // Enable JunOSe ATM VC Discovery/Poller
$config['enable_ports_adsl']                           = 1; // Enable ADSL-LINE-MIB
$config['enable_ports_vlan']                           = 1; // Enable Vlan collection
$config['enable_ports_fdbcount']                       = 0; // Enable count of FDB per-port.
$config['enable_ports_ipifstats']                      = 1; // Enable graphing of IP-MIB::ipIfStats.
$config['enable_ports_jnx_cos_qstat']                  = 1; // Enable graphing of CoS queues per-port.
$config['enable_ports_sros_egress_qstat']              = 1; // Enable graphing of egress queues per-port.
$config['enable_ports_sros_ingress_qstat']             = 1; // Enable graphing of ingress queues per-port.
$config['enable_ports_64bit']                          = 1; // Prefer 64bit counters.
$config['enable_ports_separate_walk']                  = 0; // Walk separate IF-MIB tables instead global ifEntry, ifXEntry

// Observium WIP API Settings
$config['api']['enable']                        = FALSE;        // Enable or disable the API

// Enable or disable specific API endpoint
$config['api']['endpoints']['alerts']           = 1;
$config['api']['endpoints']['bills']            = 1;
$config['api']['endpoints']['devices']          = 1;
$config['api']['endpoints']['ports']            = 1;
$config['api']['endpoints']['sensors']          = 1;
$config['api']['endpoints']['status']           = 1;
$config['api']['endpoints']['probes']           = 1;
$config['api']['endpoints']['counters']         = 1;
$config['api']['endpoints']['storage']          = 1;
$config['api']['endpoints']['mempools']         = 1;
$config['api']['endpoints']['processors']       = 1;
$config['api']['endpoints']['address']          = 1;
$config['api']['endpoints']['printersupplies']  = 1;
$config['api']['endpoints']['inventory']        = 1;
$config['api']['endpoints']['neighbours']       = 1;
$config['api']['endpoints']['vlans']            = 1;

// InfluxDB export

$config['influxdb']['enabled']                    = FALSE;     // Enable or disable posting data to InfluxDB
$config['influxdb']['debug']                      = FALSE;     // If true, just write updates to /tmp
$config['influxdb']['server']                     = 'localhost:8086'; // Where is InfluxDB listening?
$config['influxdb']['db']                         = 'observium'; // Which InfluxDB database?

// Unsupported settings

$config['short_hostname']['length']   = 12; // Alter short_hostname() target length, changing this is not officially supported!
$config['short_port_descr']['length'] = 22;
$config['experimental'] = FALSE;  // Set to TRUE to enable experimental features
// Max port speed in RRD; default 100Gbit. Only used upon RRD creation!
//$config['max_port_speed'] = 12500000000; // 12,500,000,000 * 8 = 100,000,000,000 bit/s (but this is less than 100Gbit/s
$config['max_port_speed'] = 13500000000;   // 13,421,772,800 * 8 = 107,374,182,400 bit/s = 100 * 1024 * 1024 * 1024

// End includes/defaults.inc.php
