<?php

/**
 * Observium
 *
 *   This file is part of Observium.
 *
 * @package    observium
 * @subpackage graphs
 * @copyright  (C) 2006-2013 Adam Armstrong, (C) 2013-2019 Observium Limited
 *
 */

$rrd_filename = get_rrd_path($device, "netstats-ip.rrd");

$stats = array('ipForwDatagrams' => array(),
               'ipInDelivers' => array(),
               'ipInReceives' => array(),
               'ipOutRequests' => array(),
               'ipInDiscards' => array(),
               'ipOutDiscards' => array(),
               'ipOutNoRoutes' => array());

$i=0;
foreach ($stats as $stat => $array)
{
  $i++;
  $rrd_list[$i]['filename'] = $rrd_filename;
  $rrd_list[$i]['descr'] = str_replace("ip", "", $stat);
  $rrd_list[$i]['ds'] = $stat;
  if (strpos($stat, "Out") !== FALSE)
  {
    $rrd_list[$i]['invert'] = TRUE;
  }
}

$colours='mixed';

$scale_min = "0";
$nototal = 1;
$simple_rrd = TRUE;

include($config['html_dir']."/includes/graphs/generic_multi_line.inc.php");

?>
