<?php
/**
 * Observium
 *
 *   This file is part of Observium.
 *
 * @package    observium
 * @subpackage ajax
 * @copyright  (C) 2006-2013 Adam Armstrong, (C) 2013-2021 Observium Limited
 *
 */

$config['install_dir'] = "../..";

include_once("../../includes/sql-config.inc.php");

include($config['html_dir'] . "/includes/functions.inc.php");
include($config['html_dir'] . "/includes/authenticate.inc.php");

if (!$_SESSION['authenticated'])
{
  echo("unauthenticated");
  exit;
}

include_dir($config['html_dir'] . "/includes/widgets/");

$widget = dbFetchRow("SELECT * FROM `dash_widgets` WHERE widget_id = ?", array($_POST['id']));

$widget['height'] = (is_numeric($_POST['height']) ? $_POST['height'] : '3');
$widget['width']  = (is_numeric($_POST['width']) ? $_POST['width'] : '4');

print_dash_mod($widget);

function print_dash_mod ($mod)
{

  global $config;
  global $cache;

  $mod['vars'] = json_decode($mod['widget_config'], TRUE);

  $width  = (is_numeric($mod['width']) ? $mod['width'] : 1240);
  $height = (is_numeric($mod['height']) ? $mod['height'] : 80);

  switch ($mod['widget_type'])
  {

    case "welcome":
        echo '<div class="box box-solid do-not-update" style="padding:10px; padding-left: 375px; background-image: url(images/login-hamster-large.png); background-position: left 10px top -100px; background-repeat: no-repeat;">';
        echo '<h3>Welcome to your new Observium dashboard!</h3>';
        if(isset($mod['vars']['converted']))
        {
          echo 'This was autogenerated based on your previous front page. It can be modified to suit your requirements.<br />';
        } else {
          echo 'This is an autogenerated default dashboard. It can be modified to suit your requirements.<br />';
        }
        echo 'Please see the <strong><a href="'.OBSERVIUM_DOCS_URL.'/dashboard/" target="_blank">documentation</a></strong> for information about how to configure this dashboard. Including how to delete this widget!';
        echo '</div>';
        break;

    case "weathermap":

      echo '<div class="box box-solid do-not-update">';

      $wmap = dbFetchRow("SELECT * FROM `weathermaps` WHERE `wmap_name` = ?", array($mod['vars']['mapname']));

      echo '  <div class="hover-hide widget-title" style="z-index: 900; position: absolute; overflow: hidden;" class="widget-title"><h4 style="wwriting-mode: vertical-lr; ttext-orientation: mixed;" class="box-title">' .
        '' . htmlentities($wmap['wmap_name']) . '</h4>' .
        '</div>' . PHP_EOL;

      echo '  <div class="box-content" style="overflow: hidden">';
      echo '<div style="height:100%; overflow:hidden; width: 110%;">';
      echo '<a href="'.generate_url(['page' => 'wmap', 'mapname' => $wmap['map_name']]).'">';
      echo '<img src="/weathermap.php?mapname=' . htmlentities($wmap['wmap_name']) . '&action=draw&unique=' . time() . '&width='.$width.'&height='.$height.'">';
      echo '</a>';

      echo '</div>';
      echo '  </div>';

      echo '</div>';
      break;

    case "map":
      echo '<div class="box box-solid do-not-update">';
      print_dash_map($mod, $width, $height);
      echo '</div>';
      break;

    case "graph":
      echo '<div class="box box-solid do-not-update">';
      print_dash_graph($mod, $width, $height);
      echo '</div>';
      break;

    case "port_percent":
        if($_SESSION['userlevel'] < 5)
        {
          echo '<div class="box box-solid" style="width: 100%; height: 100%; float:none; display: block; padding: 10px;">';
          echo '<div class="alert statusbox alert-warning" style="border-left: 1px; width: 100%; height: 100%; margin-right: 10px; float:none; display: block;">';
          echo '<div style="margin: auto; line-height: 75px; text-align: center;">You have insufficient permissions to view this widget.</div>';
          echo '</div>';
          echo '</div>';
        } elseif ($height < 190) {
          echo '<div class="box box-solid alert alert-warning" style="width: 100%; height: 100%; float:none; display: block; padding: 10px;">';
          echo '<b>WARNING</b> This widget is not tall enough to display the requested content. Module <b>Port Percent</b> requires 190px or taller.';
          echo '</div>';
        } else {
          include($config['html_dir'] . "/includes/status-portpercent.inc.php");
        }
      break;

    case "alert_table":
      echo '<div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
      echo '  <div class="box-header" style="cursor: hand;"><h3 class="box-title">Alert Status</h3></div>';
      echo '    <div class="box-content" style="overflow:auto;">';
      print_alert_table(array('status'     => 'failed',
                              'pagination' => FALSE,
                              'short'      => TRUE)
                                    );
      echo '    </div>';
      echo '  </div>';
      echo '</div>';
      break;

    case "status_summary":
      echo '<div class="row">';
      if($width > 1000) { $div_class = "col-md-6"; } else { $div_class = "col-md-12"; }

      if($height < 210) { $hide_group_bar = 1; }

      include($config['html_dir'] . '/includes/cache-data.inc.php');
      include($config['html_dir'] . "/includes/status-summary.inc.php");
      echo '</div>';
      break;

    case "alert_boxes":
    case "old_status_boxes":
        //r($height);
      include($config['html_dir'] . '/includes/cache-data.inc.php');
      //$count = round(($width) / 165) * round(($height+10) / 90); // 1.5 wide
      $count = floor(($width+10) / 198) * floor(($height+10) / 96); // 1.5 wide
      echo '<div style="width: auto; height: 100%; overflow-x: visible; overflow-y: visible; margin-right: -25px;">';
      if($mod['widget_type'] == 'alert_boxes')
      {
        print_status_boxes($mod, $count);
      } else {
        print_status_boxes($config['frontpage']['device_status'], $count);
      }
      echo '</div>';
      break;

    case "old_status_table":
      echo '<div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
      echo '  <div class="box-header" style="cursor: hand;"><h3 class="box-title">Status Warnings and Notifications</h3></div>';
      echo '    <div class="box-content" style="height: ' . ($height - 40) .'px; overflow: auto;">';

      include($config['html_dir'] . '/includes/cache-data.inc.php');
      echo generate_status_table($config['frontpage']['device_status']);
      echo generate_box_close();

        break;

    case "status_donuts":
      include($config['html_dir'] . "/includes/status-donuts.inc.php");
      break;

    case "syslog":
      echo '  <div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
      echo '    <div class="box-header" style="cursor: hand;"><h3 class="box-title"><a href="/syslog/">Syslog</a></h3></div>';
      echo '    <div class="box-content" style="overflow: hidden; overflow-x:scroll;">';
      print_syslogs(array('short' => TRUE, 'pagesize' => ($height - 36) / 26,
                          'priority' => $config['frontpage']['syslog']['priority']));
      echo '  </div>';
      echo '</div>';
      break;

    case "syslog_alerts":
        echo '  <div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
        echo '    <div class="box-header" style="cursor: hand;"><h3 class="box-title"><a href="/syslog_alerts/">Syslog Alerts</a></h3></div>';
        echo '    <div class="box-content" style="overflow: hidden; overflow-x:scroll;">';
        print_logalert_log(array('short' => TRUE, 'pagesize' => ($height - 36) / 26) );
        echo '  </div>';
        echo '</div>';
        break;

    case "alertlog":
      echo '  <div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
      echo '    <div class="box-header" style="cursor: hand;"><h3 class="box-title"><a href="/alert_log/">Alert Log</a></h3></div>';
      echo '    <div class="box-content" style="overflow: hidden; overflow-x:scroll;">';
      print_alert_log_short(array('short' => TRUE, 'pagesize' => ($height - 36) / 26));
      echo '  </div>';
      echo '</div>';
      break;

    case "eventlog":
      echo '  <div class="box box-solid" style="overflow: hidden; height: auto; max-height: 100%">';
      echo '    <div class="box-header" style="cursor: hand;"><h3 class="box-title"><a href="/eventlog/">Eventlog</a></h3></div>';
      echo '    <div class="box-content" style="overflow: hidden; overflow-x:scroll;">';

      $pagesize = floor(($height - 36) / 26);
      //if($width > 1000) { $pagesize -= 3; $short = FALSE; } else { $short = TRUE; }

      print_events(array('short' => TRUE, 'pagesize' => $pagesize, 'pageno' => 1,
                         'severity' => $config['frontpage']['eventlog']['severity']));
      echo '  </div>';
      echo '</div>';
      break;


    case "realtime":
      echo '  <div class="box box-solid do-not-update" style="overflow: hidden;">';
      $realtime_link = 'graph-realtime.php?type=bits&amp;id=430082&amp;interval=10';

      ?>
        <object data="<?php echo($realtime_link); ?>" type="image/svg+xml" width="<?php echo $width; ?>"
                height="<?php echo $height; ?>">
            <param name="src"
                   value="graph.php?type=bits&amp;id=<?php echo($port['port_id'] . "&amp;interval=" . $vars['interval']); ?>"/>
            Your browser does not support SVG! You need to either use Firefox or Chrome, or download the Adobe SVG
            plugin.
        </object>
      <?php
      echo '</div>';
      break;

    default:
      echo '<div class="grid-stack-item-content box box-solid" style="overflow: hidden; justify-content: center; align-items: center;">';
      echo '  <div class="box-content" style="overflow: hidden;">';
      echo '    <h3 class="box-title">Unconfigured Module</h3>';
      echo '  </div>';
      echo '</div>';
      break;
  }

  //echo '</div>';

}

function print_dash_map ($vars, $width, $height)
{

  global $config;

  ?>
    <style type="text/css">
        #map<?php echo $vars['widget_id']; ?> label {
            width: auto;
            display: inline;
        }

        #map<?php echo $vars['widget_id']; ?> img {
            max-width: none;
        }

        #map<?php echo $vars['widget_id']; ?> {
            height: 100%;
            width: 100%;
        }
    </style>

  <?php

  echo '<div id="map'.$vars['widget_id'].'"></div>';

  include($config['html_dir']. '/includes/map/leaflet.inc.php');

} // End show_map

function print_dash_graph($mod, $width, $height) {
  global $config;

  $vars = $mod['vars'];

  if (!isset($vars['type']))
  {

    echo '<div style="position: relative;  top: 50%;  transform: perspective(1px) translateY(-50%); width: 100%; text-align: center;">
            <btn class="btn btn-primary" onclick="configWidget(' . $mod['widget_id'] . ')"><i class="icon-signal"/> &nbsp; Select Graph</btn>
          </div>';

    exit();
  }

  if (isset($vars['timestamp_from']) && preg_match(OBS_PATTERN_TIMESTAMP, $vars['timestamp_from'])) {
    $vars['from'] = strtotime($vars['timestamp_from']);
    unset($vars['timestamp_from']);
  }
  if (isset($vars['timestamp_to']) && preg_match(OBS_PATTERN_TIMESTAMP, $vars['timestamp_to'])) {
    $vars['to'] = strtotime($vars['timestamp_to']);
    unset($vars['timestamp_to']);
  }

  // Period alone is sufficient

  /*
  if (isset($vars['period']))
  {
    $vars['to']   = "now";
    $vars['from'] = "-".$vars['period'];
  }

  if (!isset($vars['from']))
  {
    $vars['from'] = $config['time']['day'];
  }
  if (!isset($vars['to']))
  {
    $vars['to'] = $config['time']['now'];
  }
  */

  preg_match('/^(?P<type>[a-z0-9A-Z-]+)_(?P<subtype>.+)/', $vars['type'], $graphtype);

  if (OBS_DEBUG) {
    print_vars($graphtype);
  }

  $type    = $graphtype['type'];
  $subtype = $graphtype['subtype'];

  if (is_numeric($vars['device'])) {
    $device = device_by_id_cache($vars['device']);
  } elseif (!empty($vars['device'])) {
    $device = device_by_name($vars['device']);
  } elseif ($type === "device" && is_numeric($vars['id'])) {
    $device = device_by_id_cache($vars['id']);
  }

  $preserve_id = $vars['id'];

  if (is_file($config['html_dir'] . "/includes/graphs/" . $type . "/auth.inc.php"))
  {
    include($config['html_dir'] . "/includes/graphs/" . $type . "/auth.inc.php");
  }

  $vars['id'] = $preserve_id;

  if (!$auth) {
    print_error_permission();
    return;
  }

  if (isset($config['entities'][$type])) {
    $entity = get_entity_by_id_cache($type, $vars['id']);
    entity_rewrite($type, $entity);
  }

  if ($type === 'bgp') {
    $entity = get_entity_by_id_cache('bgp_peer', $vars['id']);
    entity_rewrite('bgp_peer', $entity);
  }

   //$device = device_by_id_cache($entity['device_id']);

   //$graph_array['type'] = $vars['entity_type'] . '_' . $vars['graph_type'];
   //$graph_array['id'] = $vars['entity_id'];

  // Generate navbar with subtypes
  $graph_array = $vars;

  //$graph_array['from'] = '-1day';
  //$graph_array['to']   = 'now';

  $graph_array['width']  = $width - 76 + 14;                            // RRD graphs are 75px wider than request value
  $graph_array['height'] = $height - 34; //68;                          // RRD graphs are taller than request value

  if ($graph_array['width'] > 350)
  {
    $graph_array['width'] -= 6;
  } // RRD graphs > 350px are 6 px wider because of larger legend font
  if ($graph_array['width'] > 350)
  {
    $graph_array['height'] -= 6;
  } // RRD graphs > 350px are 6 px wider because of larger legend font

  $title_div = 'top:0px; left: 0px; padding: 4px; border-top-left-radius: 4px; border: 1px solid #e5e5e5; border-left: none; border-top: none; background-color: rgba(255, 255,255, 0.75); ';
  $title_div = 'widget-title';

  if ($height < 100)
  {
    $graph_array['height'] = $height;
    $graph_array['width']  = $width;
    $graph_array['graph_only'] = 'yes';

    $title_div = 'top:5px; left: 5px; padding: none; border-radius: 2px; border: 1px solid #e5e5e5; background: rgba(255, 255, 255, 0.7);';
    $title_div = 'widget-title-small';

  } else {
    $graph_array['draw_all'] = 'yes';
  }
    $t_len = $vars['width'] / 10;

  $subtype_text = (isset($config['graph_types'][$type][$subtype]) ? $config['graph_types'][$type][$subtype]['descr'] : nicecase($subtype));

  if (!isset($graph_array['title'])) {
    if ($type === 'global')
    {
      $title = "Global :: " . $subtype_text;
    } elseif (str_contains($type, "multi")) {
      $count = safe_count($graph_array['id']);
      $title = $count . ' ' . nicecase(str_replace("multi-", '', $type)) . ' :: ' . $subtype_text;
    } else {
      $title = device_name($device, $t_len / 2 - 2) . ($type === "device" ? ' :: ' : ' :: ' . truncate($entity['entity_shortname'], 32) . ' :: ' ) . $subtype_text;
    }
  } else {
    $title = $graph_array['title'];
    unset($graph_array['title']);
  }

  //$graph_array['format'] = 'png';

  //$graph_array['img_id'] = generate_random_string(5);
  $graph_array['legend'] = 'no';
  $graph_array['class'] = 'image-refresh';

  $graph = generate_graph_tag($graph_array, TRUE);

  $link_array = $graph_array;
  $link_array['page'] = "graphs";
  unset($link_array['graph_only']);
  unset($link_array['height'], $link_array['width']);
  $link = generate_url($link_array);

  //echo '    <div class="box-header with-border">' . $device['hostname'] . '<span class="pull-right">' . truncate($entity['entity_name'], 32) . '</span></div>';

  echo '  <div class="hover-hide ' . $title_div . '" style="z-index: 900; position: absolute; overflow: hidden;" class="widget-title"><h4 style="wwriting-mode: vertical-lr; ttext-orientation: mixed;" class="box-title">' .
        '' . escape_html($title) . '</h4>' .
       '</div>' . PHP_EOL;

  echo '  <div class="box-content" style="overflow: hidden">';
  echo '<div style="height:100%; overflow:hidden; width: 110%;">';
  echo '<a href="'.$link.'">'.$graph['img_tag'].'</a>';
  echo '</div>';
  echo '  </div>';

}

// EOF
