/*
 * Decompiled with CFR 0.152.
 */
package biz.db.dev.observium.jvm.agent;

import biz.db.dev.observium.jvm.agent.ConfigLoader;
import biz.db.dev.observium.jvm.agent.InstanceConfiguration;
import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ObserviumJvmUnixAgent {
    private static final Logger LOG = Logger.getLogger(ObserviumJvmUnixAgent.class.getName());
    private String jmxUrl = null;
    private String name = null;
    private JMXConnector jmxc;
    private MBeanServerConnection connection;
    private static final String MEMORY_POOL_PREFIX = "java.lang:type=MemoryPool,name=";
    private String edenSpacePoolName = "java.lang:type=MemoryPool,name=Eden Space";
    private String permGenPoolName = "java.lang:type=MemoryPool,name=Perm Gen";
    private String oldGenPoolName = "java.lang:type=MemoryPool,name=Tenured Gen";

    public ObserviumJvmUnixAgent(String jmxUrl, String name) {
        this.jmxUrl = jmxUrl;
        this.name = name;
    }

    public void init() throws IOException {
        JMXServiceURL serviceURL = new JMXServiceURL(this.jmxUrl);
        this.jmxc = JMXConnectorFactory.connect(serviceURL, null);
        this.connection = this.jmxc.getMBeanServerConnection();
        LOG.info("initialized ObserviumJvmUnixAgent with name=" + this.name + " and url=" + this.jmxUrl);
    }

    public void close() {
        try {
            this.jmxc.close();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
    }

    public void printHeader() {
        System.out.println("\n\n<<<app-jvmoverjmx-" + this.name + ">>>");
    }

    private void checkConfiguration() {
        try {
            String[] InputArguments;
            ObjectName runtimeObjectName = new ObjectName("java.lang:type=Runtime");
            for (String argument : InputArguments = (String[])this.connection.getAttribute(runtimeObjectName, "InputArguments")) {
                String[] memoryPoolNames;
                ObjectName gcObjectName;
                if (argument.equals("-XX:+UseG1GC")) {
                    gcObjectName = new ObjectName("java.lang:type=GarbageCollector,name=G1 Old Generation");
                    memoryPoolNames = (String[])this.connection.getAttribute(gcObjectName, "MemoryPoolNames");
                    this.edenSpacePoolName = MEMORY_POOL_PREFIX + memoryPoolNames[0];
                    this.oldGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[2];
                    this.permGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[3];
                    continue;
                }
                if (argument.equals("-XX:+UseConcMarkSweepGC")) {
                    gcObjectName = new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep");
                    memoryPoolNames = (String[])this.connection.getAttribute(gcObjectName, "MemoryPoolNames");
                    this.edenSpacePoolName = MEMORY_POOL_PREFIX + memoryPoolNames[0];
                    this.oldGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[2];
                    this.permGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[3];
                    continue;
                }
                if (!argument.equals("-XX:+UseParallelOldGC")) continue;
                gcObjectName = new ObjectName("java.lang:type=GarbageCollector,name=PS MarkSweep");
                memoryPoolNames = (String[])this.connection.getAttribute(gcObjectName, "MemoryPoolNames");
                this.edenSpacePoolName = MEMORY_POOL_PREFIX + memoryPoolNames[0];
                this.oldGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[2];
                this.permGenPoolName = MEMORY_POOL_PREFIX + memoryPoolNames[3];
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
    }

    public void printMemoryInfo() {
        long heapMemoryMaxUsage = 0L;
        long heapMemoryUsed = 0L;
        long nonHeapMemoryMaxUsage = 0L;
        long nonHeapMemoryUsed = 0L;
        try {
            ObjectName memoryObjectName = new ObjectName("java.lang:type=Memory");
            CompositeDataSupport heapMemoryComposite = (CompositeDataSupport)this.connection.getAttribute(memoryObjectName, "HeapMemoryUsage");
            CompositeDataSupport nonHeapMemoryComposite = (CompositeDataSupport)this.connection.getAttribute(memoryObjectName, "NonHeapMemoryUsage");
            heapMemoryMaxUsage = (Long)heapMemoryComposite.get("max");
            heapMemoryUsed = (Long)heapMemoryComposite.get("used");
            nonHeapMemoryMaxUsage = (Long)nonHeapMemoryComposite.get("max");
            nonHeapMemoryUsed = (Long)nonHeapMemoryComposite.get("used");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "HeapMemoryMaxUsage", heapMemoryMaxUsage));
        System.out.println(String.format("%-30s : %-30s", "HeapMemoryUsed", heapMemoryUsed));
        System.out.println(String.format("%-30s : %-30s", "NonHeapMemoryMax", nonHeapMemoryMaxUsage));
        System.out.println(String.format("%-30s : %-30s", "NonHeapMemoryUsed", nonHeapMemoryUsed));
    }

    public void printEdenSpace() {
        long edenSpaceMaxUsage = 0L;
        long edenSpaceUsed = 0L;
        try {
            ObjectName edenSpaceObjectName = new ObjectName(this.edenSpacePoolName);
            CompositeDataSupport edenSpaceComposite = (CompositeDataSupport)this.connection.getAttribute(edenSpaceObjectName, "Usage");
            edenSpaceMaxUsage = (Long)edenSpaceComposite.get("max");
            edenSpaceUsed = (Long)edenSpaceComposite.get("used");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "EdenSpaceMax", edenSpaceMaxUsage));
        System.out.println(String.format("%-30s : %-30s", "EdenSpaceUsed", edenSpaceUsed));
    }

    public void printPermGen() {
        long permGenMaxUsage = 0L;
        long permGenUsed = 0L;
        try {
            ObjectName permGenObjectName = new ObjectName(this.permGenPoolName);
            CompositeDataSupport permGenComposite = (CompositeDataSupport)this.connection.getAttribute(permGenObjectName, "Usage");
            permGenMaxUsage = (Long)permGenComposite.get("max");
            permGenUsed = (Long)permGenComposite.get("used");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "PermGenMax", permGenMaxUsage));
        System.out.println(String.format("%-30s : %-30s", "PermGenUsed", permGenUsed));
    }

    public void printOldGeneration() {
        long oldGenerationMaxUsage = 0L;
        long oldGenerationUsed = 0L;
        try {
            ObjectName oldGenerationObjectName = new ObjectName(this.oldGenPoolName);
            CompositeDataSupport oldGenerationComposite = (CompositeDataSupport)this.connection.getAttribute(oldGenerationObjectName, "Usage");
            oldGenerationMaxUsage = (Long)oldGenerationComposite.get("max");
            oldGenerationUsed = (Long)oldGenerationComposite.get("used");
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "OldGenMax", oldGenerationMaxUsage));
        System.out.println(String.format("%-30s : %-30s", "OldGenUsed", oldGenerationUsed));
    }

    private void printG1OldGenerationInfo() {
        long g1OldGenCollectionCount = 0L;
        long g1OldGenCollectionTime = 0L;
        try {
            ObjectName g1OldGeneration = new ObjectName("java.lang:type=GarbageCollector,name=G1 Old Generation");
            GarbageCollectorMXBean g1OldGenerationMxBean = JMX.newMBeanProxy(this.connection, g1OldGeneration, GarbageCollectorMXBean.class, true);
            g1OldGenCollectionCount = g1OldGenerationMxBean.getCollectionCount();
            g1OldGenCollectionTime = g1OldGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "G1OldGenCollectionCount", g1OldGenCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "G1OldGenCollectionTime", g1OldGenCollectionTime));
    }

    private void printG1YoungGenerationInfo() {
        long g1YoungGenCollectionCount = 0L;
        long g1YoungGenCollectionTime = 0L;
        try {
            ObjectName g1YoungGeneration = new ObjectName("java.lang:type=GarbageCollector,name=G1 Young Generation");
            GarbageCollectorMXBean g1YoungGenerationMxBean = JMX.newMBeanProxy(this.connection, g1YoungGeneration, GarbageCollectorMXBean.class, true);
            g1YoungGenCollectionCount = g1YoungGenerationMxBean.getCollectionCount();
            g1YoungGenCollectionTime = g1YoungGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "G1YoungGenCollectionCount", g1YoungGenCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "G1YoungGenCollectionTime", g1YoungGenCollectionTime));
    }

    private void printConcMarkSweepInfo() {
        long cmsCollectionCount = 0L;
        long cmsCollectionTime = 0L;
        try {
            ObjectName cmsObjectName = new ObjectName("java.lang:type=GarbageCollector,name=ConcurrentMarkSweep");
            GarbageCollectorMXBean cmsGenerationMxBean = JMX.newMBeanProxy(this.connection, cmsObjectName, GarbageCollectorMXBean.class, true);
            cmsCollectionCount = cmsGenerationMxBean.getCollectionCount();
            cmsCollectionTime = cmsGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "CMSCollectionCount", cmsCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "CMSCollectionTime", cmsCollectionTime));
    }

    private void printParNewInfo() {
        long parNewCollectionCount = 0L;
        long parNewCollectionTime = 0L;
        try {
            ObjectName parNewObjectName = new ObjectName("java.lang:type=GarbageCollector,name=ParNew");
            GarbageCollectorMXBean parNewGenerationMxBean = JMX.newMBeanProxy(this.connection, parNewObjectName, GarbageCollectorMXBean.class, true);
            parNewCollectionCount = parNewGenerationMxBean.getCollectionCount();
            parNewCollectionTime = parNewGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "ParNewCollectionCount", parNewCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "ParNewCollectionTime", parNewCollectionTime));
    }

    private void printCopyInfo() {
        long copyCollectionCount = 0L;
        long copyCollectionTime = 0L;
        try {
            ObjectName copyNewObjectName = new ObjectName("java.lang:type=GarbageCollector,name=Copy");
            GarbageCollectorMXBean copyGenerationMxBean = JMX.newMBeanProxy(this.connection, copyNewObjectName, GarbageCollectorMXBean.class, true);
            copyCollectionCount = copyGenerationMxBean.getCollectionCount();
            copyCollectionTime = copyGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "CopyCollectionCount", copyCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "CopyCollectionTime", copyCollectionTime));
    }

    private void printPSMarkSweepInfo() {
        long markSweepCollectionCount = 0L;
        long markSweepCollectionTime = 0L;
        try {
            ObjectName markSweepObjectName = new ObjectName("java.lang:type=GarbageCollector,name=PS MarkSweep");
            GarbageCollectorMXBean markSweepGenerationMxBean = JMX.newMBeanProxy(this.connection, markSweepObjectName, GarbageCollectorMXBean.class, true);
            markSweepCollectionCount = markSweepGenerationMxBean.getCollectionCount();
            markSweepCollectionTime = markSweepGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "PSMarkSweepCollectionCount", markSweepCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "PSMarkSweepCollectionTime", markSweepCollectionTime));
    }

    private void printPSScavengeInfo() {
        long scavengeCollectionCount = 0L;
        long scavengeCollectionTime = 0L;
        try {
            ObjectName scavengeObjectName = new ObjectName("java.lang:type=GarbageCollector,name=PS Scavenge");
            GarbageCollectorMXBean scavengeGenerationMxBean = JMX.newMBeanProxy(this.connection, scavengeObjectName, GarbageCollectorMXBean.class, true);
            scavengeCollectionCount = scavengeGenerationMxBean.getCollectionCount();
            scavengeCollectionTime = scavengeGenerationMxBean.getCollectionTime();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "PSScavengeCollectionCount", scavengeCollectionCount));
        System.out.println(String.format("%-30s : %-30s", "PSScavengeCollectionTime", scavengeCollectionTime));
    }

    public void printVendorInfo() {
        String implementationVendor = "";
        String implementationVersion = "";
        try {
            ObjectName mBeanServerDelegateMBeanObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            MBeanServerDelegateMBean mBeanServerDelegateMBean = JMX.newMBeanProxy(this.connection, mBeanServerDelegateMBeanObjectName, MBeanServerDelegateMBean.class, true);
            implementationVendor = mBeanServerDelegateMBean.getImplementationVendor();
            implementationVersion = mBeanServerDelegateMBean.getImplementationVersion();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "Vendor", implementationVendor));
        System.out.println(String.format("%-30s : %-30s", "Version", implementationVersion));
    }

    private void printUpTime() {
        long upTime = 0L;
        try {
            ObjectName runtimeObjectName = new ObjectName("java.lang:type=Runtime");
            RuntimeMXBean runtimeMXBean = JMX.newMBeanProxy(this.connection, runtimeObjectName, RuntimeMXBean.class, true);
            upTime = runtimeMXBean.getUptime();
            upTime /= 1000L;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "UpTime", upTime));
    }

    public void printThreadCount() {
        int daemonThreadCount = 0;
        int threadCount = 0;
        try {
            ObjectName threadMXBeanObjectName = new ObjectName("java.lang:type=Threading");
            ThreadMXBean threadMXBean = JMX.newMBeanProxy(this.connection, threadMXBeanObjectName, ThreadMXBean.class, true);
            daemonThreadCount = threadMXBean.getDaemonThreadCount();
            threadCount = threadMXBean.getThreadCount();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "DaemonThreads", daemonThreadCount));
        System.out.println(String.format("%-30s : %-30s", "TotalThreads", threadCount));
    }

    private void printClassLoading() {
        int loadedClassCount = 0;
        long unloadedClassCount = 0L;
        try {
            ObjectName classLoadingObjectName = new ObjectName("java.lang:type=ClassLoading");
            ClassLoadingMXBean classLoadingMXBean = JMX.newMBeanProxy(this.connection, classLoadingObjectName, ClassLoadingMXBean.class, true);
            loadedClassCount = classLoadingMXBean.getLoadedClassCount();
            unloadedClassCount = classLoadingMXBean.getUnloadedClassCount();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "ex", ex);
        }
        System.out.println(String.format("%-30s : %-30s", "LoadedClassCount", loadedClassCount));
        System.out.println(String.format("%-30s : %-30s", "UnloadedClassCount", unloadedClassCount));
    }

    public static void main(String[] args) throws IOException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        AgentConfiguration agentConfiguration = new AgentConfiguration();
        agentConfiguration.initArguments(args);
        agentConfiguration.initLoger();
        ConfigLoader configLoader = new ConfigLoader(agentConfiguration.getConfigLocation());
        for (InstanceConfiguration configuration : configLoader.getConfigurations()) {
            String hostname = configuration.getHostname();
            Integer port = null;
            try {
                port = Integer.parseInt(configuration.getPort());
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.WARNING, "ex", ex);
                System.exit(1);
            }
            try {
                ObserviumJvmUnixAgent agent = new ObserviumJvmUnixAgent("service:jmx:rmi:///jndi/rmi://" + hostname + ":" + port + "/jmxrmi", configuration.getName());
                agent.init();
                agent.checkConfiguration();
                agent.printHeader();
                agent.printVendorInfo();
                agent.printUpTime();
                agent.printMemoryInfo();
                agent.printEdenSpace();
                agent.printPermGen();
                agent.printOldGeneration();
                agent.printG1OldGenerationInfo();
                agent.printG1YoungGenerationInfo();
                agent.printConcMarkSweepInfo();
                agent.printParNewInfo();
                agent.printCopyInfo();
                agent.printPSMarkSweepInfo();
                agent.printPSScavengeInfo();
                agent.printThreadCount();
                agent.printClassLoading();
                agent.close();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "ex", ex);
            }
        }
    }

    private static class AgentConfiguration {
        private static final String CONFIG_LOCATION_PARAM = "--config";
        private static final String DEBUG_PARAM = "--debug";
        private static final String DEBUG_FILE_PARAM = "--logfile";
        private String configLocation = null;
        private String logfile = null;
        private boolean debug = false;

        private AgentConfiguration() {
        }

        public void initArguments(String[] args) {
            for (String argument : args) {
                if (argument.startsWith(CONFIG_LOCATION_PARAM)) {
                    this.configLocation = argument.substring(CONFIG_LOCATION_PARAM.length() + 1);
                    continue;
                }
                if (argument.equals(DEBUG_PARAM)) {
                    this.debug = true;
                    continue;
                }
                if (!argument.startsWith(DEBUG_FILE_PARAM)) continue;
                this.logfile = argument.substring(DEBUG_FILE_PARAM.length() + 1);
            }
        }

        public void initLoger() throws IOException {
            if (this.debug && this.logfile != null) {
                LOG.setLevel(Level.FINEST);
                int limit = 0x3200000;
                FileHandler fileHandler = new FileHandler(this.logfile, limit, 2, true);
                fileHandler.setFormatter(new SimpleFormatter());
                LOG.addHandler(fileHandler);
            } else if (this.debug) {
                LOG.addHandler(new ConsoleHandler());
            } else {
                LOG.setLevel(Level.OFF);
            }
            LOG.setUseParentHandlers(false);
        }

        public String getConfigLocation() {
            return this.configLocation;
        }
    }
}

