/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.tree.TreeNode;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.zaproxy.zap.db.TableAlertTag;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.XMLStringUtil;

public class AlertAPI
extends ApiImplementor {
    public static final String PREFIX = "alert";
    private static final Logger LOGGER = LogManager.getLogger(AlertAPI.class);
    private static final String ACTION_DELETE_ALL_ALERTS = "deleteAllAlerts";
    private static final String ACTION_DELETE_ALERTS = "deleteAlerts";
    private static final String ACTION_DELETE_ALERT = "deleteAlert";
    private static final String ACTION_UPDATE_ALERT = "updateAlert";
    private static final String ACTION_ADD_ALERT = "addAlert";
    private static final String ACTION_UPDATE_ALERTS_CONFIDENCE = "updateAlertsConfidence";
    private static final String ACTION_UPDATE_ALERTS_RISK = "updateAlertsRisk";
    private static final String VIEW_ALERT = "alert";
    private static final String VIEW_ALERTS = "alerts";
    private static final String VIEW_ALERTS_SUMMARY = "alertsSummary";
    private static final String VIEW_NUMBER_OF_ALERTS = "numberOfAlerts";
    private static final String VIEW_ALERTS_BY_RISK = "alertsByRisk";
    private static final String VIEW_ALERT_COUNTS_BY_RISK = "alertCountsByRisk";
    private static final String PARAM_BASE_URL = "baseurl";
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_CONTEXT_NAME = "contextName";
    private static final String PARAM_URL = "url";
    private static final String PARAM_ID = "id";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_RISK = "riskId";
    private static final String PARAM_START = "start";
    private static final String PARAM_MESSAGE_ID = "messageId";
    private static final String PARAM_ALERT_ID = "id";
    private static final String PARAM_ALERT_IDS = "ids";
    private static final String PARAM_ALERT_NAME = "name";
    private static final String PARAM_CONFIDENCE = "confidenceId";
    private static final String PARAM_ALERT_DESCRIPTION = "description";
    private static final String PARAM_ALERT_PARAM = "param";
    private static final String PARAM_ALERT_ATTACK = "attack";
    private static final String PARAM_ALERT_OTHERINFO = "otherInfo";
    private static final String PARAM_ALERT_SOLUTION = "solution";
    private static final String PARAM_ALERT_REFS = "references";
    private static final String PARAM_ALERT_EVIDENCE = "evidence";
    private static final String PARAM_CWEID = "cweId";
    private static final String PARAM_WASCID = "wascId";
    private static final int NO_RISK_ID = -1;
    private static final int NO_CONFIDENCE_ID = -1;
    private ExtensionAlert extension;

    public AlertAPI(ExtensionAlert ext) {
        this.extension = ext;
        this.addApiView(new ApiView("alert", new String[]{"id"}));
        this.addApiView(new ApiView(VIEW_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_START, PARAM_COUNT, PARAM_RISK, PARAM_CONTEXT_NAME}));
        this.addApiView(new ApiView(VIEW_ALERTS_SUMMARY, null, new String[]{PARAM_BASE_URL}));
        this.addApiView(new ApiView(VIEW_NUMBER_OF_ALERTS, null, new String[]{PARAM_BASE_URL, PARAM_RISK}));
        this.addApiView(new ApiView(VIEW_ALERTS_BY_RISK, null, new String[]{PARAM_URL, PARAM_RECURSE}));
        this.addApiView(new ApiView(VIEW_ALERT_COUNTS_BY_RISK, null, new String[]{PARAM_URL, PARAM_RECURSE}));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALL_ALERTS));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALERTS, null, new String[]{PARAM_CONTEXT_NAME, PARAM_BASE_URL, PARAM_RISK}));
        this.addApiAction(new ApiAction(ACTION_DELETE_ALERT, new String[]{"id"}));
        this.addApiAction(new ApiAction(ACTION_UPDATE_ALERTS_CONFIDENCE, new String[]{PARAM_ALERT_IDS, PARAM_CONFIDENCE}));
        this.addApiAction(new ApiAction(ACTION_UPDATE_ALERTS_RISK, new String[]{PARAM_ALERT_IDS, PARAM_RISK}));
        this.addApiAction(new ApiAction(ACTION_UPDATE_ALERT, new String[]{"id", PARAM_ALERT_NAME, PARAM_RISK, PARAM_CONFIDENCE, PARAM_ALERT_DESCRIPTION}, new String[]{PARAM_ALERT_PARAM, PARAM_ALERT_ATTACK, PARAM_ALERT_OTHERINFO, PARAM_ALERT_SOLUTION, PARAM_ALERT_REFS, PARAM_ALERT_EVIDENCE, PARAM_CWEID, PARAM_WASCID}));
        this.addApiAction(new ApiAction(ACTION_ADD_ALERT, new String[]{PARAM_MESSAGE_ID, PARAM_ALERT_NAME, PARAM_RISK, PARAM_CONFIDENCE, PARAM_ALERT_DESCRIPTION}, new String[]{PARAM_ALERT_PARAM, PARAM_ALERT_ATTACK, PARAM_ALERT_OTHERINFO, PARAM_ALERT_SOLUTION, PARAM_ALERT_REFS, PARAM_ALERT_EVIDENCE, PARAM_CWEID, PARAM_WASCID}));
    }

    @Override
    public String getPrefix() {
        return "alert";
    }

    @Override
    public ApiResponse handleApiView(final String name, JSONObject params) throws ApiException {
        ApiResponse result = null;
        if ("alert".equals(name)) {
            Map<String, String> alertTags;
            RecordAlert recordAlert;
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            TableAlertTag tableAlertTag = Model.getSingleton().getDb().getTableAlertTag();
            try {
                recordAlert = tableAlert.read(this.getParam(params, "id", -1));
                alertTags = tableAlertTag.getTagsByAlertId(this.getParam(params, "id", -1));
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to read the alert from the session:", (Throwable)e);
                throw new ApiException(ApiException.Type.INTERNAL_ERROR);
            }
            if (recordAlert == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            Alert alert2 = new Alert(recordAlert);
            alert2.setTags(alertTags);
            result = new ApiResponseElement(AlertAPI.alertToSet(alert2));
        } else if (VIEW_ALERTS.equals(name)) {
            ApiResponseList resultList = new ApiResponseList(name);
            String contextName = this.getParam(params, PARAM_CONTEXT_NAME, "");
            Context context = contextName.isEmpty() ? null : ApiUtils.getContextByName(contextName);
            AlertAPI.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), this.getRiskId(params), alert -> {
                if (context == null || context.isInContext(alert.getUri())) {
                    resultList.addItem(AlertAPI.alertToSet(alert));
                }
            });
            result = resultList;
        } else if (VIEW_NUMBER_OF_ALERTS.equals(name)) {
            CounterProcessor<Alert> counter = new CounterProcessor<Alert>();
            AlertAPI.processAlerts(this.getParam(params, PARAM_BASE_URL, null), this.getParam(params, PARAM_START, -1), this.getParam(params, PARAM_COUNT, -1), this.getRiskId(params), counter);
            result = new ApiResponseElement(name, Integer.toString(counter.getCount()));
        } else if (VIEW_ALERTS_SUMMARY.equals(name)) {
            int[] riskSummary = new int[]{0, 0, 0, 0};
            Processor<Alert> counter = alert -> {
                int n = alert.getRisk();
                riskSummary[n] = riskSummary[n] + 1;
            };
            AlertAPI.processAlerts(this.getParam(params, PARAM_BASE_URL, null), -1, -1, -1, counter);
            HashMap<String, Integer> alertData = new HashMap<String, Integer>();
            for (int i = 0; i < riskSummary.length; ++i) {
                alertData.put(Alert.MSG_RISK[i], riskSummary[i]);
            }
            result = new ApiResponseSet<Object>("risk", alertData){

                @Override
                public JSON toJSON() {
                    JSONObject response = new JSONObject();
                    response.put((Object)name, (Object)super.toJSON());
                    return response;
                }
            };
        } else if (VIEW_ALERTS_BY_RISK.equals(name)) {
            ApiResponseList resultList;
            String url = this.getParam(params, PARAM_URL, "");
            boolean recurse = this.getParam(params, PARAM_RECURSE, false);
            result = resultList = new ApiResponseList(name);
            ApiResponseList[] list = new ApiResponseList[4];
            for (int i = 0; i < list.length; ++i) {
                list[i] = new ApiResponseList(Alert.MSG_RISK[i]);
            }
            AlertTreeModel model = this.extension.getTreeModel();
            AlertNode root = (AlertNode)model.getRoot();
            Enumeration<TreeNode> enumAllAlerts = root.children();
            while (enumAllAlerts.hasMoreElements()) {
                AlertNode child = (AlertNode)enumAllAlerts.nextElement();
                Alert alert3 = child.getUserObject();
                ApiResponseList alertList = AlertAPI.filterAlertInstances(child, url, recurse);
                if (alertList.getItems().isEmpty()) continue;
                list[alert3.getRisk()].addItem(alertList);
            }
            Arrays.stream(list).forEach(resultList::addItem);
        } else if (VIEW_ALERT_COUNTS_BY_RISK.equals(name)) {
            String url = this.getParam(params, PARAM_URL, "");
            boolean recurse = this.getParam(params, PARAM_RECURSE, false);
            int[] riskCounts = new int[]{0, 0, 0, 0};
            int falsePositiveCount = 0;
            AlertTreeModel model = this.extension.getTreeModel();
            AlertNode root = (AlertNode)model.getRoot();
            Enumeration<TreeNode> enumAllAlerts = root.children();
            while (enumAllAlerts.hasMoreElements()) {
                AlertNode child = (AlertNode)enumAllAlerts.nextElement();
                Alert alert4 = child.getUserObject();
                ApiResponseList alertList = AlertAPI.filterAlertInstances(child, url, recurse);
                if (alertList.getItems().isEmpty()) continue;
                if (alert4.getConfidence() == 0) {
                    ++falsePositiveCount;
                    continue;
                }
                int n = alert4.getRisk();
                riskCounts[n] = riskCounts[n] + 1;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(Alert.MSG_RISK[3], riskCounts[3]);
            map.put(Alert.MSG_RISK[2], riskCounts[2]);
            map.put(Alert.MSG_RISK[1], riskCounts[1]);
            map.put(Alert.MSG_RISK[0], riskCounts[0]);
            map.put(Alert.MSG_CONFIDENCE[0], falsePositiveCount);
            result = new ApiResponseSet(name, map);
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return result;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        if (ACTION_DELETE_ALERT.equals(name)) {
            int alertId = ApiUtils.getIntParam(params, "id");
            this.extension.deleteAlert(AlertAPI.getAlertFromDb(alertId));
        } else if (ACTION_DELETE_ALL_ALERTS.equals(name)) {
            this.extension.deleteAllAlerts();
        } else {
            if (ACTION_DELETE_ALERTS.equals(name)) {
                String contextName = this.getParam(params, PARAM_CONTEXT_NAME, "");
                Context context = contextName.isEmpty() ? null : ApiUtils.getContextByName(contextName);
                int[] count = new int[]{0};
                Processor<Alert> counter = alert -> {
                    if (context == null || context.isInContext(alert.getUri())) {
                        this.extension.deleteAlert((Alert)alert);
                        count[0] = count[0] + 1;
                    }
                };
                AlertAPI.processAlerts(this.getParam(params, PARAM_BASE_URL, null), -1, -1, this.getRiskId(params), counter);
                return new ApiResponseElement(ACTION_DELETE_ALERTS, String.valueOf(count[0]));
            }
            if (ACTION_UPDATE_ALERT.equals(name)) {
                int alertId = ApiUtils.getIntParam(params, "id");
                String alertName = params.getString(PARAM_ALERT_NAME);
                int riskId = this.getRiskId(params);
                int confidenceId = this.getConfidenceId(params);
                String desc = params.getString(PARAM_ALERT_DESCRIPTION);
                String param = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_PARAM);
                String attack = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_ATTACK);
                String otherInfo = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_OTHERINFO);
                String solution = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_SOLUTION);
                String refs = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_REFS);
                String evidence = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_EVIDENCE);
                int cweId = this.getParam(params, PARAM_CWEID, 0);
                int wascId = this.getParam(params, PARAM_WASCID, 0);
                Alert updatedAlert = AlertAPI.getAlertFromDb(alertId);
                updatedAlert.setName(alertName);
                updatedAlert.setRisk(riskId);
                updatedAlert.setConfidence(confidenceId);
                updatedAlert.setDescription(desc);
                updatedAlert.setParam(param);
                updatedAlert.setAttack(attack);
                updatedAlert.setOtherInfo(otherInfo);
                updatedAlert.setSolution(solution);
                updatedAlert.setReference(refs);
                updatedAlert.setEvidence(evidence);
                updatedAlert.setCweId(cweId);
                updatedAlert.setWascId(wascId);
                this.processAlertUpdate(updatedAlert);
            } else {
                if (ACTION_ADD_ALERT.equals(name)) {
                    int messageId = ApiUtils.getIntParam(params, PARAM_MESSAGE_ID);
                    String alertName = ApiUtils.getNonEmptyStringParam(params, PARAM_ALERT_NAME);
                    int riskId = this.getRiskId(params);
                    int confidenceId = this.getConfidenceId(params);
                    String desc = params.getString(PARAM_ALERT_DESCRIPTION);
                    String param = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_PARAM);
                    String attack = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_ATTACK);
                    String otherInfo = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_OTHERINFO);
                    String solution = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_SOLUTION);
                    String refs = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_REFS);
                    String evidence = ApiUtils.getOptionalStringParam(params, PARAM_ALERT_EVIDENCE);
                    int cweId = this.getParam(params, PARAM_CWEID, 0);
                    int wascId = this.getParam(params, PARAM_WASCID, 0);
                    HttpMessage msg = AlertAPI.getHttpMessage(messageId);
                    Alert newAlert = new Alert(-1, riskId, confidenceId, alertName);
                    newAlert.setSource(Alert.Source.MANUAL);
                    newAlert.setMessage(msg);
                    newAlert.setUri(msg.getRequestHeader().getURI().toString());
                    newAlert.setName(alertName);
                    newAlert.setRisk(riskId);
                    newAlert.setConfidence(confidenceId);
                    newAlert.setDescription(desc);
                    newAlert.setParam(param);
                    newAlert.setAttack(attack);
                    newAlert.setOtherInfo(otherInfo);
                    newAlert.setSolution(solution);
                    newAlert.setReference(refs);
                    newAlert.setEvidence(evidence);
                    newAlert.setCweId(cweId);
                    newAlert.setWascId(wascId);
                    this.extension.alertFound(newAlert, msg.getHistoryRef());
                    return new ApiResponseElement(name, Integer.toString(newAlert.getAlertId()));
                }
                if (ACTION_UPDATE_ALERTS_CONFIDENCE.equals(name)) {
                    int confidenceId = this.getConfidenceId(params);
                    this.updateAlerts(params, alert -> alert.setConfidence(confidenceId));
                } else if (ACTION_UPDATE_ALERTS_RISK.equals(name)) {
                    int riskId = this.getRiskId(params);
                    this.updateAlerts(params, alert -> alert.setRisk(riskId));
                } else {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
            }
        }
        return ApiResponseElement.OK;
    }

    private static ApiResponseList filterAlertInstances(AlertNode alertNode, String url, boolean recurse) {
        ApiResponseList alertList = new ApiResponseList(alertNode.getUserObject().getName());
        Enumeration<TreeNode> enumAlertInsts = alertNode.children();
        while (enumAlertInsts.hasMoreElements()) {
            AlertNode childAlert = (AlertNode)enumAlertInsts.nextElement();
            if (!url.isEmpty()) {
                String alertUrl = childAlert.getUserObject().getUri();
                if (!alertUrl.startsWith(url)) continue;
                if (!recurse) {
                    if (alertUrl.indexOf(63) > 0) {
                        alertUrl = alertUrl.substring(0, alertUrl.indexOf(63));
                    }
                    if (!alertUrl.equals(url)) continue;
                }
            }
            alertList.addItem(AlertAPI.alertSummaryToSet(childAlert.getUserObject()));
        }
        return alertList;
    }

    private static void processAlerts(String baseUrl, int start, int count, int riskId, Processor<Alert> processor) throws ApiException {
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        try {
            TableAlert tableAlert = Model.getSingleton().getDb().getTableAlert();
            TableAlertTag tableAlertTag = Model.getSingleton().getDb().getTableAlertTag();
            Vector<Integer> v = tableAlert.getAlertList();
            PaginationConstraintsChecker pcc = new PaginationConstraintsChecker(start, count);
            for (int alertId : v) {
                RecordAlert recAlert = tableAlert.read(alertId);
                Alert alert = new Alert(recAlert);
                if (alert.getConfidence() == 0 || alerts.contains(alert) || baseUrl != null && !alert.getUri().startsWith(baseUrl) || riskId != -1 && alert.getRisk() != riskId) continue;
                pcc.recordProcessed();
                alerts.add(alert);
                if (!pcc.hasPageStarted()) continue;
                alert.setTags(tableAlertTag.getTagsByAlertId(alertId));
                processor.process(alert);
                if (!pcc.hasPageEnded()) continue;
                break;
            }
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR);
        }
    }

    private static ApiResponseSet<Object> alertToSet(Alert alert) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", String.valueOf(alert.getAlertId()));
        map.put("pluginId", String.valueOf(alert.getPluginId()));
        map.put("alertRef", alert.getAlertRef());
        map.put("alert", alert.getName());
        map.put(PARAM_ALERT_NAME, alert.getName());
        map.put(PARAM_ALERT_DESCRIPTION, alert.getDescription());
        map.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put(PARAM_URL, alert.getUri());
        map.put("method", alert.getMethod());
        map.put("other", alert.getOtherInfo());
        map.put(PARAM_ALERT_PARAM, alert.getParam());
        map.put(PARAM_ALERT_ATTACK, alert.getAttack());
        map.put(PARAM_ALERT_EVIDENCE, alert.getEvidence());
        map.put("inputVector", alert.getInputVector());
        map.put("reference", alert.getReference());
        map.put("cweid", String.valueOf(alert.getCweId()));
        map.put("wascid", String.valueOf(alert.getWascId()));
        map.put("sourceid", String.valueOf(alert.getSource().getId()));
        map.put(PARAM_ALERT_SOLUTION, alert.getSolution());
        map.put(PARAM_MESSAGE_ID, String.valueOf(alert.getHistoryId()));
        map.put("sourceMessageId", alert.getSourceHistoryId());
        map.put("tags", alert.getTags());
        return new CustomApiResponseSet<Object>("alert", map);
    }

    private static ApiResponseSet<String> alertSummaryToSet(Alert alert) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", String.valueOf(alert.getAlertId()));
        map.put(PARAM_ALERT_NAME, alert.getName());
        map.put("risk", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put(PARAM_URL, alert.getUri());
        map.put(PARAM_ALERT_PARAM, alert.getParam());
        return new ApiResponseSet<String>("alertsummary", map);
    }

    private static void throwInvalidRiskId() throws ApiException {
        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, Constant.messages.getString("alert.api.param.riskId.illegal", PARAM_RISK));
    }

    private static void throwInvalidConfidenceId() throws ApiException {
        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, Constant.messages.getString("alert.api.param.confidenceId.illegal", PARAM_RISK));
    }

    private int getRiskId(JSONObject parameters) throws ApiException {
        String riskIdParam = this.getParam(parameters, PARAM_RISK, "").trim();
        if (riskIdParam.isEmpty()) {
            return -1;
        }
        int riskId = -1;
        try {
            riskId = Integer.parseInt(riskIdParam);
        }
        catch (NumberFormatException e) {
            AlertAPI.throwInvalidRiskId();
        }
        if (riskId < 0 || riskId > 3) {
            AlertAPI.throwInvalidRiskId();
        }
        return riskId;
    }

    private int getConfidenceId(JSONObject parameters) throws ApiException {
        String confidenceIdParam = this.getParam(parameters, PARAM_CONFIDENCE, "").trim();
        if (confidenceIdParam.isEmpty()) {
            return -1;
        }
        int confidenceId = -1;
        try {
            confidenceId = Integer.parseInt(confidenceIdParam);
        }
        catch (NumberFormatException e) {
            AlertAPI.throwInvalidConfidenceId();
        }
        if (confidenceId < 0 || confidenceId > 4) {
            AlertAPI.throwInvalidConfidenceId();
        }
        return confidenceId;
    }

    private static List<Integer> getAlertIds(String alertIds) throws ApiException {
        ArrayList<Integer> idsList = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(alertIds, ",");
        while (tokenizer.hasMoreTokens()) {
            String alertIdStr = tokenizer.nextToken().trim();
            try {
                idsList.add(Integer.parseInt(alertIdStr));
            }
            catch (NumberFormatException nfe) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, Constant.messages.getString("alert.api.param.alertIds.illegal", alertIdStr, alertIds));
            }
        }
        return idsList;
    }

    private static Alert getAlertFromDb(int alertId) throws ApiException {
        RecordAlert recAlert;
        try {
            recAlert = Model.getSingleton().getDb().getTableAlert().read(alertId);
        }
        catch (DatabaseException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
        if (recAlert == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, String.valueOf(alertId));
        }
        return new Alert(recAlert);
    }

    private void processAlertUpdate(Alert updatedAlert) throws ApiException {
        try {
            this.extension.updateAlert(updatedAlert);
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void updateAlerts(JSONObject params, Consumer<Alert> consumer) throws ApiException {
        String alertIds = params.getString(PARAM_ALERT_IDS);
        for (int id : AlertAPI.getAlertIds(alertIds)) {
            Alert updatedAlert = AlertAPI.getAlertFromDb(id);
            consumer.accept(updatedAlert);
            this.processAlertUpdate(updatedAlert);
        }
    }

    private static HttpMessage getHttpMessage(int id) throws ApiException {
        try {
            return new HistoryReference(id, true).getHttpMessage();
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            if (e.getMessage() == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_MESSAGE_ID);
            }
            LOGGER.error("Failed to read the history record:", (Throwable)e);
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static interface Processor<T> {
        public void process(T var1);
    }

    private static class CounterProcessor<T>
    implements Processor<T> {
        private int count = 0;

        @Override
        public void process(T object) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class PaginationConstraintsChecker {
        private boolean pageStarted;
        private boolean pageEnded;
        private final int startRecord;
        private final boolean hasEnd;
        private final int finalRecord;
        private int recordsProcessed = 0;

        public PaginationConstraintsChecker(int start, int count) {
            if (start > 0) {
                this.pageStarted = false;
                this.startRecord = start;
            } else {
                this.pageStarted = true;
                this.startRecord = 0;
            }
            if (count > 0) {
                this.hasEnd = true;
                this.finalRecord = !this.pageStarted ? start + (count - 1) : count;
            } else {
                this.hasEnd = false;
                this.finalRecord = 0;
            }
            this.pageEnded = false;
        }

        public void recordProcessed() {
            ++this.recordsProcessed;
            if (!this.pageStarted) {
                boolean bl = this.pageStarted = this.recordsProcessed >= this.startRecord;
            }
            if (this.hasEnd && !this.pageEnded) {
                this.pageEnded = this.recordsProcessed >= this.finalRecord;
            }
        }

        public boolean hasPageStarted() {
            return this.pageStarted;
        }

        public boolean hasPageEnded() {
            return this.pageEnded;
        }
    }

    private static class CustomApiResponseSet<T>
    extends ApiResponseSet<T> {
        public CustomApiResponseSet(String name, Map<String, T> values) {
            super(name, values);
        }

        @Override
        public void toXML(Document doc, Element parent) {
            parent.setAttribute("type", "set");
            for (Map.Entry val : this.getValues().entrySet()) {
                Element el = doc.createElement(val.getKey());
                if ("tags".equals(val.getKey())) {
                    el.setAttribute("type", "list");
                    Map tags = (Map)val.getValue();
                    for (Map.Entry tag : tags.entrySet()) {
                        Element elTag = doc.createElement("tag");
                        elTag.setAttribute("type", "set");
                        Element elKey = doc.createElement("key");
                        elKey.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs((String)tag.getKey())));
                        elTag.appendChild(elKey);
                        Element elValue = doc.createElement("value");
                        elValue.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs((String)tag.getValue())));
                        elTag.appendChild(elValue);
                        el.appendChild(elTag);
                    }
                } else {
                    String textValue = val.getValue() == null ? "" : val.getValue().toString();
                    Text text = doc.createTextNode(XMLStringUtil.escapeControlChrs(textValue));
                    el.appendChild(text);
                }
                parent.appendChild(el);
            }
        }
    }
}

