# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_tracexec_global_optspecs
	string join \n color= C/cwd= P/profile= no-profile u/user= h/help V/version
end

function __fish_tracexec_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_tracexec_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_tracexec_using_subcommand
	set -l cmd (__fish_tracexec_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c tracexec -n "__fish_tracexec_needs_command" -l color -d 'Control whether colored output is enabled. This flag has no effect on TUI mode.' -r -f -a "auto\t''
always\t''
never\t''"
complete -c tracexec -n "__fish_tracexec_needs_command" -s C -l cwd -d 'Change current directory to this path before doing anything' -r -F
complete -c tracexec -n "__fish_tracexec_needs_command" -s P -l profile -d 'Load profile from this path' -r -F
complete -c tracexec -n "__fish_tracexec_needs_command" -s u -l user -d 'Run as user. This option is only available when running tracexec as root' -r
complete -c tracexec -n "__fish_tracexec_needs_command" -l no-profile -d 'Do not load profiles'
complete -c tracexec -n "__fish_tracexec_needs_command" -s h -l help -d 'Print help'
complete -c tracexec -n "__fish_tracexec_needs_command" -s V -l version -d 'Print version'
complete -c tracexec -n "__fish_tracexec_needs_command" -f -a "log" -d 'Run tracexec in logging mode'
complete -c tracexec -n "__fish_tracexec_needs_command" -f -a "tui" -d 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
complete -c tracexec -n "__fish_tracexec_needs_command" -f -a "generate-completions" -d 'Generate shell completions for tracexec'
complete -c tracexec -n "__fish_tracexec_needs_command" -f -a "collect" -d 'Collect exec events and export them'
complete -c tracexec -n "__fish_tracexec_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l inline-timestamp-format -d 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l seccomp-bpf -d 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance' -r -f -a "auto\t''
on\t''
off\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l tracer-delay -d 'Delay between polling, in microseconds. The default is 500 when seccomp-bpf is enabled, otherwise 1.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l filter -d 'Set the default filter for events.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l filter-include -d 'Aside from the default filter, also include the events specified here.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l filter-exclude -d 'Exclude the events specified here from the default filter.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -s o -l output -d 'Output, stderr by default. A single hyphen \'-\' represents stdout.' -r -F
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l more-colors -d 'More colors'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l less-colors -d 'Less colors'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-cmdline -d 'Print commandline that (hopefully) reproduces what was executed. Note: file descriptors are not handled for now.'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-cmdline -d 'Don\'t print commandline that (hopefully) reproduces what was executed.'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-interpreter -d 'Try to show script interpreter indicated by shebang'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-interpreter -d 'Do not show script interpreter indicated by shebang'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l foreground -d 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-foreground -d 'Do not set the terminal foreground process group to tracee'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l diff-fd -d 'Diff file descriptors with the original std{in/out/err}'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-diff-fd -d 'Do not diff file descriptors'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-fd -d 'Show file descriptors'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-fd -d 'Do not show file descriptors'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l diff-env -d 'Diff environment variables with the original environment'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-diff-env -d 'Do not diff environment variables'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-env -d 'Show environment variables'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-env -d 'Do not show environment variables'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-comm -d 'Show comm'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-comm -d 'Do not show comm'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-argv -d 'Show argv'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-argv -d 'Do not show argv'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-filename -d 'Show filename'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-filename -d 'Do not show filename'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-cwd -d 'Show cwd'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-show-cwd -d 'Do not show cwd'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l decode-errno -d 'Decode errno values'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-decode-errno -d 'Do not decode errno values'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l successful-only -d 'Only show successful calls'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l fd-in-cmdline -d '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l stdio-in-cmdline -d '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l resolve-proc-self-exe -d 'Resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-resolve-proc-self-exe -d 'Do not resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l hide-cloexec-fds -d 'Hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-hide-cloexec-fds -d 'Do not hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l timestamp -d 'Show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l no-timestamp -d 'Do not show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -l show-all-events -d 'Set the default filter to show all events. This option can be used in combination with --filter-exclude to exclude some unwanted events.'
complete -c tracexec -n "__fish_tracexec_using_subcommand log" -s h -l help -d 'Print help'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l inline-timestamp-format -d 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l seccomp-bpf -d 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance' -r -f -a "auto\t''
on\t''
off\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l tracer-delay -d 'Delay between polling, in microseconds. The default is 500 when seccomp-bpf is enabled, otherwise 1.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l filter -d 'Set the default filter for events.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l filter-include -d 'Aside from the default filter, also include the events specified here.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l filter-exclude -d 'Exclude the events specified here from the default filter.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s A -l active-pane -d 'Set the default active pane to use when TUI launches' -r -f -a "terminal\t''
events\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s L -l layout -d 'Set the layout of the TUI when it launches' -r -f -a "horizontal\t''
vertical\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s F -l frame-rate -d 'Set the frame rate of the TUI (60 by default)' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s m -l max-events -d 'Max number of events to keep in TUI (0=unlimited)' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s D -l default-external-command -d 'Set the default external command to run when using "Detach, Stop and Run Command" feature in Hit Manager' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s b -l add-breakpoint -d 'Add a new breakpoint to the tracer. This option can be used multiple times. The format is <syscall-stop>:<pattern-type>:<pattern>, where syscall-stop can be sysenter or sysexit, pattern-type can be argv-regex, in-filename or exact-filename. For example, sysexit:in-filename:/bash' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l successful-only -d 'Only show successful calls'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l fd-in-cmdline -d '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l stdio-in-cmdline -d '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l resolve-proc-self-exe -d 'Resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l no-resolve-proc-self-exe -d 'Do not resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l hide-cloexec-fds -d 'Hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l no-hide-cloexec-fds -d 'Do not hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l timestamp -d 'Show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l no-timestamp -d 'Do not show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l show-all-events -d 'Set the default filter to show all events. This option can be used in combination with --filter-exclude to exclude some unwanted events.'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s t -l tty -d 'Allocate a pseudo terminal and show it alongside the TUI'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s f -l follow -d 'Keep the event list scrolled to the bottom'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l terminate-on-exit -d 'Instead of waiting for the root child to exit, terminate when the TUI exits'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -l kill-on-exit -d 'Instead of waiting for the root child to exit, kill when the TUI exits'
complete -c tracexec -n "__fish_tracexec_using_subcommand tui" -s h -l help -d 'Print help'
complete -c tracexec -n "__fish_tracexec_using_subcommand generate-completions" -s h -l help -d 'Print help'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l inline-timestamp-format -d 'Set the format of inline timestamp. See https://docs.rs/chrono/latest/chrono/format/strftime/index.html for available options.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l seccomp-bpf -d 'Controls whether to enable seccomp-bpf optimization, which greatly improves performance' -r -f -a "auto\t''
on\t''
off\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l tracer-delay -d 'Delay between polling, in microseconds. The default is 500 when seccomp-bpf is enabled, otherwise 1.' -r
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -s F -l format -d 'the format for exported exec events' -r -f -a "json-stream\t''
json\t''"
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -s o -l output -d 'Output, stderr by default. A single hyphen \'-\' represents stdout.' -r -F
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l successful-only -d 'Only show successful calls'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l fd-in-cmdline -d '[Experimental] Try to reproduce file descriptors in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l stdio-in-cmdline -d '[Experimental] Try to reproduce stdio in commandline. This might result in an unexecutable cmdline if pipes, sockets, etc. are involved.'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l resolve-proc-self-exe -d 'Resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l no-resolve-proc-self-exe -d 'Do not resolve /proc/self/exe symlink'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l hide-cloexec-fds -d 'Hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l no-hide-cloexec-fds -d 'Do not hide CLOEXEC fds'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l timestamp -d 'Show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l no-timestamp -d 'Do not show timestamp information'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -s p -l pretty -d 'prettify the output if supported'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l foreground -d 'Set the terminal foreground process group to tracee. This option is useful when tracexec is used interactively. [default]'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -l no-foreground -d 'Do not set the terminal foreground process group to tracee'
complete -c tracexec -n "__fish_tracexec_using_subcommand collect" -s h -l help -d 'Print help'
complete -c tracexec -n "__fish_tracexec_using_subcommand help; and not __fish_seen_subcommand_from log tui generate-completions collect help" -f -a "log" -d 'Run tracexec in logging mode'
complete -c tracexec -n "__fish_tracexec_using_subcommand help; and not __fish_seen_subcommand_from log tui generate-completions collect help" -f -a "tui" -d 'Run tracexec in TUI mode, stdin/out/err are redirected to /dev/null by default'
complete -c tracexec -n "__fish_tracexec_using_subcommand help; and not __fish_seen_subcommand_from log tui generate-completions collect help" -f -a "generate-completions" -d 'Generate shell completions for tracexec'
complete -c tracexec -n "__fish_tracexec_using_subcommand help; and not __fish_seen_subcommand_from log tui generate-completions collect help" -f -a "collect" -d 'Collect exec events and export them'
complete -c tracexec -n "__fish_tracexec_using_subcommand help; and not __fish_seen_subcommand_from log tui generate-completions collect help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
