# This file allows users to call find_package(CppInterOp) and pick up our targets.

# Compute the installation prefix from this CppInterOpConfig.cmake file location.
get_filename_component(CPPINTEROP_INSTALL_PREFIX "${CMAKE_CURRENT_LIST_FILE}" PATH)
get_filename_component(CPPINTEROP_INSTALL_PREFIX "${CPPINTEROP_INSTALL_PREFIX}" PATH)
get_filename_component(CPPINTEROP_INSTALL_PREFIX "${CPPINTEROP_INSTALL_PREFIX}" PATH)
get_filename_component(CPPINTEROP_INSTALL_PREFIX "${CPPINTEROP_INSTALL_PREFIX}" PATH)

# Determine CMAKE_SHARED_LIBRARY_SUFFIX based on operating system
include(CMakeSystemSpecificInformation)

if(MSVC)
  set(shared_lib_dir bin)
else()
  set(shared_lib_dir lib)
endif()

### build/install workaround
if (FALSE)
  set(_lib_suffix ${CMAKE_SHARED_LIBRARY_SUFFIX})
  set(_lib_prefix ${CMAKE_SHARED_LIBRARY_PREFIX})
else()
  set(_lib_suffix ${CMAKE_STATIC_LIBRARY_SUFFIX})
  set(_lib_prefix ${CMAKE_STATIC_LIBRARY_PREFIX})
endif()

if (IS_DIRECTORY "${CPPINTEROP_INSTALL_PREFIX}/include")
  set(_include "${CPPINTEROP_INSTALL_PREFIX}/include")
  set(_lib "${CPPINTEROP_INSTALL_PREFIX}/${shared_lib_dir}/${_lib_prefix}clangCppInterOp${_lib_suffix}")
  set(_cmake "${CPPINTEROP_INSTALL_PREFIX}/${shared_lib_dir}/cmake/CppInterOp")
else()
  set(_include "/build/root/src/root-6.36.02/interpreter/CppInterOp/include")
  set(_lib "/build/root/src/build/interpreter/CppInterOp/${shared_lib_dir}/${_lib_prefix}clangCppInterOp${_lib_suffix}")
  set(_cmake "/build/root/src/build/interpreter/CppInterOp/${shared_lib_dir}/cmake/CppInterOp")
endif()

###

set(CPPINTEROP_EXPORTED_TARGETS "clangCppInterOp")
set(CPPINTEROP_CMAKE_DIR "${_cmake}")
set(CPPINTEROP_INCLUDE_DIRS "${_include}")
set(CPPINTEROP_LIBRARIES "${_lib}")

set(CPPINTEROP_LLVM_VERSION "")
set(CPPINTEROP_LLVM_VERSION_MAJOR "")
set(CPPINTEROP_LLVM_VERSION_MINOR "")
set(CPPINTEROP_LLVM_VERSION_PATCH "")
set(CPPINTEROP_LLVM_VERSION_SUFFIX "")
set(CPPINTEROP_LLVM_PACKAGE_VERSION "")
set(CPPINTEROP_VERSION "1.7.0\;dev")

# Provide all our library targets to users.
if (FALSE)
  add_library(clangCppInterOp SHARED IMPORTED)
else()
  add_library(clangCppInterOp STATIC IMPORTED)
endif()
set_target_properties(clangCppInterOp PROPERTIES
  INTERFACE_INCLUDE_DIRECTORIES ${_include}
  IMPORTED_LOCATION ${_lib}
  )
if (MSVC)
  if (IS_DIRECTORY "${CPPINTEROP_INSTALL_PREFIX}/include")
    set(_static_lib "${CPPINTEROP_INSTALL_PREFIX}/lib/${_lib_prefix}clangCppInterOp.lib")
  else()
    set(_static_lib "/build/root/src/build/interpreter/CppInterOp/lib/${_lib_prefix}clangCppInterOp.lib")
  endif()

  set_target_properties(clangCppInterOp PROPERTIES
    IMPORTED_IMPLIB ${_static_lib}
    )
endif(MSVC)

unset(_lib_prefix)
unset(_lib_suffix)
unset(_cmake)
unset(_include)
unset(_lib)
