"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const core_1 = require("@oclif/core");
const fs_1 = tslib_1.__importDefault(require("fs"));
const utils_1 = tslib_1.__importDefault(require("../classes/utils"));
const utils_2 = require("../lib/utils");
/**
 *
 */
class Tarballs extends core_1.Command {
    static args = {
        tarballs: core_1.Args.string({ description: 'pathTarballs', name: 'pathTarballs', required: false }),
    };
    static description = 'Tarballs';
    static flags = {
        help: core_1.Flags.help({ char: 'h' }),
        release: core_1.Flags.string({ char: 'r', description: 'release' }),
        verbose: core_1.Flags.boolean({ char: 'v', description: 'verbose' }),
    };
    static summary = 'rename tarballs with release.';
    /**
     *
     */
    async run() {
        const { args, flags } = await this.parse(Tarballs);
        let { release } = flags;
        if (release === undefined) {
            release = '1';
        }
        const { verbose } = flags;
        const echo = utils_1.default.setEcho(verbose);
        // 
        const here = process.cwd() + '/';
        let pathSource = here;
        const content = fs_1.default.readFileSync(pathSource + 'package.json', 'utf8');
        const packageJson = JSON.parse(content);
        let { mantainer } = packageJson;
        if (mantainer === undefined) {
            mantainer = packageJson.author;
        }
        if (mantainer === undefined) {
            mantainer = 'made on Perris\' Brewery';
        }
        const { description } = packageJson;
        const tarballsVersion = packageJson.version;
        const tarballsRelease = release;
        const tarballsName = packageJson.name;
        let tarballsNameVersioned = `${tarballsName}_${tarballsVersion}-${tarballsRelease}-linux-x64.tar.gz`;
        await (0, utils_2.exec)(`mv ${here}dist/eggs-v${tarballsVersion}-*-linux-x64.tar.gz ${here}dist/${tarballsNameVersioned}`);
        console.log(`created ${tarballsNameVersioned}`);
    }
}
exports.default = Tarballs;
