import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFrontClient";
import { DisassociateDistributionTenantWebACLRequest, DisassociateDistributionTenantWebACLResult } from "../models/models_1";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisassociateDistributionTenantWebACLCommand}.
 */
export interface DisassociateDistributionTenantWebACLCommandInput extends DisassociateDistributionTenantWebACLRequest {
}
/**
 * @public
 *
 * The output of {@link DisassociateDistributionTenantWebACLCommand}.
 */
export interface DisassociateDistributionTenantWebACLCommandOutput extends DisassociateDistributionTenantWebACLResult, __MetadataBearer {
}
declare const DisassociateDistributionTenantWebACLCommand_base: {
    new (input: DisassociateDistributionTenantWebACLCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateDistributionTenantWebACLCommandInput, DisassociateDistributionTenantWebACLCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DisassociateDistributionTenantWebACLCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateDistributionTenantWebACLCommandInput, DisassociateDistributionTenantWebACLCommandOutput, CloudFrontClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disassociates a distribution tenant from the WAF web ACL.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFrontClient, DisassociateDistributionTenantWebACLCommand } from "@aws-sdk/client-cloudfront"; // ES Modules import
 * // const { CloudFrontClient, DisassociateDistributionTenantWebACLCommand } = require("@aws-sdk/client-cloudfront"); // CommonJS import
 * const client = new CloudFrontClient(config);
 * const input = { // DisassociateDistributionTenantWebACLRequest
 *   Id: "STRING_VALUE", // required
 *   IfMatch: "STRING_VALUE",
 * };
 * const command = new DisassociateDistributionTenantWebACLCommand(input);
 * const response = await client.send(command);
 * // { // DisassociateDistributionTenantWebACLResult
 * //   Id: "STRING_VALUE",
 * //   ETag: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DisassociateDistributionTenantWebACLCommandInput - {@link DisassociateDistributionTenantWebACLCommandInput}
 * @returns {@link DisassociateDistributionTenantWebACLCommandOutput}
 * @see {@link DisassociateDistributionTenantWebACLCommandInput} for command's `input` shape.
 * @see {@link DisassociateDistributionTenantWebACLCommandOutput} for command's `response` shape.
 * @see {@link CloudFrontClientResolvedConfig | config} for CloudFrontClient's `config` shape.
 *
 * @throws {@link AccessDenied} (client fault)
 *  <p>Access denied.</p>
 *
 * @throws {@link EntityNotFound} (client fault)
 *  <p>The entity was not found.</p>
 *
 * @throws {@link InvalidArgument} (client fault)
 *  <p>An argument is invalid.</p>
 *
 * @throws {@link InvalidIfMatchVersion} (client fault)
 *  <p>The <code>If-Match</code> version is missing or not valid.</p>
 *
 * @throws {@link PreconditionFailed} (client fault)
 *  <p>The precondition in one or more of the request fields evaluated to <code>false</code>.</p>
 *
 * @throws {@link CloudFrontServiceException}
 * <p>Base exception class for all service exceptions from CloudFront service.</p>
 *
 *
 * @public
 */
export declare class DisassociateDistributionTenantWebACLCommand extends DisassociateDistributionTenantWebACLCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisassociateDistributionTenantWebACLRequest;
            output: DisassociateDistributionTenantWebACLResult;
        };
        sdk: {
            input: DisassociateDistributionTenantWebACLCommandInput;
            output: DisassociateDistributionTenantWebACLCommandOutput;
        };
    };
}
