/**
 * ./src/classes/pxe.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IDhcpOptions, ITftpOptions } from '../dhcpd-proxy/interfaces/i-pxe.js';
import Distro from './distro.js';
import Settings from './settings.js';
/**
 * Pxe:
 */
export default class Pxe {
    bootLabel: string;
    echo: {};
    eggRoot: string;
    initrdImg: string;
    isos: string[];
    nest: string;
    pxeRoot: string;
    distro: Distro;
    settings: Settings;
    verbose: boolean;
    vmlinuz: string;
    /**
     * constructor
     * @param nest
     * @param pxeRoot
     */
    constructor(nest?: string, pxeRoot?: string);
    /**
     * fertilization()
     *
     * cuckoo's nest
     */
    fertilization(): Promise<void>;
    /**
     * build
     */
    build(): Promise<void>;
    /**
     *
     * @param dhcpOptions
     */
    dhcpdStart(dhcpOptions: IDhcpOptions): void;
    /**
     * start http server for images
     */
    httpStart(): Promise<void>;
    /**
     * start tftp
     */
    tftpStart(tftpOptions: ITftpOptions): Promise<void>;
    /**
     * configure PXE http server
     */
    private http;
    /**
     * configure PXE bios
     */
    private bios;
    /**
    * uefi: uso ipxe solo per chainload di grub
    */
    private uefi;
    /**
     * grubCfg
     * @param familyId
     */
    private grubCfg;
    /**
     * Metodo helper per ottenere i parametri corretti per GRUB
     * in base alla famiglia della distribuzione.
     */
    private _getKernelParameters;
}
