/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;

public class RebalanceCallbackMetricsManager {
    final MetricName partitionRevokeLatencyAvg;
    final MetricName partitionAssignLatencyAvg;
    final MetricName partitionLostLatencyAvg;
    final MetricName partitionRevokeLatencyMax;
    final MetricName partitionAssignLatencyMax;
    final MetricName partitionLostLatencyMax;
    private final Sensor partitionRevokeCallbackSensor;
    private final Sensor partitionAssignCallbackSensor;
    private final Sensor partitionLostCallbackSensor;

    public RebalanceCallbackMetricsManager(Metrics metrics) {
        this(metrics, "consumer");
    }

    public RebalanceCallbackMetricsManager(Metrics metrics, String grpMetricsPrefix) {
        String metricGroupName = grpMetricsPrefix + "-coordinator-metrics";
        this.partitionRevokeCallbackSensor = metrics.sensor("partition-revoked-latency");
        this.partitionRevokeLatencyAvg = metrics.metricName("partition-revoked-latency-avg", metricGroupName, "The average time taken for a partition-revoked rebalance listener callback");
        this.partitionRevokeCallbackSensor.add(this.partitionRevokeLatencyAvg, new Avg());
        this.partitionRevokeLatencyMax = metrics.metricName("partition-revoked-latency-max", metricGroupName, "The max time taken for a partition-revoked rebalance listener callback");
        this.partitionRevokeCallbackSensor.add(this.partitionRevokeLatencyMax, new Max());
        this.partitionAssignCallbackSensor = metrics.sensor("partition-assigned-latency");
        this.partitionAssignLatencyAvg = metrics.metricName("partition-assigned-latency-avg", metricGroupName, "The average time taken for a partition-assigned rebalance listener callback");
        this.partitionAssignCallbackSensor.add(this.partitionAssignLatencyAvg, new Avg());
        this.partitionAssignLatencyMax = metrics.metricName("partition-assigned-latency-max", metricGroupName, "The max time taken for a partition-assigned rebalance listener callback");
        this.partitionAssignCallbackSensor.add(this.partitionAssignLatencyMax, new Max());
        this.partitionLostCallbackSensor = metrics.sensor("partition-lost-latency");
        this.partitionLostLatencyAvg = metrics.metricName("partition-lost-latency-avg", metricGroupName, "The average time taken for a partition-lost rebalance listener callback");
        this.partitionLostCallbackSensor.add(this.partitionLostLatencyAvg, new Avg());
        this.partitionLostLatencyMax = metrics.metricName("partition-lost-latency-max", metricGroupName, "The max time taken for a partition-lost rebalance listener callback");
        this.partitionLostCallbackSensor.add(this.partitionLostLatencyMax, new Max());
    }

    public void recordPartitionsRevokedLatency(long latencyMs) {
        this.partitionRevokeCallbackSensor.record(latencyMs);
    }

    public void recordPartitionsAssignedLatency(long latencyMs) {
        this.partitionAssignCallbackSensor.record(latencyMs);
    }

    public void recordPartitionsLostLatency(long latencyMs) {
        this.partitionLostCallbackSensor.record(latencyMs);
    }
}

