/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.grouping.CollapseTopFieldDocs;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.FilteredCollector;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.neuralsearch.search.HitsThresholdChecker;
import org.opensearch.neuralsearch.search.collector.HybridCollapsingTopDocsCollector;
import org.opensearch.neuralsearch.search.collector.HybridCollectorFactory;
import org.opensearch.neuralsearch.search.collector.HybridCollectorFactoryDTO;
import org.opensearch.neuralsearch.search.collector.HybridSearchCollector;
import org.opensearch.neuralsearch.search.collector.HybridTopFieldDocSortCollector;
import org.opensearch.neuralsearch.search.collector.HybridTopScoreDocCollector;
import org.opensearch.neuralsearch.search.query.TopDocsMerger;
import org.opensearch.neuralsearch.search.query.exception.HybridSearchRescoreQueryException;
import org.opensearch.neuralsearch.search.util.HybridSearchResultFormatUtil;
import org.opensearch.neuralsearch.util.HybridQueryUtil;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.MultiCollectorWrapper;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.rescore.RescoreContext;
import org.opensearch.search.sort.SortAndFormats;

public abstract class HybridCollectorManager
implements CollectorManager<Collector, ReduceableSearchResult> {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridCollectorManager.class);
    private final int numHits;
    private final HitsThresholdChecker hitsThresholdChecker;
    private final int trackTotalHitsUpTo;
    private final SortAndFormats sortAndFormats;
    @Nullable
    private final Weight filterWeight;
    private static final float boostFactor = 1.0f;
    private final TopDocsMerger topDocsMerger;
    @Nullable
    private final FieldDoc after;
    private final SearchContext searchContext;
    private final CollapseContext collapseContext;
    private final Set<Class<?>> VALID_COLLECTOR_TYPES = Set.of(HybridTopScoreDocCollector.class, HybridTopFieldDocSortCollector.class, HybridCollapsingTopDocsCollector.class);

    public static CollectorManager createHybridCollectorManager(SearchContext searchContext) throws IOException {
        boolean isSingleShard;
        if (searchContext.scrollContext() != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Scroll operation is not supported in hybrid query", new Object[0]));
        }
        IndexReader reader = searchContext.searcher().getIndexReader();
        int totalNumDocs = Math.max(0, reader.numDocs());
        int numDocs = Math.min(HybridCollectorManager.getSubqueryResultsRetrievalSize(searchContext), totalNumDocs);
        int trackTotalHitsUpTo = searchContext.trackTotalHitsUpTo();
        if (searchContext.sort() != null) {
            HybridCollectorManager.validateSortCriteria(searchContext, searchContext.trackScores());
        }
        boolean bl = isSingleShard = searchContext.numberOfShards() == 1;
        if (isSingleShard && searchContext.from() > 0) {
            searchContext.from(0);
        }
        Weight filteringWeight = null;
        if (Objects.nonNull(searchContext.parsedPostFilter()) && Objects.nonNull(searchContext.parsedPostFilter().query())) {
            Query filterQuery = searchContext.parsedPostFilter().query();
            ContextIndexSearcher searcher = searchContext.searcher();
            filteringWeight = searcher.createWeight(searcher.rewrite(filterQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        }
        return searchContext.shouldUseConcurrentSearch() ? new HybridCollectorConcurrentSearchManager(numDocs, new HitsThresholdChecker(Math.max(numDocs, searchContext.trackTotalHitsUpTo())), trackTotalHitsUpTo, filteringWeight, searchContext) : new HybridCollectorNonConcurrentManager(numDocs, new HitsThresholdChecker(Math.max(numDocs, searchContext.trackTotalHitsUpTo())), trackTotalHitsUpTo, filteringWeight, searchContext);
    }

    public Collector newCollector() {
        Collector hybridCollector = HybridCollectorFactory.createCollector(HybridCollectorFactoryDTO.builder().collapseContext(this.collapseContext).sortAndFormats(this.sortAndFormats).searchContext(this.searchContext).hitsThresholdChecker(this.hitsThresholdChecker).numHits(this.numHits).after(this.after).build());
        return Objects.nonNull(this.filterWeight) ? new FilteredCollector(hybridCollector, this.filterWeight) : hybridCollector;
    }

    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        List<HybridSearchCollector> hybridSearchCollectors = this.getHybridSearchCollectors(collectors);
        if (hybridSearchCollectors.isEmpty()) {
            throw new IllegalStateException("cannot collect results of hybrid search query, there are no proper collectors");
        }
        return this.reduceSearchResults(this.getSearchResults(hybridSearchCollectors));
    }

    private List<ReduceableSearchResult> getSearchResults(List<HybridSearchCollector> hybridSearchCollectors) throws IOException {
        ArrayList<ReduceableSearchResult> results = new ArrayList<ReduceableSearchResult>();
        DocValueFormat[] docValueFormats = this.getSortValueFormats(this.sortAndFormats);
        for (HybridSearchCollector collector : hybridSearchCollectors) {
            boolean isSortEnabled = docValueFormats != null;
            boolean isCollapseEnabled = collector instanceof HybridCollapsingTopDocsCollector;
            TopDocsAndMaxScore topDocsAndMaxScore = this.getTopDocsAndAndMaxScore(collector, isSortEnabled, isCollapseEnabled);
            results.add(result -> {
                DocValueFormat[] docValueFormatArray;
                if (isCollapseEnabled && !isSortEnabled) {
                    DocValueFormat[] docValueFormatArray2 = new DocValueFormat[1];
                    docValueFormatArray = docValueFormatArray2;
                    docValueFormatArray2[0] = DocValueFormat.RAW;
                } else {
                    docValueFormatArray = docValueFormats;
                }
                this.reduceCollectorResults(result, topDocsAndMaxScore, docValueFormatArray);
            });
        }
        return results;
    }

    private TopDocsAndMaxScore getTopDocsAndAndMaxScore(HybridSearchCollector hybridSearchCollector, boolean isSortEnabled, boolean isCollapseEnabled) throws IOException {
        List<TopDocs> topDocs = hybridSearchCollector.topDocs();
        if (isSortEnabled || isCollapseEnabled) {
            return this.getSortedTopDocsAndMaxScore(topDocs, hybridSearchCollector, isCollapseEnabled);
        }
        return this.getTopDocsAndMaxScore(topDocs, hybridSearchCollector);
    }

    private TopDocsAndMaxScore getSortedTopDocsAndMaxScore(List<TopFieldDocs> topDocs, HybridSearchCollector hybridSearchCollector, boolean isCollapseEnabled) {
        TopDocs sortedTopDocs = this.getNewTopFieldDocs(this.getTotalHits(this.trackTotalHitsUpTo, topDocs, hybridSearchCollector.getTotalHits()), topDocs, this.sortAndFormats == null ? null : this.sortAndFormats.sort.getSort(), isCollapseEnabled);
        return new TopDocsAndMaxScore(sortedTopDocs, hybridSearchCollector.getMaxScore());
    }

    private TopDocsAndMaxScore getTopDocsAndMaxScore(List<TopDocs> topDocs, HybridSearchCollector hybridSearchCollector) {
        if (this.shouldRescore()) {
            topDocs = this.rescore(topDocs);
        }
        float maxScore = this.calculateMaxScore(topDocs, hybridSearchCollector.getMaxScore());
        TopDocs finalTopDocs = this.getNewTopDocs(this.getTotalHits(this.trackTotalHitsUpTo, topDocs, hybridSearchCollector.getTotalHits()), topDocs);
        return new TopDocsAndMaxScore(finalTopDocs, maxScore);
    }

    private boolean shouldRescore() {
        List rescoreContexts = this.searchContext.rescore();
        return Objects.nonNull(rescoreContexts) && !rescoreContexts.isEmpty();
    }

    private List<TopDocs> rescore(List<TopDocs> topDocs) {
        List<TopDocs> rescoredTopDocs = topDocs;
        for (RescoreContext ctx : this.searchContext.rescore()) {
            rescoredTopDocs = this.rescoredTopDocs(ctx, rescoredTopDocs);
        }
        return rescoredTopDocs;
    }

    private List<TopDocs> rescoredTopDocs(RescoreContext ctx, List<TopDocs> topDocs) {
        ArrayList<TopDocs> result = new ArrayList<TopDocs>(topDocs.size());
        for (TopDocs topDoc : topDocs) {
            try {
                result.add(ctx.rescorer().rescore(topDoc, (IndexSearcher)this.searchContext.searcher(), ctx));
            }
            catch (IOException exception) {
                log.error("rescore failed for hybrid query in collector_manager.reduce call", (Throwable)exception);
                throw new HybridSearchRescoreQueryException(exception);
            }
        }
        return result;
    }

    private float calculateMaxScore(List<TopDocs> topDocsList, float initialMaxScore) {
        List rescoreContexts = this.searchContext.rescore();
        if (Objects.nonNull(rescoreContexts) && !rescoreContexts.isEmpty()) {
            for (TopDocs topDocs : topDocsList) {
                if (!Objects.nonNull(topDocs.scoreDocs) || topDocs.scoreDocs.length <= 0) continue;
                initialMaxScore = Math.max(initialMaxScore, topDocs.scoreDocs[0].score);
            }
        }
        return initialMaxScore;
    }

    private List<HybridSearchCollector> getHybridSearchCollectors(Collection<Collector> collectors) {
        ArrayList<HybridSearchCollector> hybridSearchCollectors = new ArrayList<HybridSearchCollector>();
        for (Collector collector : collectors) {
            if (collector instanceof MultiCollectorWrapper) {
                for (Collector sub : ((MultiCollectorWrapper)collector).getCollectors()) {
                    if (!(sub instanceof HybridTopScoreDocCollector) && !(sub instanceof HybridTopFieldDocSortCollector)) continue;
                    hybridSearchCollectors.add((HybridSearchCollector)sub);
                }
                continue;
            }
            if (this.isHybridNonFilteredCollector(collector)) {
                hybridSearchCollectors.add((HybridSearchCollector)collector);
                continue;
            }
            if (!this.isHybridFilteredCollector(collector)) continue;
            hybridSearchCollectors.add((HybridSearchCollector)((FilteredCollector)collector).getCollector());
        }
        return hybridSearchCollectors;
    }

    private boolean isHybridNonFilteredCollector(Collector collector) {
        return this.VALID_COLLECTOR_TYPES.stream().anyMatch(type -> type.isInstance(collector));
    }

    private boolean isHybridFilteredCollector(Collector collector) {
        return collector instanceof FilteredCollector && this.VALID_COLLECTOR_TYPES.stream().anyMatch(type -> type.isInstance(((FilteredCollector)collector).getCollector()));
    }

    private static void validateSortCriteria(SearchContext searchContext, boolean trackScores) {
        SortField[] sortFields = searchContext.sort().sort.getSort();
        boolean hasFieldSort = false;
        boolean hasScoreSort = false;
        for (SortField sortField : sortFields) {
            SortField.Type type = sortField.getType();
            if (type.equals((Object)SortField.Type.SCORE)) {
                hasScoreSort = true;
            } else {
                hasFieldSort = true;
            }
            if (hasScoreSort && hasFieldSort) break;
        }
        if (hasScoreSort && hasFieldSort) {
            throw new IllegalArgumentException("_score sort criteria cannot be applied with any other criteria. Please select one sort criteria out of them.");
        }
        if (trackScores && hasFieldSort) {
            throw new IllegalArgumentException("Hybrid search results when sorted by any field, docId or _id, track_scores must be set to false.");
        }
        if (trackScores && hasScoreSort) {
            throw new IllegalArgumentException("Hybrid search results are by default sorted by _score, track_scores must be set to false.");
        }
    }

    private TopDocs getNewTopDocs(TotalHits totalHits, List<TopDocs> topDocs) {
        boolean isCollapseEnabled = !topDocs.isEmpty() && topDocs.get(0) instanceof CollapseTopFieldDocs;
        ScoreDoc[] scoreDocs = new ScoreDoc[]{};
        ArrayList<Object> collapseValues = new ArrayList<Object>();
        String collapseField = "";
        ArrayList fieldDocs = new ArrayList();
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        if (Objects.nonNull(topDocs)) {
            int delimiterDocId = topDocs.stream().filter(Objects::nonNull).filter(topDoc -> Objects.nonNull(topDoc.scoreDocs)).map(topDoc -> topDoc.scoreDocs).filter(scoreDoc -> ((ScoreDoc[])scoreDoc).length > 0).map(scoreDoc -> scoreDoc[0].doc).findFirst().orElse(-1);
            if (delimiterDocId == -1) {
                return new TopDocs(totalHits, scoreDocs);
            }
            if (isCollapseEnabled) {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] fields = new Object[]{};
                result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, fields));
                collapseValues.add(0);
                for (TopDocs topDoc2 : topDocs) {
                    CollapseTopFieldDocs collapseTopFieldDoc = (CollapseTopFieldDocs)topDoc2;
                    collapseField = collapseTopFieldDoc.field;
                    sortFields.addAll(Arrays.asList(collapseTopFieldDoc.fields));
                    if (Objects.isNull(topDoc2) || Objects.isNull(topDoc2.scoreDocs)) {
                        result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, fields));
                        continue;
                    }
                    ArrayList<FieldDoc> fieldDocsPerQuery = new ArrayList<FieldDoc>();
                    for (ScoreDoc scoreDoc2 : collapseTopFieldDoc.scoreDocs) {
                        fieldDocsPerQuery.add(new FieldDoc(scoreDoc2.doc, scoreDoc2.score, new Object[0]));
                    }
                    result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, fields));
                    result.addAll(fieldDocsPerQuery);
                    collapseValues.add(0);
                    collapseValues.addAll(Arrays.asList(collapseTopFieldDoc.collapseValues));
                }
                result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, fields));
                collapseValues.add(0);
                fieldDocs.addAll(result);
            } else {
                ArrayList<ScoreDoc> result = new ArrayList<ScoreDoc>();
                result.add(HybridSearchResultFormatUtil.createStartStopElementForHybridSearchResults(delimiterDocId));
                for (TopDocs topDoc3 : topDocs) {
                    if (Objects.isNull(topDoc3) || Objects.isNull(topDoc3.scoreDocs)) {
                        result.add(HybridSearchResultFormatUtil.createDelimiterElementForHybridSearchResults(delimiterDocId));
                        continue;
                    }
                    result.add(HybridSearchResultFormatUtil.createDelimiterElementForHybridSearchResults(delimiterDocId));
                    result.addAll(Arrays.asList(topDoc3.scoreDocs));
                }
                result.add(HybridSearchResultFormatUtil.createStartStopElementForHybridSearchResults(delimiterDocId));
                scoreDocs = (ScoreDoc[])result.stream().map(doc -> new ScoreDoc(doc.doc, doc.score, doc.shardIndex)).toArray(ScoreDoc[]::new);
            }
        }
        if (isCollapseEnabled) {
            return new CollapseTopFieldDocs(collapseField, totalHits, (ScoreDoc[])fieldDocs.toArray(new FieldDoc[0]), sortFields.toArray(new SortField[0]), collapseValues.toArray(new Object[0]));
        }
        return new TopDocs(totalHits, scoreDocs);
    }

    private TotalHits getTotalHits(int trackTotalHitsUpTo, List<?> topDocs, long maxTotalHits) {
        TotalHits.Relation relation;
        TotalHits.Relation relation2 = relation = trackTotalHitsUpTo == -1 ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        if (topDocs == null || topDocs.isEmpty()) {
            return new TotalHits(0L, relation);
        }
        return new TotalHits(maxTotalHits, relation);
    }

    private TopDocs getNewTopFieldDocs(TotalHits totalHits, List<TopFieldDocs> topFieldDocs, SortField[] sortFields, boolean isCollapseEnabled) {
        if (Objects.isNull(topFieldDocs)) {
            return new TopFieldDocs(totalHits, (ScoreDoc[])new FieldDoc[0], sortFields);
        }
        int delimiterDocId = topFieldDocs.stream().filter(Objects::nonNull).filter(topDoc -> Objects.nonNull(topDoc.scoreDocs)).map(topFieldDoc -> topFieldDoc.scoreDocs).filter(scoreDoc -> ((ScoreDoc[])scoreDoc).length > 0).map(scoreDoc -> scoreDoc[0].doc).findFirst().orElse(-1);
        if (delimiterDocId == -1) {
            SortField[] sortFieldArray;
            FieldDoc[] fieldDocArray = new FieldDoc[]{};
            if (sortFields == null) {
                SortField[] sortFieldArray2 = new SortField[1];
                sortFieldArray = sortFieldArray2;
                sortFieldArray2[0] = new SortField(null, SortField.Type.SCORE);
            } else {
                sortFieldArray = sortFields;
            }
            return new TopFieldDocs(totalHits, (ScoreDoc[])fieldDocArray, sortFieldArray);
        }
        if (isCollapseEnabled) {
            ArrayList<Object> collapseValues = new ArrayList<Object>();
            String collapseField = "";
            ArrayList fieldDocs = new ArrayList();
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] fields = HybridSearchResultFormatUtil.createSortFieldsForDelimiterResults(topFieldDocs.getFirst().fields);
            result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, fields));
            collapseValues.add(new BytesRef(HybridSearchResultFormatUtil.createCollapseValueStartStopElementForHybridSearchResults()));
            for (TopDocs topDocs : topFieldDocs) {
                CollapseTopFieldDocs collapseTopFieldDoc = (CollapseTopFieldDocs)topDocs;
                collapseField = collapseTopFieldDoc.field;
                if (Objects.isNull(topDocs) || Objects.isNull(topDocs.scoreDocs)) {
                    result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, fields));
                    continue;
                }
                ArrayList<FieldDoc> fieldDocsPerQuery = new ArrayList<FieldDoc>();
                for (ScoreDoc scoreDoc2 : collapseTopFieldDoc.scoreDocs) {
                    fieldDocsPerQuery.add((FieldDoc)scoreDoc2);
                }
                result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, fields));
                result.addAll(fieldDocsPerQuery);
                collapseValues.add(new BytesRef(HybridSearchResultFormatUtil.createCollapseValueDelimiterElementForHybridSearchResults()));
                collapseValues.addAll(Arrays.asList(collapseTopFieldDoc.collapseValues));
            }
            result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, fields));
            collapseValues.add(new BytesRef(HybridSearchResultFormatUtil.createCollapseValueStartStopElementForHybridSearchResults()));
            fieldDocs.addAll(result);
            return new CollapseTopFieldDocs(collapseField, totalHits, (ScoreDoc[])fieldDocs.toArray(new FieldDoc[0]), topFieldDocs.getFirst().fields, collapseValues.toArray(new Object[0]));
        }
        Object[] sortFieldsForDelimiterResults = HybridSearchResultFormatUtil.createSortFieldsForDelimiterResults(sortFields);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, sortFieldsForDelimiterResults));
        for (TopFieldDocs topFieldDoc2 : topFieldDocs) {
            if (Objects.isNull(topFieldDoc2) || Objects.isNull(topFieldDoc2.scoreDocs)) {
                result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, sortFieldsForDelimiterResults));
                continue;
            }
            ArrayList<FieldDoc> fieldDocsPerQuery = new ArrayList<FieldDoc>();
            for (ScoreDoc scoreDoc3 : topFieldDoc2.scoreDocs) {
                fieldDocsPerQuery.add((FieldDoc)scoreDoc3);
            }
            result.add(HybridSearchResultFormatUtil.createFieldDocDelimiterElementForHybridSearchResults(delimiterDocId, sortFieldsForDelimiterResults));
            result.addAll(fieldDocsPerQuery);
        }
        result.add(HybridSearchResultFormatUtil.createFieldDocStartStopElementForHybridSearchResults(delimiterDocId, sortFieldsForDelimiterResults));
        FieldDoc[] fieldDocs = result.toArray(new FieldDoc[0]);
        return new TopFieldDocs(totalHits, (ScoreDoc[])fieldDocs, sortFields);
    }

    private DocValueFormat[] getSortValueFormats(SortAndFormats sortAndFormats) {
        return sortAndFormats == null ? null : sortAndFormats.formats;
    }

    private void reduceCollectorResults(QuerySearchResult result, TopDocsAndMaxScore topDocsAndMaxScore, DocValueFormat[] docValueFormats) {
        if (result.hasConsumedTopDocs()) {
            result.topDocs(topDocsAndMaxScore, docValueFormats);
            return;
        }
        if (topDocsAndMaxScore.topDocs.totalHits.value() == 0L) {
            return;
        }
        TopDocsAndMaxScore originalTotalDocsAndHits = result.topDocs();
        TopDocsAndMaxScore mergeTopDocsAndMaxScores = this.topDocsMerger.merge(originalTotalDocsAndHits, topDocsAndMaxScore);
        result.topDocs(mergeTopDocsAndMaxScores, docValueFormats);
    }

    private ReduceableSearchResult reduceSearchResults(List<ReduceableSearchResult> results) {
        return result -> {
            for (ReduceableSearchResult r : results) {
                r.reduce(result);
            }
        };
    }

    private static int getSubqueryResultsRetrievalSize(SearchContext searchContext) {
        HybridQuery hybridQuery = HybridCollectorManager.unwrapHybridQuery(searchContext);
        Integer paginationDepth = hybridQuery.getQueryContext().getPaginationDepth();
        if (Objects.isNull(paginationDepth) && searchContext.from() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "pagination_depth param is missing in the search request", new Object[0]));
        }
        if (Objects.nonNull(paginationDepth)) {
            return paginationDepth;
        }
        return searchContext.size();
    }

    private static HybridQuery unwrapHybridQuery(SearchContext searchContext) {
        HybridQuery hybridQuery;
        Query query = searchContext.query();
        if (HybridQueryUtil.isHybridQueryWrappedInBooleanQuery(searchContext, searchContext.query())) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            hybridQuery = (HybridQuery)((BooleanClause)booleanQuery.clauses().get(0)).query();
        } else {
            hybridQuery = (HybridQuery)query;
        }
        return hybridQuery;
    }

    @Generated
    public HybridCollectorManager(int numHits, HitsThresholdChecker hitsThresholdChecker, int trackTotalHitsUpTo, SortAndFormats sortAndFormats, Weight filterWeight, TopDocsMerger topDocsMerger, FieldDoc after, SearchContext searchContext, CollapseContext collapseContext) {
        this.numHits = numHits;
        this.hitsThresholdChecker = hitsThresholdChecker;
        this.trackTotalHitsUpTo = trackTotalHitsUpTo;
        this.sortAndFormats = sortAndFormats;
        this.filterWeight = filterWeight;
        this.topDocsMerger = topDocsMerger;
        this.after = after;
        this.searchContext = searchContext;
        this.collapseContext = collapseContext;
    }

    static class HybridCollectorConcurrentSearchManager
    extends HybridCollectorManager {
        public HybridCollectorConcurrentSearchManager(int numHits, HitsThresholdChecker hitsThresholdChecker, int trackTotalHitsUpTo, Weight filteringWeight, SearchContext searchContext) {
            super(numHits, hitsThresholdChecker, trackTotalHitsUpTo, searchContext.sort(), filteringWeight, new TopDocsMerger(searchContext.sort()), searchContext.searchAfter(), searchContext, null);
        }
    }

    static class HybridCollectorNonConcurrentManager
    extends HybridCollectorManager {
        private final Collector scoreCollector = Objects.requireNonNull(super.newCollector(), "collector for hybrid query cannot be null");

        public HybridCollectorNonConcurrentManager(int numHits, HitsThresholdChecker hitsThresholdChecker, int trackTotalHitsUpTo, Weight filteringWeight, SearchContext searchContext) {
            super(numHits, hitsThresholdChecker, trackTotalHitsUpTo, searchContext.sort(), filteringWeight, new TopDocsMerger(searchContext.sort()), searchContext.searchAfter(), searchContext, searchContext.collapse());
        }

        @Override
        public Collector newCollector() {
            return this.scoreCollector;
        }

        @Override
        public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
            assert (collectors.isEmpty()) : "reduce on HybridCollectorNonConcurrentManager called with non-empty collectors";
            return super.reduce(List.of(this.scoreCollector));
        }
    }
}

