/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.index.analysis.AnalysisRegistry;
import org.opensearch.ingest.AbstractBatchingSystemProcessor;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.chunker.Chunker;
import org.opensearch.neuralsearch.processor.chunker.ChunkerFactory;
import org.opensearch.neuralsearch.processor.semantic.SemanticFieldProcessor;
import org.opensearch.neuralsearch.util.SemanticMappingUtils;

public final class SemanticFieldProcessorFactory
extends AbstractBatchingSystemProcessor.Factory {
    public static final String PROCESSOR_FACTORY_TYPE = "system_ingest_processor_factory_semantic_field";
    private static final int DEFAULT_BATCH_SIZE = 10;
    private final MLCommonsClientAccessor mlClientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;
    private final AnalysisRegistry analysisRegistry;

    public SemanticFieldProcessorFactory(MLCommonsClientAccessor mlClientAccessor, Environment environment, ClusterService clusterService, AnalysisRegistry analysisRegistry) {
        super(PROCESSOR_FACTORY_TYPE);
        this.mlClientAccessor = mlClientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
        this.analysisRegistry = analysisRegistry;
    }

    protected AbstractBatchingSystemProcessor newProcessor(String tag, String description, Map<String, Object> config) {
        ArrayList<Map> mappings = new ArrayList<Map>();
        Object mappingFromIndex = config.get("index_mappings");
        Object mappingFromTemplates = config.get("index_template_mappings");
        if (mappingFromTemplates instanceof List) {
            mappings.addAll((List)mappingFromTemplates);
        }
        if (mappingFromIndex instanceof Map) {
            mappings.add((Map)mappingFromIndex);
        }
        if (mappings.isEmpty()) {
            return null;
        }
        if (description == null) {
            description = "This is a system ingest processor for semantic fields. It will do text chunking and embedding generation for semantic fields.";
        }
        HashMap<String, Map<String, Object>> semanticFieldPathToConfigMap = new HashMap<String, Map<String, Object>>();
        for (Map mapping : mappings) {
            Map<String, Object> properties = SemanticMappingUtils.getProperties(mapping);
            if (properties.isEmpty()) continue;
            SemanticMappingUtils.collectSemanticField(properties, semanticFieldPathToConfigMap);
        }
        if (semanticFieldPathToConfigMap.isEmpty()) {
            return null;
        }
        return new SemanticFieldProcessor(tag, description, 10, semanticFieldPathToConfigMap, this.mlClientAccessor, this.environment, this.clusterService, this.createDefaultTextChunker());
    }

    private Chunker createDefaultTextChunker() {
        HashMap<String, Object> chunkerParameters = new HashMap<String, Object>();
        chunkerParameters.put("analysis_registry", this.analysisRegistry);
        return ChunkerFactory.create("fixed_token_length", chunkerParameters);
    }
}

