/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.dto;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.chunker.Chunker;

public class SemanticFieldInfo {
    private String value;
    private String modelId;
    private String semanticFieldFullPathInMapping;
    private String semanticInfoFullPathInDoc;
    private Boolean chunkingEnabled;
    private List<Chunker> chunkers;
    private List<String> chunks;

    public String getFullPathForChunksInDoc() {
        if (Boolean.TRUE.equals(this.chunkingEnabled)) {
            return this.semanticInfoFullPathInDoc + "." + "chunks";
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Should not try to get full path to chunks for the semantic field at %s when the chunking is not enabled.", this.semanticFieldFullPathInMapping));
    }

    public String getFullPathForEmbeddingInDoc(int index) {
        if (Boolean.TRUE.equals(this.chunkingEnabled)) {
            return this.semanticInfoFullPathInDoc + "." + "chunks" + "." + index + "." + "embedding";
        }
        if (index != 0) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Should not try to get the full path for the embedding with index %d when the chunking is not enabled for the semantic field at %s.", index, this.semanticFieldFullPathInMapping));
        }
        return this.semanticInfoFullPathInDoc + "." + "embedding";
    }

    public String getFullPathForModelInfoInDoc() {
        return this.semanticInfoFullPathInDoc + "." + "model";
    }

    @Generated
    SemanticFieldInfo(String value, String modelId, String semanticFieldFullPathInMapping, String semanticInfoFullPathInDoc, Boolean chunkingEnabled, List<Chunker> chunkers, List<String> chunks) {
        this.value = value;
        this.modelId = modelId;
        this.semanticFieldFullPathInMapping = semanticFieldFullPathInMapping;
        this.semanticInfoFullPathInDoc = semanticInfoFullPathInDoc;
        this.chunkingEnabled = chunkingEnabled;
        this.chunkers = chunkers;
        this.chunks = chunks;
    }

    @Generated
    public static SemanticFieldInfoBuilder builder() {
        return new SemanticFieldInfoBuilder();
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getSemanticFieldFullPathInMapping() {
        return this.semanticFieldFullPathInMapping;
    }

    @Generated
    public String getSemanticInfoFullPathInDoc() {
        return this.semanticInfoFullPathInDoc;
    }

    @Generated
    public Boolean getChunkingEnabled() {
        return this.chunkingEnabled;
    }

    @Generated
    public List<Chunker> getChunkers() {
        return this.chunkers;
    }

    @Generated
    public List<String> getChunks() {
        return this.chunks;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setSemanticFieldFullPathInMapping(String semanticFieldFullPathInMapping) {
        this.semanticFieldFullPathInMapping = semanticFieldFullPathInMapping;
    }

    @Generated
    public void setSemanticInfoFullPathInDoc(String semanticInfoFullPathInDoc) {
        this.semanticInfoFullPathInDoc = semanticInfoFullPathInDoc;
    }

    @Generated
    public void setChunkingEnabled(Boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
    }

    @Generated
    public void setChunkers(List<Chunker> chunkers) {
        this.chunkers = chunkers;
    }

    @Generated
    public void setChunks(List<String> chunks) {
        this.chunks = chunks;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticFieldInfo)) {
            return false;
        }
        SemanticFieldInfo other = (SemanticFieldInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$chunkingEnabled = this.getChunkingEnabled();
        Boolean other$chunkingEnabled = other.getChunkingEnabled();
        if (this$chunkingEnabled == null ? other$chunkingEnabled != null : !((Object)this$chunkingEnabled).equals(other$chunkingEnabled)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$semanticFieldFullPathInMapping = this.getSemanticFieldFullPathInMapping();
        String other$semanticFieldFullPathInMapping = other.getSemanticFieldFullPathInMapping();
        if (this$semanticFieldFullPathInMapping == null ? other$semanticFieldFullPathInMapping != null : !this$semanticFieldFullPathInMapping.equals(other$semanticFieldFullPathInMapping)) {
            return false;
        }
        String this$semanticInfoFullPathInDoc = this.getSemanticInfoFullPathInDoc();
        String other$semanticInfoFullPathInDoc = other.getSemanticInfoFullPathInDoc();
        if (this$semanticInfoFullPathInDoc == null ? other$semanticInfoFullPathInDoc != null : !this$semanticInfoFullPathInDoc.equals(other$semanticInfoFullPathInDoc)) {
            return false;
        }
        List<Chunker> this$chunkers = this.getChunkers();
        List<Chunker> other$chunkers = other.getChunkers();
        if (this$chunkers == null ? other$chunkers != null : !((Object)this$chunkers).equals(other$chunkers)) {
            return false;
        }
        List<String> this$chunks = this.getChunks();
        List<String> other$chunks = other.getChunks();
        return !(this$chunks == null ? other$chunks != null : !((Object)this$chunks).equals(other$chunks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SemanticFieldInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $chunkingEnabled = this.getChunkingEnabled();
        result = result * 59 + ($chunkingEnabled == null ? 43 : ((Object)$chunkingEnabled).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $semanticFieldFullPathInMapping = this.getSemanticFieldFullPathInMapping();
        result = result * 59 + ($semanticFieldFullPathInMapping == null ? 43 : $semanticFieldFullPathInMapping.hashCode());
        String $semanticInfoFullPathInDoc = this.getSemanticInfoFullPathInDoc();
        result = result * 59 + ($semanticInfoFullPathInDoc == null ? 43 : $semanticInfoFullPathInDoc.hashCode());
        List<Chunker> $chunkers = this.getChunkers();
        result = result * 59 + ($chunkers == null ? 43 : ((Object)$chunkers).hashCode());
        List<String> $chunks = this.getChunks();
        result = result * 59 + ($chunks == null ? 43 : ((Object)$chunks).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SemanticFieldInfo(value=" + this.getValue() + ", modelId=" + this.getModelId() + ", semanticFieldFullPathInMapping=" + this.getSemanticFieldFullPathInMapping() + ", semanticInfoFullPathInDoc=" + this.getSemanticInfoFullPathInDoc() + ", chunkingEnabled=" + this.getChunkingEnabled() + ", chunkers=" + String.valueOf(this.getChunkers()) + ", chunks=" + String.valueOf(this.getChunks()) + ")";
    }

    @Generated
    public static class SemanticFieldInfoBuilder {
        @Generated
        private String value;
        @Generated
        private String modelId;
        @Generated
        private String semanticFieldFullPathInMapping;
        @Generated
        private String semanticInfoFullPathInDoc;
        @Generated
        private Boolean chunkingEnabled;
        @Generated
        private List<Chunker> chunkers;
        @Generated
        private List<String> chunks;

        @Generated
        SemanticFieldInfoBuilder() {
        }

        @Generated
        public SemanticFieldInfoBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder semanticFieldFullPathInMapping(String semanticFieldFullPathInMapping) {
            this.semanticFieldFullPathInMapping = semanticFieldFullPathInMapping;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder semanticInfoFullPathInDoc(String semanticInfoFullPathInDoc) {
            this.semanticInfoFullPathInDoc = semanticInfoFullPathInDoc;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder chunkingEnabled(Boolean chunkingEnabled) {
            this.chunkingEnabled = chunkingEnabled;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder chunkers(List<Chunker> chunkers) {
            this.chunkers = chunkers;
            return this;
        }

        @Generated
        public SemanticFieldInfoBuilder chunks(List<String> chunks) {
            this.chunks = chunks;
            return this;
        }

        @Generated
        public SemanticFieldInfo build() {
            return new SemanticFieldInfo(this.value, this.modelId, this.semanticFieldFullPathInMapping, this.semanticInfoFullPathInDoc, this.chunkingEnabled, this.chunkers, this.chunks);
        }

        @Generated
        public String toString() {
            return "SemanticFieldInfo.SemanticFieldInfoBuilder(value=" + this.value + ", modelId=" + this.modelId + ", semanticFieldFullPathInMapping=" + this.semanticFieldFullPathInMapping + ", semanticInfoFullPathInDoc=" + this.semanticInfoFullPathInDoc + ", chunkingEnabled=" + this.chunkingEnabled + ", chunkers=" + String.valueOf(this.chunkers) + ", chunks=" + String.valueOf(this.chunks) + ")";
        }
    }
}

