/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TargetIndexMappingService;
import org.opensearch.indexmanagement.transform.TransformIndexer;
import org.opensearch.indexmanagement.transform.exceptions.TransformIndexException;
import org.opensearch.indexmanagement.transform.settings.TransformSettings;
import org.opensearch.indexmanagement.transform.util.TransformContext;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u0013H\u0082@\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformIndexer;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/transport/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/client/Client;)V", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "createTargetIndex", "", "targetIndex", "", "targetFieldMappings", "", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "index", "", "transformTargetIndex", "docsToIndex", "", "Lorg/opensearch/action/DocWriteRequest;", "transformContext", "Lorg/opensearch/indexmanagement/transform/util/TransformContext;", "(Ljava/lang/String;Ljava/util/List;Lorg/opensearch/indexmanagement/transform/util/TransformContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class TransformIndexer {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy backoffPolicy;

    public TransformIndexer(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.clusterService = clusterService;
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_MILLIS().get(settings);
        Object object = TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_MILLIS(), TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_COUNT(), (arg_0, arg_1) -> TransformIndexer._init_$lambda$0(this, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    private final Object createTargetIndex(String var1_1, Map<String, ? extends Object> var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof createTargetIndex.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TransformIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransformIndexer.access$createTargetIndex(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.clusterService.state().getRoutingTable().hasIndex(targetIndex)) ** GOTO lbl30
                transformTargetIndexMapping = TargetIndexMappingService.INSTANCE.createTargetIndexMapping((Map<String, ? extends Object>)targetFieldMappings);
                request = new CreateIndexRequest(targetIndex).mapping(transformTargetIndexMapping);
                $continuation.L$0 = this;
                $continuation.L$1 = targetIndex;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.create(this.$request, it);
                    }
                }, $continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                targetIndex = (String)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if (!(response = (CreateIndexResponse)v0).isAcknowledged()) {
                    this.logger.error("Failed to create the target index " + targetIndex);
                    throw new TransformIndexException("Failed to create the target index", null, 2, null);
                }
lbl30:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object index(@NotNull String var1_1, @NotNull List<? extends DocWriteRequest<?>> var2_2, @NotNull TransformContext var3_3, @NotNull Continuation<? super Long> var4_4) {
        if (!(var4_4 instanceof index.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ TransformIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.index(null, null, null, (Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updatableDocsToIndex = new Ref.ObjectRef();
                updatableDocsToIndex.element = docsToIndex;
                indexTimeInMillis = new Ref.LongRef();
                nonRetryableFailures = new ArrayList<E>();
                if (!(((Collection)updatableDocsToIndex.element).isEmpty() == false)) ** GOTO lbl60
                targetIndex /* !! */  = ((DocWriteRequest)CollectionsKt.first((List)((List)updatableDocsToIndex.element))).index();
                this.logger.debug("Attempting to index " + ((List)updatableDocsToIndex.element).size() + " documents to " + targetIndex /* !! */ );
                $continuation.L$0 = this;
                $continuation.L$1 = updatableDocsToIndex;
                $continuation.L$2 = indexTimeInMillis;
                $continuation.L$3 = nonRetryableFailures;
                $continuation.label = 1;
                v0 = this.createTargetIndex((String)transformTargetIndex, transformContext.getTargetIndexDateFieldMappings(), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var12_7) goto lbl29
lbl28:
                // 1 sources

                return var12_7;
lbl29:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                nonRetryableFailures = (List)$continuation.L$3;
                indexTimeInMillis = (Ref.LongRef)$continuation.L$2;
                updatableDocsToIndex = (Ref.ObjectRef)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl39:
                // 2 sources

                v1 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"backoffPolicy");
                v2 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = indexTimeInMillis;
                $continuation.L$2 = nonRetryableFailures;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v3 = OpenSearchExtensionsKt.retry(v1, v2, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(updatableDocsToIndex, this, indexTimeInMillis, (List<BulkItemResponse>)nonRetryableFailures, null){
                    int label;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $updatableDocsToIndex;
                    final /* synthetic */ TransformIndexer this$0;
                    final /* synthetic */ Ref.LongRef $indexTimeInMillis;
                    final /* synthetic */ List<BulkItemResponse> $nonRetryableFailures;
                    {
                        this.$updatableDocsToIndex = $updatableDocsToIndex;
                        this.this$0 = $receiver;
                        this.$indexTimeInMillis = $indexTimeInMillis;
                        this.$nonRetryableFailures = $nonRetryableFailures;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                bulkRequest = new BulkRequest().add((Iterable)this.$updatableDocsToIndex.element);
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformIndexer.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var17_2) {
                                    return var17_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                bulkResponse = (BulkResponse)v0;
                                this.$indexTimeInMillis.element += bulkResponse.getTook().getMillis();
                                retryableFailures = new ArrayList<E>();
                                v1 = bulkResponse.getItems();
                                if (v1 == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v1;
                                $i$f$filter = false;
                                var7_9 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (void element$iv$iv : $this$filterTo$iv$iv) {
                                    it = element$iv$iv;
                                    $i$a$-filter-TransformIndexer$index$2$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$forEach$iv = (List)destination$iv$iv;
                                var6_8 = this.$nonRetryableFailures;
                                $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    failedResponse = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-TransformIndexer$index$2$2 = false;
                                    if (failedResponse.status() == RestStatus.TOO_MANY_REQUESTS) {
                                        Intrinsics.checkNotNull((Object)failedResponse);
                                        retryableFailures.add(failedResponse);
                                        continue;
                                    }
                                    Intrinsics.checkNotNull((Object)failedResponse);
                                    var6_8.add(failedResponse);
                                }
                                $this$forEach$iv = retryableFailures;
                                var6_8 = this.$updatableDocsToIndex;
                                var15_22 = this.$updatableDocsToIndex;
                                $i$f$map = false;
                                destination$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (BulkItemResponse)item$iv$iv;
                                    var16_23 = destination$iv$iv;
                                    $i$a$-map-TransformIndexer$index$2$3 = false;
                                    v2 = ((List)var6_8.element).get(failure.getItemId());
                                    Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type org.opensearch.action.index.IndexRequest");
                                    var16_23.add((IndexRequest)v2);
                                }
                                var15_22.element = (List)destination$iv$iv;
                                if (((Collection)this.$updatableDocsToIndex.element).isEmpty() == false) {
                                    v3 = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)retryableFailures)).getFailure().getCause());
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"convertToOpenSearchException(...)");
                                    throw (Throwable)v3;
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v3 != var12_7) goto lbl51
lbl50:
                // 1 sources

                return var12_7;
lbl51:
                // 1 sources

                ** GOTO lbl60
            }
            case 2: {
                nonRetryableFailures = (List)$continuation.L$2;
                indexTimeInMillis = (Ref.LongRef)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl60:
                    // 3 sources

                    if (((Collection)nonRetryableFailures).isEmpty() == false) {
                        this.logger.error("Failed to index " + nonRetryableFailures.size() + " documents");
                        targetIndex /* !! */  = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)nonRetryableFailures)).getFailure().getCause());
                        Intrinsics.checkNotNullExpressionValue((Object)targetIndex /* !! */ , (String)"convertToOpenSearchException(...)");
                        throw (Throwable)targetIndex /* !! */ ;
                    }
                    return Boxing.boxLong((long)indexTimeInMillis.element);
                }
                catch (TransformIndexException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    unwrappedException = (Exception)v4;
                    throw new TransformIndexException("Failed to index the documents", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformIndexException("Failed to index the documents - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformIndexException("Failed to index the documents", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void _init_$lambda$0(TransformIndexer this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)count);
        this$0.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    public static final /* synthetic */ Object access$createTargetIndex(TransformIndexer $this, String targetIndex, Map targetFieldMappings, Continuation $completion) {
        return $this.createTargetIndex(targetIndex, targetFieldMappings, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Client access$getClient$p(TransformIndexer $this) {
        return $this.client;
    }
}

