/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.ProfileResult;
import org.opensearch.search.profile.query.AbstractQueryProfileTree;
import org.opensearch.search.profile.query.ConcurrentQueryProfileBreakdown;
import org.opensearch.search.profile.query.QueryTimingType;

public class ConcurrentQueryProfileTree
extends AbstractQueryProfileTree {
    @Override
    protected ContextualProfileBreakdown<QueryTimingType> createProfileBreakdown() {
        return new ConcurrentQueryProfileBreakdown();
    }

    @Override
    protected ProfileResult createProfileResult(String type, String description, ContextualProfileBreakdown<QueryTimingType> breakdown, List<ProfileResult> childrenProfileResults) {
        assert (breakdown instanceof ConcurrentQueryProfileBreakdown);
        ConcurrentQueryProfileBreakdown concurrentBreakdown = (ConcurrentQueryProfileBreakdown)breakdown;
        return new ProfileResult(type, description, concurrentBreakdown.toBreakdownMap(), concurrentBreakdown.toDebugMap(), concurrentBreakdown.toNodeTime(), childrenProfileResults, concurrentBreakdown.getMaxSliceNodeTime(), concurrentBreakdown.getMinSliceNodeTime(), concurrentBreakdown.getAvgSliceNodeTime());
    }

    @Override
    public List<ProfileResult> getTree() {
        for (Integer root : this.roots) {
            ContextualProfileBreakdown parentBreakdown = (ContextualProfileBreakdown)this.breakdowns.get(root);
            assert (parentBreakdown instanceof ConcurrentQueryProfileBreakdown);
            Map<Collector, List<LeafReaderContext>> parentCollectorToLeaves = ((ConcurrentQueryProfileBreakdown)parentBreakdown).getSliceCollectorsToLeaves();
            this.updateCollectorToLeavesForChildBreakdowns(root, parentCollectorToLeaves);
        }
        return super.getTree();
    }

    private void updateCollectorToLeavesForChildBreakdowns(Integer parentToken, Map<Collector, List<LeafReaderContext>> collectorToLeaves) {
        List children = (List)this.tree.get(parentToken);
        if (children != null) {
            for (Integer currentChild : children) {
                ContextualProfileBreakdown currentChildBreakdown = (ContextualProfileBreakdown)this.breakdowns.get(currentChild);
                currentChildBreakdown.associateCollectorsToLeaves(collectorToLeaves);
                this.updateCollectorToLeavesForChildBreakdowns(currentChild, collectorToLeaves);
            }
        }
    }
}

