/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.opensearch.Version;
import org.opensearch.index.mapper.MetadataFieldMapper;
import org.opensearch.index.mapper.StringFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SearchLookup;

public class NestedPathFieldMapper
extends MetadataFieldMapper {
    public static final String LEGACY_NAME = "_type";
    public static final String NAME = "_nested_path";
    private static final NestedPathFieldMapper LEGACY_INSTANCE = new NestedPathFieldMapper("_type");
    private static final NestedPathFieldMapper INSTANCE = new NestedPathFieldMapper("_nested_path");
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.indexVersionCreated().before(Version.V_2_0_0) ? LEGACY_INSTANCE : INSTANCE);

    private NestedPathFieldMapper(String name) {
        super(new NestedPathFieldType(name));
    }

    public static String name(Version version) {
        if (version.before(Version.V_2_0_0)) {
            return LEGACY_NAME;
        }
        return NAME;
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    public static Field field(Version version, String path) {
        return new Field(NestedPathFieldMapper.name(version), (CharSequence)path, (IndexableFieldType)Defaults.FIELD_TYPE);
    }

    public static Query filter(Version version, String path) {
        return new TermQuery(new Term(NestedPathFieldMapper.name(version), new BytesRef((CharSequence)path)));
    }

    public static final class NestedPathFieldType
    extends StringFieldType {
        private NestedPathFieldType(String name) {
            super(name, true, false, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return NestedPathFieldMapper.NAME;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException("Cannot run exists() query against the nested field path");
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

