/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.options;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.openide.filesystems.FileObject;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public abstract class HintsSettings {
    private static final String ENABLED_KEY = "enabled";
    private static final String OLD_SEVERITY_KEY = "severity";
    private static final String NEW_SEVERITY_KEY = "hintSeverity";
    private static final String DEFAULT_PROFILE = "default";
    private static final String PREFERENCES_LOCATION = "org/netbeans/modules/java/hints";
    private static final HintsSettings GLOBAL_SETTINGS = new PreferencesBasedHintsSettings(NbPreferences.root().node("org/netbeans/modules/java/hints").node("default"), true, null);

    public abstract boolean isEnabled(HintMetadata var1);

    public abstract void setEnabled(HintMetadata var1, boolean var2);

    public abstract Preferences getHintPreferences(HintMetadata var1);

    public abstract Severity getSeverity(HintMetadata var1);

    public abstract void setSeverity(HintMetadata var1, Severity var2);

    public static HintsSettings createPreferencesBasedHintsSettings(Preferences preferences, boolean useDefaultEnabled, Severity overrideSeverity) {
        return new PreferencesBasedHintsSettings(new HintPreferencesCache(preferences), useDefaultEnabled, overrideSeverity);
    }

    public static HintsSettings getSettingsFor(FileObject file) {
        return HintsSettings.createPreferencesBasedHintsSettings(FileHintPreferences.getFilePreferences((FileObject)file, (String)"text/x-java"), true, null);
    }

    public static HintsSettings getGlobalSettings() {
        return GLOBAL_SETTINGS;
    }

    private static final class PreferencesBasedHintsSettings
    extends HintsSettings {
        private final Preferences preferences;
        private final boolean useDefaultEnabled;
        private final Severity overrideSeverity;

        public PreferencesBasedHintsSettings(Preferences preferences, boolean useDefaultEnabled, Severity overrideSeverity) {
            Parameters.notNull((CharSequence)"preferences", (Object)preferences);
            this.preferences = preferences;
            this.useDefaultEnabled = useDefaultEnabled;
            this.overrideSeverity = overrideSeverity;
        }

        @Override
        public boolean isEnabled(HintMetadata hint) {
            return this.getHintPreferences(hint).getBoolean(HintsSettings.ENABLED_KEY, this.useDefaultEnabled && hint.enabled);
        }

        @Override
        public void setEnabled(HintMetadata hint, boolean value) {
            this.getHintPreferences(hint).putBoolean(HintsSettings.ENABLED_KEY, value);
        }

        @Override
        public Preferences getHintPreferences(HintMetadata hint) {
            return this.preferences.node(hint.id);
        }

        @Override
        public Severity getSeverity(HintMetadata hint) {
            Preferences prefs = this.getHintPreferences(hint);
            String s = prefs.get(HintsSettings.NEW_SEVERITY_KEY, null);
            if (s != null) {
                return Severity.valueOf((String)s);
            }
            s = prefs.get(HintsSettings.OLD_SEVERITY_KEY, null);
            if (s == null) {
                return this.overrideSeverity != null ? this.overrideSeverity : (hint != null ? hint.severity : null);
            }
            return switch (s) {
                case "ERROR" -> Severity.ERROR;
                case "WARNING" -> Severity.VERIFIER;
                case "CURRENT_LINE_WARNING" -> Severity.HINT;
                default -> this.overrideSeverity != null ? this.overrideSeverity : (hint != null ? hint.severity : null);
            };
        }

        @Override
        public void setSeverity(HintMetadata hint, Severity severity) {
            this.getHintPreferences(hint).put(HintsSettings.NEW_SEVERITY_KEY, severity.name());
        }
    }

    private static final class HintPreferencesCache
    extends Preferences {
        private static final String MASKED_NULL = new String("MASKED_NULL");
        private final Preferences delegate;
        private final Map<String, String> cache;
        private final Map<String, HintPreferencesCache> nodes;
        private final Preferences parent;

        public HintPreferencesCache(Preferences delegate) {
            this(null, delegate);
        }

        public HintPreferencesCache(Preferences parent, Preferences delegate) {
            this.parent = parent;
            this.delegate = delegate;
            this.cache = new HashMap<String, String>();
            this.nodes = new HashMap<String, HintPreferencesCache>();
        }

        private static String maskNull(String value) {
            return value == null ? MASKED_NULL : value;
        }

        @Override
        public Preferences node(String pathName) {
            return this.nodes.computeIfAbsent(pathName, pn -> new HintPreferencesCache(this, this.delegate.node((String)pn)));
        }

        @Override
        public Preferences parent() {
            return this.parent != null ? this.parent : this.delegate.parent();
        }

        @Override
        public String get(String key, String def) {
            String ret = this.cache.computeIfAbsent(key, k -> {
                String val = this.delegate.get((String)k, def);
                return HintPreferencesCache.maskNull(val);
            });
            return ret == MASKED_NULL ? def : ret;
        }

        @Override
        public boolean getBoolean(String key, boolean def) {
            String ret = this.cache.computeIfAbsent(key, k -> Boolean.toString(this.delegate.getBoolean((String)k, def)));
            return ret == MASKED_NULL ? def : Boolean.parseBoolean(ret);
        }

        @Override
        public void put(String key, String value) {
            this.cache.put(key, HintPreferencesCache.maskNull(value));
            this.delegate.put(key, value);
        }

        @Override
        public void putBoolean(String key, boolean value) {
            this.cache.put(key, Boolean.toString(value));
            this.delegate.putBoolean(key, value);
        }

        @Override
        public void remove(String key) {
            this.delegate.remove(key);
            this.cache.remove(key);
        }

        @Override
        public void clear() throws BackingStoreException {
            this.cache.clear();
            this.nodes.clear();
            this.delegate.clear();
        }

        @Override
        public int getInt(String key, int def) {
            return this.delegate.getInt(key, def);
        }

        @Override
        public void putLong(String key, long value) {
            this.delegate.putLong(key, value);
        }

        @Override
        public long getLong(String key, long def) {
            return this.delegate.getLong(key, def);
        }

        @Override
        public void putFloat(String key, float value) {
            this.delegate.putFloat(key, value);
        }

        @Override
        public float getFloat(String key, float def) {
            return this.delegate.getFloat(key, def);
        }

        @Override
        public byte[] getByteArray(String key, byte[] def) {
            return this.delegate.getByteArray(key, def);
        }

        @Override
        public void putDouble(String key, double value) {
            this.delegate.putDouble(key, value);
        }

        @Override
        public double getDouble(String key, double def) {
            return this.delegate.getDouble(key, def);
        }

        @Override
        public void putInt(String key, int value) {
            this.delegate.putInt(key, value);
        }

        @Override
        public void putByteArray(String key, byte[] value) {
            this.delegate.putByteArray(key, value);
        }

        @Override
        public String[] keys() throws BackingStoreException {
            return this.delegate.keys();
        }

        @Override
        public String[] childrenNames() throws BackingStoreException {
            return this.delegate.childrenNames();
        }

        @Override
        public boolean nodeExists(String pathName) throws BackingStoreException {
            return this.delegate.nodeExists(pathName);
        }

        @Override
        public void removeNode() throws BackingStoreException {
            this.delegate.removeNode();
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public String absolutePath() {
            return this.delegate.absolutePath();
        }

        @Override
        public boolean isUserNode() {
            return this.delegate.isUserNode();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void flush() throws BackingStoreException {
            this.delegate.flush();
        }

        @Override
        public void sync() throws BackingStoreException {
            this.delegate.sync();
        }

        @Override
        public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
            this.delegate.addPreferenceChangeListener(pcl);
        }

        @Override
        public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
            this.delegate.removePreferenceChangeListener(pcl);
        }

        @Override
        public void addNodeChangeListener(NodeChangeListener ncl) {
            this.delegate.addNodeChangeListener(ncl);
        }

        @Override
        public void removeNodeChangeListener(NodeChangeListener ncl) {
            this.delegate.removeNodeChangeListener(ncl);
        }

        @Override
        public void exportNode(OutputStream os) throws IOException, BackingStoreException {
            this.delegate.exportNode(os);
        }

        @Override
        public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
            this.delegate.exportSubtree(os);
        }
    }

    public static class GlobalSettingsProvider
    implements FileHintPreferences.GlobalHintPreferencesProvider {
        public Preferences getGlobalPreferences() {
            return NbPreferences.root().node(HintsSettings.PREFERENCES_LOCATION).node(HintsSettings.DEFAULT_PROFILE);
        }
    }
}

