/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.keymanagement.model.ChangeKeyCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeKeyCompartmentRequest
extends BmcRequest<ChangeKeyCompartmentDetails> {
    private String keyId;
    private ChangeKeyCompartmentDetails changeKeyCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getKeyId() {
        return this.keyId;
    }

    public ChangeKeyCompartmentDetails getChangeKeyCompartmentDetails() {
        return this.changeKeyCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeKeyCompartmentDetails getBody$() {
        return this.changeKeyCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).changeKeyCompartmentDetails(this.changeKeyCompartmentDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",keyId=").append(String.valueOf(this.keyId));
        sb.append(",changeKeyCompartmentDetails=").append(String.valueOf((Object)this.changeKeyCompartmentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeKeyCompartmentRequest)) {
            return false;
        }
        ChangeKeyCompartmentRequest other = (ChangeKeyCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.keyId, other.keyId) && Objects.equals((Object)this.changeKeyCompartmentDetails, (Object)other.changeKeyCompartmentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.keyId == null ? 43 : this.keyId.hashCode());
        result = result * 59 + (this.changeKeyCompartmentDetails == null ? 43 : this.changeKeyCompartmentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeKeyCompartmentRequest, ChangeKeyCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String keyId = null;
        private ChangeKeyCompartmentDetails changeKeyCompartmentDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder changeKeyCompartmentDetails(ChangeKeyCompartmentDetails changeKeyCompartmentDetails) {
            this.changeKeyCompartmentDetails = changeKeyCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeKeyCompartmentRequest o) {
            this.keyId(o.getKeyId());
            this.changeKeyCompartmentDetails(o.getChangeKeyCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeKeyCompartmentRequest build() {
            ChangeKeyCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeKeyCompartmentDetails body) {
            this.changeKeyCompartmentDetails(body);
            return this;
        }

        public ChangeKeyCompartmentRequest buildWithoutInvocationCallback() {
            ChangeKeyCompartmentRequest request = new ChangeKeyCompartmentRequest();
            request.keyId = this.keyId;
            request.changeKeyCompartmentDetails = this.changeKeyCompartmentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

