/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.artifacts;

import com.oracle.bmc.artifacts.Artifacts;
import com.oracle.bmc.artifacts.model.ContainerImage;
import com.oracle.bmc.artifacts.model.ContainerImageSignature;
import com.oracle.bmc.artifacts.model.ContainerRepository;
import com.oracle.bmc.artifacts.model.GenericArtifact;
import com.oracle.bmc.artifacts.model.Repository;
import com.oracle.bmc.artifacts.requests.GetContainerImageRequest;
import com.oracle.bmc.artifacts.requests.GetContainerImageSignatureRequest;
import com.oracle.bmc.artifacts.requests.GetContainerRepositoryRequest;
import com.oracle.bmc.artifacts.requests.GetGenericArtifactRequest;
import com.oracle.bmc.artifacts.requests.GetRepositoryRequest;
import com.oracle.bmc.artifacts.responses.GetContainerImageResponse;
import com.oracle.bmc.artifacts.responses.GetContainerImageSignatureResponse;
import com.oracle.bmc.artifacts.responses.GetContainerRepositoryResponse;
import com.oracle.bmc.artifacts.responses.GetGenericArtifactResponse;
import com.oracle.bmc.artifacts.responses.GetRepositoryResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ArtifactsWaiters {
    private final ExecutorService executorService;
    private final Artifacts client;

    public ArtifactsWaiters(ExecutorService executorService, Artifacts client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, ContainerImage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, ContainerImage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(GetContainerImageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerImage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerImage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerImageRequest, GetContainerImageResponse> forContainerImage(BmcGenericWaiter waiter, GetContainerImageRequest request, ContainerImage.LifecycleState ... targetStates) {
        final HashSet<ContainerImage.LifecycleState> targetStatesSet = new HashSet<ContainerImage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerImageRequest, GetContainerImageResponse>(){

            @Override
            public GetContainerImageResponse apply(GetContainerImageRequest request) {
                return ArtifactsWaiters.this.client.getContainerImage(request);
            }
        }, (Predicate)new Predicate<GetContainerImageResponse>(){

            @Override
            public boolean test(GetContainerImageResponse response) {
                return targetStatesSet.contains((Object)response.getContainerImage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerImage.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse> forContainerImageSignature(GetContainerImageSignatureRequest request, ContainerImageSignature.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerImageSignature(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse> forContainerImageSignature(GetContainerImageSignatureRequest request, ContainerImageSignature.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerImageSignature(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse> forContainerImageSignature(GetContainerImageSignatureRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerImageSignature.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerImageSignature(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse> forContainerImageSignature(BmcGenericWaiter waiter, GetContainerImageSignatureRequest request, ContainerImageSignature.LifecycleState ... targetStates) {
        final HashSet<ContainerImageSignature.LifecycleState> targetStatesSet = new HashSet<ContainerImageSignature.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerImageSignatureRequest, GetContainerImageSignatureResponse>(){

            @Override
            public GetContainerImageSignatureResponse apply(GetContainerImageSignatureRequest request) {
                return ArtifactsWaiters.this.client.getContainerImageSignature(request);
            }
        }, (Predicate)new Predicate<GetContainerImageSignatureResponse>(){

            @Override
            public boolean test(GetContainerImageSignatureResponse response) {
                return targetStatesSet.contains((Object)response.getContainerImageSignature().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerImageSignature.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, ContainerRepository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, ContainerRepository.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(GetContainerRepositoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ContainerRepository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forContainerRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerRepositoryRequest, GetContainerRepositoryResponse> forContainerRepository(BmcGenericWaiter waiter, GetContainerRepositoryRequest request, ContainerRepository.LifecycleState ... targetStates) {
        final HashSet<ContainerRepository.LifecycleState> targetStatesSet = new HashSet<ContainerRepository.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerRepositoryRequest, GetContainerRepositoryResponse>(){

            @Override
            public GetContainerRepositoryResponse apply(GetContainerRepositoryRequest request) {
                return ArtifactsWaiters.this.client.getContainerRepository(request);
            }
        }, (Predicate)new Predicate<GetContainerRepositoryResponse>(){

            @Override
            public boolean test(GetContainerRepositoryResponse response) {
                return targetStatesSet.contains((Object)response.getContainerRepository().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ContainerRepository.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetGenericArtifactRequest, GetGenericArtifactResponse> forGenericArtifact(GetGenericArtifactRequest request, GenericArtifact.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGenericArtifact(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGenericArtifactRequest, GetGenericArtifactResponse> forGenericArtifact(GetGenericArtifactRequest request, GenericArtifact.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGenericArtifact(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGenericArtifactRequest, GetGenericArtifactResponse> forGenericArtifact(GetGenericArtifactRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, GenericArtifact.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forGenericArtifact(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGenericArtifactRequest, GetGenericArtifactResponse> forGenericArtifact(BmcGenericWaiter waiter, GetGenericArtifactRequest request, GenericArtifact.LifecycleState ... targetStates) {
        final HashSet<GenericArtifact.LifecycleState> targetStatesSet = new HashSet<GenericArtifact.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetGenericArtifactRequest, GetGenericArtifactResponse>(){

            @Override
            public GetGenericArtifactResponse apply(GetGenericArtifactRequest request) {
                return ArtifactsWaiters.this.client.getGenericArtifact(request);
            }
        }, (Predicate)new Predicate<GetGenericArtifactResponse>(){

            @Override
            public boolean test(GetGenericArtifactResponse response) {
                return targetStatesSet.contains((Object)response.getGenericArtifact().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)GenericArtifact.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, Repository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRepository(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, Repository.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Repository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(BmcGenericWaiter waiter, GetRepositoryRequest request, Repository.LifecycleState ... targetStates) {
        final HashSet<Repository.LifecycleState> targetStatesSet = new HashSet<Repository.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetRepositoryRequest, GetRepositoryResponse>(){

            @Override
            public GetRepositoryResponse apply(GetRepositoryRequest request) {
                return ArtifactsWaiters.this.client.getRepository(request);
            }
        }, (Predicate)new Predicate<GetRepositoryResponse>(){

            @Override
            public boolean test(GetRepositoryResponse response) {
                return targetStatesSet.contains((Object)response.getRepository().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Repository.LifecycleState.Deleted)), (Object)request);
    }
}

