/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.libraries.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.libraries.DefaultLibraryImplementation;
import org.netbeans.modules.project.libraries.LibrariesModule;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.NamedLibraryImplementation;
import org.netbeans.spi.project.libraries.support.ForwardingLibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class LibrariesSupport {
    private static final Logger LOG = Logger.getLogger(LibrariesSupport.class.getName());

    private LibrariesSupport() {
    }

    @NonNull
    public static LibraryImplementation3 createLibraryImplementation3(@NonNull String libraryType, String ... volumeTypes) {
        return new DefaultLibraryImplementation(libraryType, volumeTypes);
    }

    public static LibraryImplementation createLibraryImplementation(String libraryType, String[] volumeTypes) {
        return LibrariesSupport.createLibraryImplementation3(libraryType, volumeTypes);
    }

    public static LibraryTypeProvider getLibraryTypeProvider(String libraryType) {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProvider(libraryType);
    }

    public static LibraryTypeProvider[] getLibraryTypeProviders() {
        return LibraryTypeRegistry.getDefault().getLibraryTypeProviders();
    }

    public static URI convertFilePathToURI(@NonNull String path) {
        Parameters.notNull((CharSequence)"path", (Object)path);
        try {
            File f = new File(path);
            if (f.isAbsolute()) {
                return BaseUtilities.toURI((File)f);
            }
            return new URI(null, null, path.replace('\\', '/'), null);
        }
        catch (URISyntaxException ex) {
            IllegalArgumentException y = new IllegalArgumentException();
            y.initCause(ex);
            throw y;
        }
    }

    public static String convertURIToFilePath(URI uri) {
        if (uri.isAbsolute()) {
            return BaseUtilities.toFile((URI)uri).getPath();
        }
        String path = uri.getPath();
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace('/', File.separatorChar);
    }

    @NonNull
    public static List<URL> convertURIsToURLs(@NonNull List<? extends URI> uris, @NonNull ConversionMode conversionMode) {
        ArrayList<URL> content = new ArrayList<URL>();
        block7: for (URI uRI : uris) {
            try {
                content.add(uRI.toURL());
            }
            catch (MalformedURLException ex) {
                switch (conversionMode.ordinal()) {
                    case 2: {
                        throw new IllegalArgumentException(uRI.toString());
                    }
                    case 1: {
                        LOG.log(Level.WARNING, "Cannot convert URI: {0} to URL.", uRI);
                        continue block7;
                    }
                    case 0: {
                        continue block7;
                    }
                }
                throw new IllegalStateException(conversionMode.name());
            }
        }
        return content;
    }

    @NonNull
    public static List<URI> convertURLsToURIs(@NonNull List<URL> urls, @NonNull ConversionMode conversionMode) {
        ArrayList<URI> content = new ArrayList<URI>();
        block7: for (URL url : urls) {
            try {
                URI uri = new URI(url.toExternalForm());
                content.add(uri);
            }
            catch (URISyntaxException e) {
                switch (conversionMode.ordinal()) {
                    case 2: {
                        throw new IllegalArgumentException(url.toString());
                    }
                    case 1: {
                        LOG.log(Level.WARNING, "Cannot convert URL: {0} to URI.", url);
                        continue block7;
                    }
                    case 0: {
                        continue block7;
                    }
                }
                throw new IllegalStateException(conversionMode.name());
            }
        }
        return content;
    }

    public static FileObject resolveLibraryEntryFileObject(URL libraryLocation, URI libraryEntry) {
        URI u = LibrariesSupport.resolveLibraryEntryURI(libraryLocation, libraryEntry);
        try {
            return URLMapper.findFileObject((URL)u.toURL());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static URI resolveLibraryEntryURI(URL libraryLocation, URI libraryEntry) {
        URI resolved;
        Parameters.notNull((CharSequence)"libraryEntry", (Object)libraryEntry);
        if (libraryEntry.isAbsolute()) {
            return libraryEntry;
        }
        if (libraryLocation == null) {
            throw new IllegalArgumentException("cannot resolve relative URL without library location");
        }
        if (!"file".equals(libraryLocation.getProtocol())) {
            throw new IllegalArgumentException("not file: protocol - " + libraryLocation.toExternalForm());
        }
        if (!libraryLocation.getPath().endsWith(".properties")) {
            throw new IllegalArgumentException("library location must be a file - " + libraryLocation.toExternalForm());
        }
        try {
            resolved = libraryLocation.toURI().resolve(libraryEntry);
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
        if (libraryEntry.getPath().contains("!/")) {
            return URI.create("jar:" + resolved);
        }
        return resolved;
    }

    public static URI getArchiveFile(URI uri) {
        String u = uri.toString();
        int index = u.indexOf("!/");
        if (index != -1) {
            try {
                return new URI(u.substring(u.startsWith("jar:") ? 4 : 0, index));
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public static URI getArchiveRoot(URI uri) {
        assert (!uri.toString().contains("!/")) : uri;
        try {
            return new URI((uri.isAbsolute() ? "jar:" : "") + uri.toString() + "!/");
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @NonNull
    public static LibraryStorageArea getLibraryStorageArea(@NonNull LibraryManager manager) {
        Parameters.notNull((CharSequence)"manager", (Object)manager);
        return LibraryAccessor.getInstance().getArea(manager);
    }

    @NonNull
    public static String getLocalizedName(@NonNull LibraryImplementation impl) {
        String proxiedName;
        Object obj;
        Parameters.notNull((CharSequence)"impl", (Object)impl);
        if (LibrariesSupport.supportsDisplayName(impl) && ((NamedLibraryImplementation)impl).getDisplayName() != null) {
            return ((NamedLibraryImplementation)impl).getDisplayName();
        }
        FileObject src = LibrariesModule.getFile(impl);
        if (src != null && (obj = src.getAttribute("displayName")) instanceof String) {
            return (String)obj;
        }
        if (impl instanceof ForwardingLibraryImplementation && (proxiedName = LibrariesSupport.getLocalizedName(((ForwardingLibraryImplementation)impl).getDelegate())) != null) {
            return proxiedName;
        }
        return LibrariesSupport.getLocalizedString(impl.getLocalizingBundle(), impl.getName());
    }

    public static boolean supportsDisplayName(@NonNull LibraryImplementation impl) {
        assert (impl != null);
        if (impl instanceof ForwardingLibraryImplementation) {
            return LibrariesSupport.supportsDisplayName(((ForwardingLibraryImplementation)impl).getDelegate());
        }
        return impl instanceof NamedLibraryImplementation;
    }

    @CheckForNull
    public static String getDisplayName(@NonNull LibraryImplementation impl) {
        return LibrariesSupport.supportsDisplayName(impl) ? ((NamedLibraryImplementation)impl).getDisplayName() : null;
    }

    public static boolean setDisplayName(@NonNull LibraryImplementation impl, @NullAllowed String name) {
        NamedLibraryImplementation nimpl;
        if (LibrariesSupport.supportsDisplayName(impl) && !BaseUtilities.compareObjects((Object)(nimpl = (NamedLibraryImplementation)impl).getDisplayName(), (Object)name)) {
            nimpl.setDisplayName(name);
            return true;
        }
        return false;
    }

    public static boolean supportsProperties(@NonNull LibraryImplementation impl) {
        assert (impl != null);
        if (impl instanceof ForwardingLibraryImplementation) {
            return LibrariesSupport.supportsProperties(((ForwardingLibraryImplementation)impl).getDelegate());
        }
        return impl instanceof LibraryImplementation3;
    }

    @NonNull
    public static Map<String, String> getProperties(@NonNull LibraryImplementation impl) {
        return LibrariesSupport.supportsProperties(impl) ? ((LibraryImplementation3)impl).getProperties() : Collections.emptyMap();
    }

    public static boolean setProperties(@NonNull LibraryImplementation impl, @NonNull Map<String, String> props) {
        LibraryImplementation3 impl3;
        if (LibrariesSupport.supportsProperties(impl) && !BaseUtilities.compareObjects((impl3 = (LibraryImplementation3)impl).getProperties(), props)) {
            impl3.setProperties(props);
            return true;
        }
        return false;
    }

    public static boolean supportsURIContent(@NonNull LibraryImplementation impl) {
        if (impl instanceof ForwardingLibraryImplementation) {
            return LibrariesSupport.supportsURIContent(((ForwardingLibraryImplementation)impl).getDelegate());
        }
        return impl instanceof LibraryImplementation2;
    }

    @NonNull
    public static List<URI> getURIContent(@NonNull LibraryImplementation impl, @NonNull String volumeType, @NonNull ConversionMode conversionMode) {
        return LibrariesSupport.supportsURIContent(impl) ? ((LibraryImplementation2)impl).getURIContent(volumeType) : LibrariesSupport.convertURLsToURIs(impl.getContent(volumeType), conversionMode);
    }

    public static boolean setURIContent(@NonNull LibraryImplementation impl, @NonNull String volumeType, @NonNull List<URI> path, @NonNull ConversionMode conversionMode) {
        if (LibrariesSupport.supportsURIContent(impl)) {
            LibraryImplementation2 impl2 = (LibraryImplementation2)impl;
            if (!BaseUtilities.compareObjects(impl2.getURIContent(volumeType), path)) {
                impl2.setURIContent(volumeType, path);
                return true;
            }
        } else {
            impl.setContent(volumeType, LibrariesSupport.convertURIsToURLs(path, conversionMode));
            return true;
        }
        return false;
    }

    @NonNull
    public static LibraryImplementation getLibraryImplementation(@NonNull Library library) {
        Parameters.notNull((CharSequence)"library", (Object)library);
        return LibraryAccessor.getInstance().getLibraryImplementation(library);
    }

    private static String getLocalizedString(@NullAllowed String bundleResourceName, @NullAllowed String key) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (bundleResourceName == null) {
            return key;
        }
        try {
            bundle = NbBundle.getBundle((String)bundleResourceName);
        }
        catch (MissingResourceException mre) {
            LOG.log(Level.INFO, "Wrong resource bundle", mre);
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }

    public static enum ConversionMode {
        SKIP,
        WARN,
        FAIL;

    }
}

