/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.sql.Blob;
import java.sql.Clob;
import java.util.regex.Pattern;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.netbeans.modules.db.dataview.util.LobHelper;

public class SuperPatternFilter
extends RowFilter<TableModel, Integer> {
    Pattern pattern;
    String filterStr = "";
    MODE mode;
    private static final String UNKOWN_MODE = "unknown mode";
    private final int col;

    public SuperPatternFilter(int col) {
        this.col = col;
        this.setFilterStr(null, MODE.LITERAL_FIND);
    }

    public boolean isFilterSetTo(String rack, MODE matchMode) {
        return this.filterStr.equals(rack) && this.mode == matchMode;
    }

    public void setFilterStr(String filterStr, MODE mode) {
        if (filterStr == null || this.filterStr.equals(filterStr) && this.mode == mode) {
            return;
        }
        this.filterStr = filterStr;
        this.mode = mode;
        switch (mode.ordinal()) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                String filterStr2 = filterStr == null || filterStr.length() == 0 ? ".*" : filterStr;
                this.pattern = Pattern.compile(filterStr2, 0);
                break;
            }
            default: {
                throw new RuntimeException(UNKOWN_MODE);
            }
        }
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        return this.testValue(entry.getStringValue(this.col));
    }

    protected boolean testValue(Object value) {
        if (value == null) {
            return false;
        }
        String valueStr = value instanceof Blob ? LobHelper.blobToString((Blob)value) : (value instanceof Clob ? LobHelper.clobToString((Clob)value) : value.toString());
        switch (this.mode.ordinal()) {
            case 0: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return valueStr.toUpperCase().contains(this.filterStr.toUpperCase());
            }
            case 2: {
                if (this.filterStr == null || this.filterStr.length() == 0) {
                    return true;
                }
                return this.filterStr.equals(valueStr);
            }
            case 1: {
                return this.pattern.matcher(valueStr).find();
            }
            case 3: {
                return this.pattern.matcher(valueStr).matches();
            }
        }
        throw new RuntimeException(UNKOWN_MODE);
    }

    public static enum MODE {
        LITERAL_FIND,
        REGEX_FIND,
        LITERAL_MATCH,
        REGEX_MATCH;

    }
}

