/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class OptionsExportModel {
    private static final Logger LOGGER = Logger.getLogger(OptionsExportModel.class.getName());
    private static final String OPTIONS_EXPORT_FOLDER = "OptionsExport";
    private static final String GROUP_PATTERN = "([^/]*)";
    private static final List<String> ENABLED_CATEGORIES = Collections.singletonList("Formatting");
    private static OptionsExportModel SINGLETON = new OptionsExportModel();
    private final File targetUserdir = Places.getUserDirectory();
    private File source;
    private List<Category> categories;
    List<String> relativePaths;
    private Set<String> includePatterns;
    private Set<String> excludePatterns;
    private EditableProperties currentProperties;
    private static final List<String> IGNORED_FOLDERS = Arrays.asList("var/cache");

    private OptionsExportModel() {
    }

    static OptionsExportModel get() {
        return SINGLETON;
    }

    void doImport(File source) throws IOException {
        LOGGER.log(Level.FINE, "Copying from: {0}\n    to: {1}", new Object[]{source, this.targetUserdir});
        this.source = source;
        this.relativePaths = null;
        try (ZipFile zipFile = new ZipFile(source);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory()) continue;
                this.copyFile(zipEntry.getName());
            }
        }
    }

    void clean() throws IOException {
        this.source = null;
        this.relativePaths = null;
        for (String relativePath : this.getRelativePaths()) {
            this.clearFile(relativePath);
        }
    }

    private List<Category> getCategories() {
        if (this.categories == null) {
            this.loadCategories();
        }
        return this.categories;
    }

    static Set<String> parsePattern(String pattern) {
        HashSet<String> patterns = new HashSet<String>();
        if (pattern.contains("#")) {
            StringBuilder partPattern = new StringBuilder();
            ParserState state = ParserState.START;
            int blockLevel = 0;
            block6: for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                switch (state.ordinal()) {
                    case 0: {
                        if (c == '#') {
                            state = ParserState.IN_KEY_PATTERN;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '(') {
                            state = ParserState.IN_BLOCK;
                            ++blockLevel;
                            partPattern.append(c);
                            continue block6;
                        }
                        if (c == '|') {
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case 1: {
                        if (c == '#') {
                            state = ParserState.AFTER_KEY_PATTERN;
                            continue block6;
                        }
                        partPattern.append(c);
                        continue block6;
                    }
                    case 2: {
                        if (c == '|') {
                            state = ParserState.START;
                            patterns.add(partPattern.toString());
                            partPattern = new StringBuilder();
                            continue block6;
                        }
                        assert (false) : "Wrong OptionsExport pattern " + pattern + ". Only format like filePattern1#keyPattern#|filePattern2 is supported.";
                        continue block6;
                    }
                    case 3: {
                        partPattern.append(c);
                        if (c != ')' || --blockLevel != 0) continue block6;
                        state = ParserState.START;
                    }
                }
            }
            patterns.add(partPattern.toString());
        } else {
            patterns.add(pattern);
        }
        return patterns;
    }

    private synchronized Set<String> getIncludePatterns() {
        if (this.includePatterns == null) {
            HashSet<String> patterns = new HashSet<String>();
            for (Category category : this.getCategories()) {
                for (Item item : category.getItems()) {
                    String include;
                    if (!item.isEnabled() || (include = item.getInclude()) == null || include.length() <= 0) continue;
                    patterns.addAll(OptionsExportModel.parsePattern(include));
                }
            }
            this.includePatterns = patterns;
        }
        return this.includePatterns;
    }

    private synchronized Set<String> getExcludePatterns() {
        if (this.excludePatterns == null) {
            HashSet<String> patterns = new HashSet<String>();
            for (Category category : this.getCategories()) {
                for (Item item : category.getItems()) {
                    String exclude;
                    if (!item.isEnabled() || (exclude = item.getExclude()) == null || exclude.length() <= 0) continue;
                    patterns.addAll(OptionsExportModel.parsePattern(exclude));
                }
            }
            this.excludePatterns = patterns;
        }
        return this.excludePatterns;
    }

    private void loadCategories() {
        FileObject[] categoryFOs = FileUtil.getConfigFile((String)OPTIONS_EXPORT_FOLDER).getChildren();
        List sortedCats = FileUtil.getOrder(Arrays.asList(categoryFOs), (boolean)false);
        this.categories = new ArrayList<Category>(sortedCats.size());
        for (FileObject curFO : sortedCats) {
            Category category = new Category(curFO);
            if (ENABLED_CATEGORIES.contains(category.getName())) {
                category.setEnabled(true);
            }
            this.categories.add(category);
        }
    }

    private List<String> getApplicablePaths(Set<String> includePatterns, Set<String> excludePatterns) {
        ArrayList<String> applicablePaths = new ArrayList<String>();
        for (String relativePath : this.getRelativePaths()) {
            if (!OptionsExportModel.matches(relativePath, includePatterns, excludePatterns)) continue;
            applicablePaths.add(relativePath);
        }
        return applicablePaths;
    }

    private List<String> getRelativePaths() {
        if (this.relativePaths == null) {
            if (this.source != null && this.source.isFile()) {
                try {
                    this.relativePaths = OptionsExportModel.listZipFile(this.source);
                }
                catch (IOException ex) {
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(OptionsExportModel.class, (String)"OptionsExportModel.invalid.zipfile", (Object)this.source));
                    Exceptions.printStackTrace((Throwable)ex);
                    this.relativePaths = Collections.emptyList();
                }
            } else {
                File root = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
                this.relativePaths = OptionsExportModel.getRelativePaths(Places.getUserDirectory());
            }
            LOGGER.fine("relativePaths=" + this.relativePaths);
        }
        return this.relativePaths;
    }

    private static List<String> getRelativePaths(File sourceRoot) {
        return OptionsExportModel.getRelativePaths(sourceRoot, sourceRoot);
    }

    private static List<String> getRelativePaths(File root, File file) {
        String relativePath = OptionsExportModel.getRelativePath(root, file);
        ArrayList<String> result = new ArrayList<String>();
        if (file.isDirectory()) {
            if (IGNORED_FOLDERS.contains(relativePath)) {
                return result;
            }
            File[] children = file.listFiles();
            if (children == null) {
                return Collections.emptyList();
            }
            for (File child : children) {
                result.addAll(OptionsExportModel.getRelativePaths(root, child));
            }
        } else {
            result.add(relativePath);
        }
        return result;
    }

    private static String getRelativePath(File root, File file) {
        String result = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        if ((result = result.replace('\\', '/')).startsWith("/") && !result.startsWith("//")) {
            result = result.substring(1);
        }
        return result;
    }

    private static boolean matches(String relativePath, Set<String> includePatterns, Set<String> excludePatterns) {
        boolean include = false;
        for (String pattern : includePatterns) {
            if (!OptionsExportModel.matches(relativePath, pattern)) continue;
            include = true;
            break;
        }
        if (include) {
            for (String pattern : excludePatterns) {
                if (pattern.contains("#") || !OptionsExportModel.matches(relativePath, pattern)) continue;
                return false;
            }
        }
        return include;
    }

    private static boolean matches(String relativePath, String pattern) {
        if (pattern.contains("#")) {
            pattern = pattern.split("#", 2)[0];
        }
        return relativePath.matches(pattern);
    }

    private Set<String> matchingKeys(String relativePath, String propertiesPattern) throws IOException {
        HashSet<String> matchingKeys = new HashSet<String>();
        String[] patterns = propertiesPattern.split("#", 2);
        String filePattern = patterns[0];
        String keyPattern = patterns[1];
        if (relativePath.matches(filePattern)) {
            if (this.currentProperties == null) {
                this.currentProperties = this.getProperties(relativePath);
            }
            for (String key : this.currentProperties.keySet()) {
                if (!key.matches(keyPattern)) continue;
                matchingKeys.add(key);
            }
        }
        return matchingKeys;
    }

    private void copyFile(String relativePath) throws IOException {
        OutputStream out;
        this.currentProperties = null;
        boolean includeFile = false;
        HashSet<String> includeKeys = new HashSet<String>();
        HashSet<String> excludeKeys = new HashSet<String>();
        for (String pattern : this.getIncludePatterns()) {
            if (pattern.contains("#")) {
                includeKeys.addAll(this.matchingKeys(relativePath, pattern));
                continue;
            }
            if (!relativePath.matches(pattern)) continue;
            includeFile = true;
            includeKeys.clear();
            break;
        }
        if (includeFile || !includeKeys.isEmpty()) {
            for (String pattern : this.getExcludePatterns()) {
                if (pattern.contains("#")) {
                    excludeKeys.addAll(this.matchingKeys(relativePath, pattern));
                    continue;
                }
                if (!relativePath.matches(pattern)) continue;
                includeFile = false;
                includeKeys.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{relativePath, includeFile, includeKeys, excludeKeys});
        if (!includeFile && includeKeys.isEmpty()) {
            return;
        }
        File targetFile = new File(this.targetUserdir, relativePath);
        File origFile = new File(this.targetUserdir, relativePath + ".orig");
        if (!origFile.exists()) {
            out = OptionsExportModel.createOutputStream(origFile);
            try {
                this.copyFile(relativePath, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        LOGGER.log(Level.FINE, "Path: {0}", relativePath);
        if (includeKeys.isEmpty() && excludeKeys.isEmpty()) {
            out = OptionsExportModel.createOutputStream(targetFile);
            try {
                this.copyFile(relativePath, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        } else {
            this.mergeProperties(relativePath, includeKeys, excludeKeys);
        }
    }

    private void clearFile(String relativePath) throws IOException {
        boolean includeFile = false;
        HashSet<String> includeKeys = new HashSet<String>();
        HashSet<String> excludeKeys = new HashSet<String>();
        for (String pattern : this.getIncludePatterns()) {
            if (pattern.contains("#")) {
                includeKeys.addAll(this.matchingKeys(relativePath, pattern));
                continue;
            }
            if (!relativePath.matches(pattern)) continue;
            includeFile = true;
            includeKeys.clear();
            break;
        }
        if (includeFile || !includeKeys.isEmpty()) {
            for (String pattern : this.getExcludePatterns()) {
                if (pattern.contains("#")) {
                    excludeKeys.addAll(this.matchingKeys(relativePath, pattern));
                    continue;
                }
                if (!relativePath.matches(pattern)) continue;
                includeFile = false;
                includeKeys.clear();
                break;
            }
        }
        LOGGER.log(Level.FINEST, "{0}, includeFile={1}, includeKeys={2}, excludeKeys={3}", new Object[]{relativePath, includeFile, includeKeys, excludeKeys});
        if (!includeFile && includeKeys.isEmpty()) {
            return;
        }
        LOGGER.log(Level.FINE, "Path: {0}", relativePath);
        File targetFile = new File(this.targetUserdir, relativePath);
        File origFile = new File(this.targetUserdir, relativePath + ".orig");
        if (origFile.exists()) {
            try (OutputStream out = OptionsExportModel.createOutputStream(targetFile);){
                this.copyFile(relativePath + ".orig", out);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            origFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeProperties(String relativePath, Set<String> includeKeys, Set<String> excludeKeys) throws IOException {
        if (!includeKeys.isEmpty()) {
            this.currentProperties.keySet().retainAll(includeKeys);
        }
        this.currentProperties.keySet().removeAll(excludeKeys);
        LOGGER.log(Level.FINE, "  Keys merged with existing properties: {0}", this.currentProperties.keySet());
        if (this.currentProperties.isEmpty()) {
            return;
        }
        EditableProperties targetProperties = new EditableProperties(false);
        File targetFile = new File(this.targetUserdir, relativePath);
        try (InputStream in = null;){
            if (targetFile.exists()) {
                in = new FileInputStream(targetFile);
                targetProperties.load(in);
            }
        }
        for (Map.Entry entry : this.currentProperties.entrySet()) {
            targetProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        try (OutputStream out = OptionsExportModel.createOutputStream(targetFile);){
            targetProperties.store(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditableProperties getProperties(String relativePath) throws IOException {
        EditableProperties properties = new EditableProperties(false);
        try (InputStream in = null;){
            in = this.getInputStream(relativePath);
            properties.load(in);
        }
        return properties;
    }

    private InputStream getInputStream(String relativePath) throws IOException {
        if (this.source != null && this.source.isFile()) {
            ZipFile zipFile = new ZipFile(this.source);
            ZipEntry zipEntry = zipFile.getEntry(relativePath);
            return zipFile.getInputStream(zipEntry);
        }
        return new FileInputStream(new File(Places.getUserDirectory(), relativePath));
    }

    private void copyFile(String relativePath, OutputStream out) throws IOException {
        try (InputStream in = this.getInputStream(relativePath);){
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
    }

    private static void ensureParent(File file) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create folder: " + parent.getAbsolutePath());
        }
    }

    private static List<String> listZipFile(File file) throws IOException {
        ArrayList<String> relativePaths = new ArrayList<String>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry.isDirectory()) continue;
            relativePaths.add(zipEntry.getName());
        }
        return relativePaths;
    }

    private static OutputStream createOutputStream(File file) throws IOException {
        if (OptionsExportModel.containsConfig(file)) {
            String rootPath;
            file = file.getCanonicalFile();
            File root = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            String filePath = file.getPath();
            if (filePath.startsWith(rootPath = root.getPath())) {
                String res = filePath.substring(rootPath.length()).replace(File.separatorChar, '/');
                try {
                    FileObject fo = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)res);
                    if (fo != null) {
                        return fo.getOutputStream();
                    }
                }
                catch (SyncFailedException ex) {
                    LOGGER.log(Level.INFO, "File already exists: {0}", filePath);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "IOException while getting output stream: {0}", filePath);
                }
            }
        }
        OptionsExportModel.ensureParent(file);
        return new FileOutputStream(file);
    }

    private static boolean containsConfig(File file) {
        while (file != null) {
            if (file.getName().equals("config")) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    private static enum ParserState {
        START,
        IN_KEY_PATTERN,
        AFTER_KEY_PATTERN,
        IN_BLOCK;

    }

    private class Category {
        private static final String INCLUDE = "include";
        private static final String EXCLUDE = "exclude";
        private final FileObject categoryFO;
        private List<Item> items;

        private Category(FileObject fo) {
            this.categoryFO = fo;
        }

        private void addItem(String includes, String excludes) {
            this.items.add(new Item(includes, excludes));
        }

        private void resolveGroups(String include, String exclude) {
            LOGGER.log(Level.FINE, "resolveGroups include={0}", include);
            List applicablePaths = OptionsExportModel.this.getApplicablePaths(Collections.singleton(include), Collections.singleton(exclude));
            HashSet<String> groups = new HashSet<String>();
            Pattern p = Pattern.compile(include);
            for (String path : applicablePaths) {
                String group;
                Matcher m = p.matcher(path);
                m.matches();
                if (m.groupCount() != 1 || (group = m.group(1)) == null) continue;
                groups.add(group);
            }
            LOGGER.log(Level.FINE, "GROUPS={0}", groups);
            for (String group : groups) {
                this.addItem(include.replace(OptionsExportModel.GROUP_PATTERN, group), exclude);
            }
        }

        private List<Item> getItems() {
            if (this.items == null) {
                this.items = Collections.synchronizedList(new ArrayList());
                FileObject[] itemsFOs = this.categoryFO.getChildren();
                List sortedItems = FileUtil.getOrder(Arrays.asList(itemsFOs), (boolean)false);
                for (FileObject itemFO : itemsFOs = sortedItems.toArray(new FileObject[0])) {
                    String exclude;
                    String include = (String)itemFO.getAttribute(INCLUDE);
                    if (include == null) {
                        include = "";
                    }
                    if ((exclude = (String)itemFO.getAttribute(EXCLUDE)) == null) {
                        exclude = "";
                    }
                    if (include.contains(OptionsExportModel.GROUP_PATTERN)) {
                        this.resolveGroups(include, exclude);
                        continue;
                    }
                    this.addItem(include, exclude);
                }
            }
            return this.items;
        }

        private String getName() {
            return this.categoryFO.getNameExt();
        }

        private void setEnabled(boolean enabled) {
            for (Item item : this.getItems()) {
                item.setEnabled(enabled);
            }
        }
    }

    private class Item {
        private final String include;
        private final String exclude;
        private boolean enabled = false;

        private Item(String include, String exclude) {
            this.include = include;
            this.exclude = exclude;
            assert (this.assertIgnoredFolders(include));
        }

        private String getInclude() {
            return this.include;
        }

        private String getExclude() {
            return this.exclude;
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private void setEnabled(boolean newState) {
            if (this.enabled != newState) {
                this.enabled = newState;
                OptionsExportModel.this.includePatterns = null;
                OptionsExportModel.this.excludePatterns = null;
            }
        }

        private boolean assertIgnoredFolders(String pattern) {
            boolean result = true;
            for (String folder : IGNORED_FOLDERS) {
                assert (result = !pattern.contains(folder)) : "Pattern " + pattern + " matches ignored folder " + folder;
            }
            return result;
        }
    }
}

