/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.DeleteEJBDialog;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.GoToSourceActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.EntityChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbTransferable;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class EntityNode
extends AbstractNode
implements OpenCookie {
    private final PropertyChangeListener nameChangeListener;
    private final EjbViewController controller;

    public static EntityNode create(String ejbClass, EjbJar ejbModule, Project project) {
        try {
            return new EntityNode(new InstanceContent(), new EjbViewController(ejbClass, ejbModule), project);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private EntityNode(InstanceContent content, final EjbViewController controller, Project project) throws IOException {
        super((Children)new EntityChildren(controller), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.controller = controller;
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/ejb/entity/EntityNodeIcon.gif");
        String ejbName = null;
        try {
            ejbName = (String)controller.getEjbModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, String>(){
                final /* synthetic */ EntityNode this$0;
                {
                    this.this$0 = this$0;
                }

                public String run(EjbJarMetadata metadata) throws Exception {
                    Ejb ejb = metadata.findByEjbClass(controller.getEjbClass());
                    return ejb == null ? null : ejb.getEjbName();
                }
            });
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        this.setName(ejbName + "");
        this.setDisplayName();
        this.nameChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                EntityNode.this.setDisplayName();
            }
        };
        content.add((Object)this);
        ElementHandle<TypeElement> beanClassHandle = controller.getBeanClass();
        if (beanClassHandle != null) {
            content.add(beanClassHandle);
        }
        if (controller.getBeanDo() != null) {
            content.add((Object)controller.getBeanDo().getPrimaryFile());
        }
        try {
            content.add((Object)controller.createEjbReference());
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    private void setDisplayName() {
        this.setDisplayName(this.controller.getDisplayName());
    }

    public Action[] getActions(boolean context) {
        Collection nodes = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class)).allInstances();
        ArrayList<SystemAction> list = new ArrayList<SystemAction>();
        list.add(SystemAction.get(OpenAction.class));
        if (nodes.size() == 1) {
            list.add(null);
            list.add(SystemAction.get(AddActionGroup.class));
            list.add(null);
            list.add(SystemAction.get(GoToSourceActionGroup.class));
        }
        return (Action[])list.toArray(new SystemAction[0]);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        String deleteOptions = DeleteEJBDialog.open(this.controller.getDisplayName());
        if (!deleteOptions.equals("deleteNothing")) {
            if (deleteOptions.equals("deleteOnlyDD")) {
                this.controller.delete(false);
            } else {
                this.controller.delete(true);
            }
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        EjbReference ejbRef = this.controller.createEjbReference();
        StringBuilder ejbRefString = new StringBuilder("");
        ejbRefString.append(this.controller.getLocalStringRepresentation("Entity"));
        return new EjbTransferable(ejbRefString.toString(), ejbRef);
    }

    public Transferable clipboardCut() throws IOException {
        return this.clipboardCopy();
    }

    public void open() {
        FileObject fo = this.controller.getBeanFo();
        ElementHandle<TypeElement> beh = this.controller.getBeanClass();
        ElementOpen.open((FileObject)fo, beh);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Object getValue(String attributeName) {
        Object retValue = "customDelete".equals(attributeName) ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }
}

