/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.matcher.AbstractMatcher;
import org.jetbrains.kotlin.com.google.inject.spi.TypeConverter;

public final class PlexusDateTypeConverter
extends AbstractMatcher<TypeLiteral<?>>
implements Module,
TypeConverter {
    private static final DateFormat[] PLEXUS_DATE_FORMATS;
    private static final String CONVERSION_ERROR = "Cannot convert: \"%s\" to: %s";

    static {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S a", Locale.US), new SimpleDateFormat("yyyy-MM-dd hh:mm:ssa", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S", Locale.US), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US)};
        int n = PLEXUS_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat f = dateFormatArray[n2];
            f.setLenient(false);
            ++n2;
        }
    }

    @Override
    public void configure(Binder binder) {
        binder.convertToTypes(this, this);
    }

    @Override
    public boolean matches(TypeLiteral<?> type) {
        return Date.class == type.getRawType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convert(String value, TypeLiteral<?> toType) {
        DateFormat[] dateFormatArray = PLEXUS_DATE_FORMATS;
        int n = PLEXUS_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat f = dateFormatArray[n2];
            try {
                DateFormat dateFormat = f;
                synchronized (dateFormat) {
                    return f.parse(value);
                }
            }
            catch (ParseException parseException) {
                ++n2;
            }
        }
        throw new IllegalArgumentException(String.format(CONVERSION_ERROR, value, Date.class));
    }
}

