/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share.metrics;

import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetrics;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.share.metrics.ShareCoordinatorMetricsShard;
import org.apache.kafka.timeline.SnapshotRegistry;

public class ShareCoordinatorMetrics
extends CoordinatorMetrics
implements AutoCloseable {
    public static final String METRICS_GROUP = "share-coordinator-metrics";
    private final Metrics metrics;
    private final Map<TopicPartition, ShareCoordinatorMetricsShard> shards = new ConcurrentHashMap<TopicPartition, ShareCoordinatorMetricsShard>();
    public static final String SHARE_COORDINATOR_WRITE_SENSOR_NAME = "ShareCoordinatorWrite";
    public static final String SHARE_COORDINATOR_WRITE_LATENCY_SENSOR_NAME = "ShareCoordinatorWriteLatency";
    public final Map<String, Sensor> globalSensors;

    public ShareCoordinatorMetrics() {
        this(new Metrics());
    }

    public ShareCoordinatorMetrics(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
        Sensor shareCoordinatorWriteSensor = metrics.sensor(SHARE_COORDINATOR_WRITE_SENSOR_NAME);
        shareCoordinatorWriteSensor.add((CompoundStat)new Meter(metrics.metricName("write-rate", METRICS_GROUP, "The number of share-group state write calls per second."), metrics.metricName("write-total", METRICS_GROUP, "Total number of share-group state write calls.")));
        Sensor shareCoordinatorWriteLatencySensor = metrics.sensor(SHARE_COORDINATOR_WRITE_LATENCY_SENSOR_NAME);
        shareCoordinatorWriteLatencySensor.add(metrics.metricName("write-latency-avg", METRICS_GROUP, "The average time taken for a share-group state write call, including the time to write to the share-group state topic."), (MeasurableStat)new Avg());
        shareCoordinatorWriteLatencySensor.add(metrics.metricName("write-latency-max", METRICS_GROUP, "The maximum time taken for a share-group state write call, including the time to write to the share-group state topic."), (MeasurableStat)new Max());
        this.globalSensors = Collections.unmodifiableMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)SHARE_COORDINATOR_WRITE_SENSOR_NAME, (Object)shareCoordinatorWriteSensor), Utils.mkEntry((Object)SHARE_COORDINATOR_WRITE_LATENCY_SENSOR_NAME, (Object)shareCoordinatorWriteLatencySensor)}));
    }

    @Override
    public void close() throws Exception {
        Arrays.asList(SHARE_COORDINATOR_WRITE_SENSOR_NAME, SHARE_COORDINATOR_WRITE_LATENCY_SENSOR_NAME).forEach(arg_0 -> ((Metrics)this.metrics).removeSensor(arg_0));
    }

    public ShareCoordinatorMetricsShard newMetricsShard(SnapshotRegistry snapshotRegistry, TopicPartition tp) {
        return new ShareCoordinatorMetricsShard(snapshotRegistry, this.globalSensors, tp);
    }

    public void activateMetricsShard(CoordinatorMetricsShard shard) {
        if (!(shard instanceof ShareCoordinatorMetricsShard)) {
            throw new IllegalArgumentException("ShareCoordinatorMetrics can only activate ShareCoordinatorMetricShard");
        }
        this.shards.put(shard.topicPartition(), (ShareCoordinatorMetricsShard)shard);
    }

    public void deactivateMetricsShard(CoordinatorMetricsShard shard) {
        if (!(shard instanceof ShareCoordinatorMetricsShard)) {
            throw new IllegalArgumentException("ShareCoordinatorMetrics can only deactivate ShareCoordinatorMetricShard");
        }
        this.shards.remove(shard.topicPartition());
    }

    public MetricsRegistry registry() {
        return null;
    }

    public void onUpdateLastCommittedOffset(TopicPartition tp, long offset) {
        CoordinatorMetricsShard shard = this.shards.get(tp);
        if (shard != null) {
            shard.commitUpTo(offset);
        }
    }

    public void record(String sensorName, double value) {
        if (this.globalSensors.containsKey(sensorName)) {
            this.globalSensors.get(sensorName).record(value);
        }
    }

    public void record(String sensorName) {
        if (this.globalSensors.containsKey(sensorName)) {
            this.globalSensors.get(sensorName).record();
        }
    }
}

