/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segment pixels with similar statistics using connectivity.


This filter extracts a connected set of pixels whose pixel intensities
are consistent with the pixel statistics of a seed point. The mean and
variance across a neighborhood (8-connected, 26-connected, etc.) are
calculated for a seed point. Then pixels connected to this seed point
whose values are within the confidence interval for the seed point are
grouped. The width of the confidence interval is controlled by the
"Multiplier" variable (the confidence interval is the mean plus or
minus the "Multiplier" times the standard deviation). If the
intensity variations across a segment were gaussian, a "Multiplier"
setting of 2.5 would define a confidence interval wide enough to
capture 99% of samples in the segment.

After this initial segmentation is calculated, the mean and variance
are re-calculated. All the pixels in the previous segmentation are
used to calculate the mean the standard deviation (as opposed to using
the pixels in the neighborhood of the seed point). The segmentation is
then recalculated using these refined estimates for the mean and
variance of the pixel values. This process is repeated for the
specified number of iterations. Setting the "NumberOfIterations" to
zero stops the algorithm after the initial segmentation from the seed
point.

NOTE: the lower and upper threshold are restricted to lie within the
valid numeric limits of the input data pixel type. Also, the limits
may be adjusted to contain the seed point's intensity.
See:
 itk::simple::VectorConfidenceConnected for the procedural interface

 itk::VectorConfidenceConnectedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkVectorConfidenceConnectedImageFilter.h
*/
public class VectorConfidenceConnectedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected VectorConfidenceConnectedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.VectorConfidenceConnectedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(VectorConfidenceConnectedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(VectorConfidenceConnectedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::VectorConfidenceConnectedImageFilter::~VectorConfidenceConnectedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_VectorConfidenceConnectedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::VectorConfidenceConnectedImageFilter::VectorConfidenceConnectedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  VectorConfidenceConnectedImageFilter() {
    this(SimpleITKJNI.new_VectorConfidenceConnectedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::SetSeedList(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; SeedList)

Set list of image indexes for seeds.

*/
public  void setSeedList(VectorUIntList SeedList) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_setSeedList(swigCPtr, this, VectorUIntList.getCPtr(SeedList), SeedList);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::VectorConfidenceConnectedImageFilter::GetSeedList() const

Get list of seeds.

*/
public  VectorUIntList getSeedList() {
    return new VectorUIntList(SimpleITKJNI.VectorConfidenceConnectedImageFilter_getSeedList(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::AddSeed(std::vector&lt; unsigned int &gt; point)

Add SeedList point.

*/
public  void addSeed(VectorUInt32 point) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_addSeed(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::ClearSeeds()

Remove all SeedList points.

*/
public  void clearSeeds() {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_clearSeeds(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::SetNumberOfIterations(unsigned int NumberOfIterations)

Set/Get the number of iterations

*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
unsigned int itk::simple::VectorConfidenceConnectedImageFilter::GetNumberOfIterations() const

Set/Get the number of iterations

*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::SetMultiplier(double Multiplier)

Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5

*/
public  void setMultiplier(double Multiplier) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_setMultiplier(swigCPtr, this, Multiplier);
  }

  /**
double itk::simple::VectorConfidenceConnectedImageFilter::GetMultiplier() const

Set/Get the multiplier to define the confidence interval. Multiplier
can be anything greater than zero. A typical value is 2.5

*/
public  double getMultiplier() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_getMultiplier(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::SetInitialNeighborhoodRadius(unsigned int InitialNeighborhoodRadius)

Get/Set the radius of the neighborhood over which the statistics are
evaluated

*/
public  void setInitialNeighborhoodRadius(long InitialNeighborhoodRadius) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_setInitialNeighborhoodRadius(swigCPtr, this, InitialNeighborhoodRadius);
  }

  /**
unsigned int itk::simple::VectorConfidenceConnectedImageFilter::GetInitialNeighborhoodRadius() const

Get/Set the radius of the neighborhood over which the statistics are
evaluated

*/
public  long getInitialNeighborhoodRadius() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_getInitialNeighborhoodRadius(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VectorConfidenceConnectedImageFilter::SetReplaceValue(uint8_t ReplaceValue)

Set/Get value to replace thresholded pixels

*/
public  void setReplaceValue(short ReplaceValue) {
    SimpleITKJNI.VectorConfidenceConnectedImageFilter_setReplaceValue(swigCPtr, this, ReplaceValue);
  }

  /**
uint8_t itk::simple::VectorConfidenceConnectedImageFilter::GetReplaceValue() const

Set/Get value to replace thresholded pixels

*/
public  short getReplaceValue() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_getReplaceValue(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::VectorConfidenceConnectedImageFilter::GetMean() const

Get the Mean Vector computed during the segmentation

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getMean() {
    return new VectorDouble(SimpleITKJNI.VectorConfidenceConnectedImageFilter_getMean(swigCPtr, this), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::VectorConfidenceConnectedImageFilter::GetCovariance() const

Get the Covariance matrix computed during the segmentation

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getCovariance() {
    return new VectorDouble(SimpleITKJNI.VectorConfidenceConnectedImageFilter_getCovariance(swigCPtr, this), true);
  }

  /**
std::string itk::simple::VectorConfidenceConnectedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::VectorConfidenceConnectedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.VectorConfidenceConnectedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::VectorConfidenceConnectedImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.VectorConfidenceConnectedImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
