#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.14.1.0
visibility:           public
id:                   lsp-test-0.14.1.0-5ma7Ml9YrRz6GOSyXuyYIX
key:                  lsp-test-0.14.1.0-5ma7Ml9YrRz6GOSyXuyYIX
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  216a05b8e2d459e23bc516571ba2c405
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.1.0-5ma7Ml9YrRz6GOSyXuyYIX
depends:
    Diff-0.4.1-L8DOUuNGxiiH0X79lq9Zn6
    Glob-0.10.2-12Tvsi3A4nsDSOOvjKvt4o
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    aeson-pretty-0.8.10-1UVA7jwF3AY2XeDKFp8bmR
    ansi-terminal-1.0.2-KEBwSt8cOBhArBBqY461TL
    async-2.2.5-6FnQWPoSLF0101MXuyNKqJ base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-BspKaH0gGYBYPLc2Xswpr
    conduit-1.3.6.1-CTNxTBwbo3PGCTtXLpLpH4
    conduit-parse-0.2.1.1-BDrTZUqeeTh8klpVQe5r3L containers-0.6.7
    data-default-0.7.1.1-86NXSPgvsmt76HSLrJaFnV directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2 lens-5.3-8ZK9QDANmBT9CZTQ77OGiP
    lsp-1.6.0.0-Co7EnzQRcLkB1nGUK6qxXO
    lsp-types-1.6.0.1-FhDct8eUWUx1AZAIgEVg8r mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    some-1.0.6-As3QDrvuxaqEQIbQQrudXS text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

