/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;
import org.gradle.jvm.toolchain.internal.OsXJavaHomeCommand;

public class OsXInstallationSupplier
implements InstallationSupplier {
    private final OsXJavaHomeCommand javaHomeCommand;
    private final OperatingSystem os;

    @Inject
    public OsXInstallationSupplier(OperatingSystem os, OsXJavaHomeCommand javaHomeCommand) {
        this.javaHomeCommand = javaHomeCommand;
        this.os = os;
    }

    @Override
    public String getSourceName() {
        return "MacOS java_home";
    }

    @Override
    public Set<InstallationLocation> get() {
        if (this.os.isMacOsX()) {
            return this.javaHomeCommand.findJavaHomes().stream().map(this::asInstallation).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private InstallationLocation asInstallation(File javaHome) {
        return InstallationLocation.autoDetected(javaHome, this.getSourceName());
    }
}

