/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.api;

public class Vector {
    public float x;
    public float y;

    public Vector() {
    }

    public Vector(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public static Vector div(Vector v, float n) {
        return new Vector(v.x / n, v.y / n);
    }

    public static Vector mult(Vector v, float n) {
        return new Vector(v.x * n, v.y * n);
    }

    public static Vector add(Vector v1, Vector v2) {
        return new Vector(v1.x + v2.x, v1.y + v2.y);
    }

    public static Vector sub(Vector v1, Vector v2) {
        return new Vector(v1.x - v2.x, v1.y - v2.y);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Vector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void div(float n) {
        this.x /= n;
        this.y /= n;
    }

    public void mult(float n) {
        this.x *= n;
        this.y *= n;
    }

    public void add(Vector v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void add(float a, float b) {
        this.x += a;
        this.y += b;
    }

    public void sub(Vector v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public void sub(float a, float b) {
        this.x -= a;
        this.y -= b;
    }

    public float mag() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        float m = this.mag();
        if (m != 0.0f && m != 1.0f) {
            this.div(m);
        }
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Float.floatToIntBits(this.x);
        hash = 83 * hash + Float.floatToIntBits(this.y);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector other = (Vector)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        return "Vector{x=" + this.x + ", y=" + this.y + "}";
    }
}

