/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.Rule;
import org.w3c.dom.DOMException;

public class StyleSheet {
    protected Rule[] rules = new Rule[16];
    protected int size;
    protected StyleSheet parent;
    protected boolean alternate;
    protected MediaQueryList media;
    protected String title;

    public void setMedia(MediaQueryList mediaQueryList) {
        this.media = mediaQueryList;
    }

    public MediaQueryList getMedia() {
        return this.media;
    }

    public StyleSheet getParent() {
        return this.parent;
    }

    public void setParent(StyleSheet styleSheet) {
        this.parent = styleSheet;
    }

    public void setAlternate(boolean bl) {
        this.alternate = bl;
    }

    public boolean isAlternate() {
        return this.alternate;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Rule getRule(int n) {
        return this.rules[n];
    }

    public void deleteRule(int n) throws DOMException {
        if (n < 0 || n >= this.size) {
            throw new DOMException(1, "Invalid index: " + n + '.');
        }
        for (int i = n; i < this.size - 1; ++i) {
            this.rules[i] = this.rules[i + 1];
        }
        --this.size;
        this.rules[this.size] = null;
    }

    public void clear() {
        this.size = 0;
        this.rules = new Rule[10];
    }

    public void append(Rule rule) {
        if (this.size == this.rules.length) {
            Rule[] ruleArray = new Rule[this.size * 2];
            System.arraycopy(this.rules, 0, ruleArray, 0, this.size);
            this.rules = ruleArray;
        }
        this.rules[this.size++] = rule;
    }

    public String toString(CSSEngine cSSEngine) {
        StringBuilder stringBuilder = new StringBuilder(this.size * 8);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.rules[i].toString(cSSEngine));
        }
        return stringBuilder.toString();
    }
}

