/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeDialog;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;
import org.freeplane.plugin.latex.LatexRenderIcon;
import org.freeplane.plugin.latex.TeXText;
import org.freeplane.view.swing.map.ZoomableLabel;
import org.scilab.forge.jlatexmath.TeXIcon;

public class LatexRenderer
extends AbstractContentTransformer
implements IEditBaseCreator {
    private static final String LATEX_EDITOR_FONT_SIZE = "latex_editor_font_size";
    private static final String LATEX_EDITOR_FONT = "latex_editor_font";
    private static final String LATEX_EDITOR_DISABLE_INLINE = "latex_disable_editor";
    private static final String LATEX = "\\latex";
    private static final String UNPARSED_LATEX = "\\unparsedlatex";
    static final String LATEX_CONTENT_TYPE = "latex";
    static final String LATEX_FORMAT = "latexPatternFormat";
    static final String UNPARSED_LATEX_FORMAT = "unparsedLatexPatternFormat";

    public LatexRenderer() {
        super(20);
    }

    public Object transformContent(NodeModel node, Object nodeProperty, Object content, TextController textController, IContentTransformer.Mode mode, Component component) throws TransformationException {
        int widthWithInsets;
        if (mode == IContentTransformer.Mode.TEXT) {
            return content;
        }
        String latext = this.getText(node, nodeProperty, content, Target.VIEW, textController);
        if (latext == null) {
            return content;
        }
        if (component instanceof ZoomableLabel) {
            ZoomableLabel label = (ZoomableLabel)component;
            if (label.getVerticalTextPosition() != 3) {
                Icon icon = label.getIcon();
                int iconWidth = icon != null ? icon.getIconWidth() : 0;
                int iconWithGapWidth = iconWidth > 0 ? iconWidth + label.getIconTextGap() : 0;
                widthWithInsets = label.getMaximumWidth() - iconWithGapWidth;
            } else {
                widthWithInsets = label.getMaximumWidth();
            }
        } else {
            widthWithInsets = component.getWidth();
        }
        int maxWidth = widthWithInsets > 4 ? widthWithInsets : 10000;
        TeXText teXt = new TeXText(latext);
        int fontSize = component.getFont().getSize();
        TeXIcon icon = teXt.createTeXIcon(component.getForeground(), 0, fontSize, 0, maxWidth);
        int insetSize = (widthWithInsets - maxWidth) / 2;
        icon.setInsets(new Insets(insetSize, insetSize, insetSize, insetSize));
        return new LatexRenderIcon((Icon)icon);
    }

    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        JEditorPane textEditor = this.createTextEditorPane(this::createScrollPane, node, nodeProperty, content, !editLong);
        return textEditor == null ? null : this.createEditor(node, editControl, textEditor);
    }

    private JRestrictedSizeScrollPane createScrollPane() {
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(new Dimension(0, 60));
        return scrollPane;
    }

    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        if (editInline && ResourceController.getResourceController().getBooleanProperty(LATEX_EDITOR_DISABLE_INLINE)) {
            return null;
        }
        String latexText = this.getText(node, nodeProperty, content, Target.EDITOR, (TextController)MTextController.getController());
        if (latexText == null) {
            return null;
        }
        JEditorPane textEditor = new JEditorPane();
        scrollPaneSupplier.get().setViewportView(textEditor);
        textEditor.setContentType("text/latex");
        textEditor.setText(latexText);
        SourceTextEditorUIConfigurator.configureColors((JTextComponent)textEditor);
        String fontName = ResourceController.getResourceController().getProperty(LATEX_EDITOR_FONT);
        int fontSize = ResourceController.getResourceController().getIntProperty(LATEX_EDITOR_FONT_SIZE);
        Font font = UITools.scaleUI((Font)new Font(fontName, 0, fontSize));
        textEditor.setFont(font);
        return textEditor;
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, JEditorPane textEditor) {
        AWTEvent firstEvent = MTextController.getController().getEventQueue().getFirstEvent();
        EditNodeDialog editNodeDialog = new EditNodeDialog(node, firstEvent, false, editControl, false, textEditor);
        editNodeDialog.setTitle(TextUtils.getText((String)"latex_editor"));
        return editNodeDialog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getText(NodeModel node, Object nodeProperty, Object content, Target targetMode, TextController textController) {
        String contentType;
        if (!(content instanceof String)) {
            return null;
        }
        MNoteController noteController = MNoteController.getController();
        if (nodeProperty instanceof NodeModel) {
            if (textController.isTextFormattingDisabled(node)) return null;
            contentType = textController.getNodeFormat(node);
        } else if (nodeProperty instanceof DetailModel) {
            String detailsContentType = textController.getDetailsContentType(node);
            if (LATEX_CONTENT_TYPE.equals(detailsContentType)) {
                contentType = LATEX_FORMAT;
            } else {
                if (!"auto".equals(detailsContentType)) return null;
                contentType = "auto";
            }
        } else {
            if (!(nodeProperty instanceof NoteModel)) return null;
            String noteContentType = noteController.getNoteContentType(node);
            if (LATEX_CONTENT_TYPE.equals(noteContentType)) {
                contentType = LATEX_FORMAT;
            } else {
                if (!"auto".equals(noteContentType)) return null;
                contentType = "auto";
            }
        }
        String plainOrHtmlText = (String)content;
        String text = HtmlUtils.htmlToPlain((String)plainOrHtmlText);
        return this.getLatexText(text, contentType, targetMode);
    }

    private String getLatexText(String nodeText, String patternFormat, Target mode) {
        boolean includePrefix;
        boolean bl = includePrefix = mode == Target.EDITOR;
        if (LatexRenderer.startsWithPrefix(nodeText, LATEX)) {
            return includePrefix ? nodeText : nodeText.substring(LATEX.length() + 1);
        }
        if (LATEX_FORMAT.equals(patternFormat)) {
            return nodeText;
        }
        if (LatexRenderer.startsWithPrefix(nodeText, UNPARSED_LATEX) && mode == Target.EDITOR) {
            return nodeText;
        }
        if (UNPARSED_LATEX_FORMAT.equals(patternFormat) && mode == Target.EDITOR) {
            return nodeText;
        }
        return null;
    }

    private static boolean startsWithPrefix(String nodeText, String prefix) {
        int startLength = prefix.length() + 1;
        return nodeText.length() > startLength && nodeText.startsWith(prefix) && Character.isWhitespace(nodeText.charAt(startLength - 1));
    }

    private static enum Target {
        VIEW,
        EDITOR;

    }
}

