from . import DriverChip
from .ili import ILI9488_A

DriverChip(
    "WAVESHARE-4-TFT",
    width=320,
    height=480,
    invert_colors=True,
    spi_16=True,
    initsequence=(
        (
            0xF9,
            0x00,
            0x08,
        ),
        (
            0xC0,
            0x19,
            0x1A,
        ),
        (
            0xC1,
            0x45,
            0x00,
        ),
        (
            0xC2,
            0x33,
        ),
        (
            0xC5,
            0x00,
            0x28,
        ),
        (
            0xB1,
            0xA0,
            0x11,
        ),
        (
            0xB4,
            0x02,
        ),
        (
            0xB6,
            0x00,
            0x42,
            0x3B,
        ),
        (
            0xB7,
            0x07,
        ),
        (
            0xE0,
            0x1F,
            0x25,
            0x22,
            0x0B,
            0x06,
            0x0A,
            0x4E,
            0xC6,
            0x39,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
        ),
        (
            0xE1,
            0x1F,
            0x3F,
            0x3F,
            0x0F,
            0x1F,
            0x0F,
            0x46,
            0x49,
            0x31,
            0x05,
            0x09,
            0x03,
            0x1C,
            0x1A,
            0x00,
        ),
        (
            0xF1,
            0x36,
            0x04,
            0x00,
            0x3C,
            0x0F,
            0x0F,
            0xA4,
            0x02,
        ),
        (
            0xF2,
            0x18,
            0xA3,
            0x12,
            0x02,
            0x32,
            0x12,
            0xFF,
            0x32,
            0x00,
        ),
        (
            0xF4,
            0x40,
            0x00,
            0x08,
            0x91,
            0x04,
        ),
        (
            0xF8,
            0x21,
            0x04,
        ),
    ),
)

ILI9488_A.extend(
    "PICO-RESTOUCH-LCD-3.5",
    spi_16=True,
    pixel_mode="16bit",
    mirror_x=True,
    dc_pin=33,
    cs_pin=34,
    reset_pin=40,
    data_rate="20MHz",
    invert_colors=True,
)
