/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.utils.AIHttpTransportException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MonitoredHttpClient
implements AutoCloseable {
    private final HttpClient client;

    public MonitoredHttpClient(HttpClient client) {
        this.client = client;
    }

    public HttpResponse<String> send(DBRProgressMonitor monitor, HttpRequest request) throws DBException {
        monitor.beginTask("Request AI completion", 1);
        CompletableFuture<HttpResponse<String>> responseCompletableFuture = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
        try {
            monitor.subTask("Sending request to " + String.valueOf(request.uri()));
            while (true) {
                if (monitor.isCanceled()) {
                    responseCompletableFuture.cancel(true);
                    throw new InterruptedException();
                }
                if (responseCompletableFuture.isDone()) break;
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            HttpResponse<String> httpResponse = responseCompletableFuture.get();
            return httpResponse;
        }
        catch (InterruptedException e) {
            throw new DBException("Request was cancelled", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new DBException("Request failed", (Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public CompletableFuture<Void> sendAsync(@NotNull HttpRequest request, @NotNull Consumer<String> eventHandler, @NotNull Consumer<Throwable> errorHandler, @NotNull Runnable completionHandler) {
        return ((CompletableFuture)this.client.sendAsync(request, HttpResponse.BodyHandlers.ofLines()).thenAccept(response -> {
            int statusCode = response.statusCode();
            if (statusCode > 299) {
                String responseBody = ((Stream)response.body()).collect(Collectors.joining());
                errorHandler.accept((Throwable)((Object)new AIHttpTransportException(statusCode, responseBody)));
                return;
            }
            ((Stream)response.body()).forEach(eventHandler);
        })).whenComplete((v, e) -> {
            if (e != null) {
                errorHandler.accept((Throwable)e);
            } else {
                completionHandler.run();
            }
        });
    }

    @Override
    public void close() {
    }
}

