/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptFormatter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;

public class DatabaseMetadataUtils {
    private static final Log log = Log.getLog(DatabaseMetadataUtils.class);
    private static final boolean SUPPORTS_ATTRS = true;

    public static String generateObjectDescription(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @Nullable DBCExecutionContext context, @NotNull AIPromptFormatter formatter, int maxRequestLength, boolean useFullyQualifiedName) throws DBException {
        if (DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)object, (boolean)false) == null) {
            return "";
        }
        StringBuilder description = new StringBuilder();
        if (object instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)object;
            String name = useFullyQualifiedName && context != null ? DBUtils.getObjectFullName((DBPDataSource)context.getDataSource(), (DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier((DBSObject)object);
            formatter.addObjectDescriptionIfNeeded(description, (DBPObjectWithDescription)object, monitor);
            if (object instanceof DBSTable) {
                DBSTable table = (DBSTable)object;
                description.append(table.isView() ? "CREATE VIEW" : "CREATE TABLE");
            }
            description.append(" ").append(name).append("(");
            DBSEntityAttribute firstAttr = DatabaseMetadataUtils.addPromptAttributes(monitor, entity, description, formatter);
            formatter.addExtraDescription(monitor, entity, description, (DBPObjectWithDescription)firstAttr);
            description.append(");\n");
            if (object instanceof DBSDataContainer) {
                DBSDataContainer dataContainer = (DBSDataContainer)object;
                formatter.addDataSample(monitor, dataContainer, description);
            }
        } else if (object instanceof DBSObjectContainer) {
            DBSObjectContainer objectContainer = (DBSObjectContainer)object;
            monitor.subTask("Load cache of " + object.getName());
            objectContainer.cacheStructure(monitor, 3);
            for (DBSObject child : objectContainer.getChildren(monitor)) {
                if (DBUtils.isSystemObject((Object)child) || DBUtils.isHiddenObject((Object)child) || child instanceof DBSTablePartition) continue;
                String childText = DatabaseMetadataUtils.generateObjectDescription(monitor, child, context, formatter, maxRequestLength, DatabaseMetadataUtils.isRequiresFullyQualifiedName(child, context));
                if (description.length() + childText.length() > maxRequestLength * 3) {
                    log.debug((Object)("Trim AI metadata prompt  at table '" + child.getName() + "' - too long request"));
                    break;
                }
                description.append(childText);
            }
        }
        return description.toString();
    }

    @NotNull
    public static String describeContext(@NotNull DBRProgressMonitor monitor, @NotNull AIDatabaseContext context, @NotNull AIPromptFormatter formatter, int maxRequestTokens) throws DBException {
        DBSObjectContainer mainObject = context.getScopeObject();
        if (mainObject == null || mainObject.getDataSource() == null) {
            throw new DBException("Invalid completion request");
        }
        DBCExecutionContext executionContext = context.getExecutionContext();
        StringBuilder sb = new StringBuilder();
        int remainingRequestTokens = maxRequestTokens - sb.length() - 20;
        if (context.getScope() == AIDatabaseScope.CUSTOM) {
            List<DBSObject> normalizeCustomEntities = DatabaseMetadataUtils.normalizeCustomEntities(context.getCustomEntities());
            DatabaseMetadataUtils.cacheStructuresForCustomEntities(monitor, normalizeCustomEntities);
            for (DBSObject entity : normalizeCustomEntities) {
                sb.append(DatabaseMetadataUtils.generateObjectDescription(monitor, entity, executionContext, formatter, remainingRequestTokens, DatabaseMetadataUtils.isRequiresFullyQualifiedName(entity, executionContext)));
            }
        } else {
            sb.append(DatabaseMetadataUtils.generateObjectDescription(monitor, (DBSObject)mainObject, executionContext, formatter, remainingRequestTokens, false));
        }
        return sb.toString();
    }

    protected static DBSEntityAttribute addPromptAttributes(DBRProgressMonitor monitor, DBSEntity entity, StringBuilder prompt, AIPromptFormatter formatter) throws DBException {
        DBSEntityAttribute prevAttribute = null;
        List attributes = entity.getAttributes(monitor);
        if (attributes != null) {
            for (DBSEntityAttribute attribute : attributes) {
                if (DBUtils.isHiddenObject((Object)attribute)) continue;
                if (prevAttribute != null) {
                    prompt.append(",");
                    formatter.addObjectDescriptionIfNeeded(prompt, (DBPObjectWithDescription)prevAttribute, monitor);
                }
                prompt.append(attribute.getName());
                formatter.addColumnTypeIfNeeded(prompt, attribute, monitor);
                prevAttribute = attribute;
            }
        }
        return prevAttribute;
    }

    private static boolean isRequiresFullyQualifiedName(@NotNull DBSObject object, @Nullable DBCExecutionContext context) {
        if (context == null || context.getContextDefaults() == null) {
            return false;
        }
        DBSObject parent = object.getParentObject();
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        return parent != null && !parent.equals(contextDefaults.getDefaultCatalog()) && !parent.equals(contextDefaults.getDefaultSchema());
    }

    private DatabaseMetadataUtils() {
    }

    private static List<DBSObject> normalizeCustomEntities(@NotNull List<DBSObject> customEntities) {
        HashSet<DBSObject> input = new HashSet<DBSObject>(customEntities);
        return input.stream().filter(obj -> {
            DBSObject parent = obj.getParentObject();
            while (parent != null) {
                if (input.contains(parent)) {
                    return false;
                }
                parent = parent.getParentObject();
            }
            return true;
        }).sorted(Comparator.comparing(DBPNamedObject::getName, String.CASE_INSENSITIVE_ORDER)).toList();
    }

    private static void cacheStructuresForCustomEntities(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSObject> customEntities) throws DBException {
        Set<Map.Entry<DBSObjectContainer, Long>> objectContainers = customEntities.stream().filter(it -> it instanceof DBSEntity).map(it -> (DBSObjectContainer)it.getParentObject()).collect(Collectors.groupingBy(it -> it, Collectors.counting())).entrySet();
        for (Map.Entry<DBSObjectContainer, Long> entry : objectContainers) {
            if (entry.getValue() <= 1L) continue;
            entry.getKey().cacheStructure(monitor, 3);
        }
    }
}

