/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.AIEngineSettings;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;

public class AISettings
implements IAdaptable {
    private boolean aiDisabled;
    private String activeEngine;
    private final Map<String, AIEngineSettings<?>> engineConfigurations = new HashMap();
    private final Set<String> resolvedSecrets = new HashSet<String>();

    public boolean isAiDisabled() {
        return this.aiDisabled;
    }

    public void setAiDisabled(boolean aiDisabled) {
        this.aiDisabled = aiDisabled;
    }

    public String activeEngine() {
        return this.activeEngine;
    }

    public void setActiveEngine(String activeEngine) {
        this.activeEngine = activeEngine;
    }

    @NotNull
    public synchronized <T extends AIEngineSettings<?>> T getEngineConfiguration(String engineId) throws DBException {
        AIEngineSettings<?> aiEngineSettings = this.engineConfigurations.get(engineId);
        if (!AISettingsRegistry.saveSecretsAsPlainText() && !this.resolvedSecrets.contains(engineId)) {
            aiEngineSettings.resolveSecrets();
            this.resolvedSecrets.add(engineId);
        }
        return (T)aiEngineSettings;
    }

    public void setEngineConfiguration(String engineId, AIEngineSettings<?> engineConfiguration) {
        this.engineConfigurations.put(engineId, engineConfiguration);
    }

    public void setEngineConfigurations(Map<String, AIEngineSettings<?>> engineConfigurations) {
        this.engineConfigurations.putAll(engineConfigurations);
    }

    public void saveSecrets() throws DBException {
        for (AIEngineSettings<?> engineConfiguration : this.engineConfigurations.values()) {
            engineConfiguration.saveSecrets();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }
}

