/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.navigator.INavigatorFilter;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsTreeManager;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

public class DatabaseObjectsSelectorPanel
extends Composite {
    private final DBPProject selectedProject;
    private final DatabaseNavigatorTree dataSourceTree;
    private DatabaseObjectsTreeManager checkboxTreeManager;

    public DatabaseObjectsSelectorPanel(Composite parent, boolean multiSelector, DBRRunnableContext runnableContext) {
        this(parent, runnableContext, 0x804 | (multiSelector ? 32 : 0));
    }

    public DatabaseObjectsSelectorPanel(Composite parent, DBRRunnableContext runnableContext, int style) {
        super(parent, 0);
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(1808));
        }
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.selectedProject = this.getSelectedProject();
        DBNNode rootNode = this.getRootNode();
        this.dataSourceTree = new DatabaseNavigatorTree(this, rootNode, style);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        this.dataSourceTree.setLayoutData(gd);
        this.dataSourceTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        return DatabaseObjectsSelectorPanel.this.isDatabaseFolderVisible(folder);
                    }
                    if (element instanceof DBNProjectDatabases) {
                        return true;
                    }
                    if (element instanceof DBNLocalFolder) {
                        DBNLocalFolder localFolder = (DBNLocalFolder)element;
                        return DatabaseObjectsSelectorPanel.this.isFolderVisible(localFolder);
                    }
                    if (element instanceof DBNDataSource) {
                        DBNDataSource dataSource = (DBNDataSource)element;
                        return DatabaseObjectsSelectorPanel.this.isDataSourceVisible(dataSource);
                    }
                    if (element instanceof DBSWrapper) {
                        DBSWrapper wrapper = (DBSWrapper)element;
                        return DatabaseObjectsSelectorPanel.this.isDatabaseObjectVisible(wrapper.getObject());
                    }
                }
                return false;
            }
        });
        if ((style & 0x20) != 0) {
            CheckboxTreeViewer viewer = this.dataSourceTree.getCheckboxViewer();
            this.checkboxTreeManager = new DatabaseObjectsTreeManager(runnableContext, viewer, new Class[]{DBSDataContainer.class});
            viewer.addCheckStateListener(event -> this.onSelectionChange(event.getElement()));
        } else {
            this.dataSourceTree.getViewer().addSelectionChangedListener(event -> this.onSelectionChange(((IStructuredSelection)event.getSelection()).getFirstElement()));
        }
    }

    public DatabaseNavigatorTree getNavigatorTree() {
        return this.dataSourceTree;
    }

    protected DBPProject getSelectedProject() {
        return NavigatorUtils.getSelectedProject();
    }

    protected DBNNode getRootNode() {
        DBNModel navigatorModel = this.selectedProject.getNavigatorModel();
        DBNProject projectNode = navigatorModel.getRoot().getProjectNode(this.selectedProject);
        DBNRoot rootNode = projectNode == null ? navigatorModel.getRoot() : projectNode.getDatabases();
        return rootNode;
    }

    public void setNavigatorFilter(INavigatorFilter navigatorFilter) {
        this.dataSourceTree.setNavigatorFilter(navigatorFilter);
    }

    public DBPProject getProject() {
        return this.selectedProject;
    }

    public void setSelection(List<? extends DBNNode> nodes) {
        this.dataSourceTree.getViewer().setSelection((ISelection)new StructuredSelection(nodes), true);
    }

    public void checkNodes(Collection<? extends DBNNode> nodes, boolean revealAll) {
        TreeViewer treeViewer = this.dataSourceTree.getViewer();
        boolean first = true;
        for (DBNNode dBNNode : nodes) {
            if (revealAll) {
                treeViewer.reveal((Object)dBNNode);
            } else if (first) {
                DBNDataSource dsNode = DBNDataSource.getDataSourceNode((DBNNode)dBNNode);
                if (dsNode != null) {
                    treeViewer.reveal((Object)dsNode);
                }
                first = false;
            }
            if (!(treeViewer instanceof CheckboxTreeViewer)) continue;
            ((CheckboxTreeViewer)treeViewer).setChecked((Object)dBNNode, true);
        }
        if (treeViewer instanceof CheckboxTreeViewer) {
            this.checkboxTreeManager.updateCheckStates();
        }
    }

    public boolean hasCheckedNodes() {
        Object[] objectArray = this.dataSourceTree.getCheckboxViewer().getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNNode) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<DBNNode> getCheckedNodes() {
        Object[] checkedElements = this.dataSourceTree.getCheckboxViewer().getCheckedElements();
        ArrayList<DBNNode> result = new ArrayList<DBNNode>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof DBNNode) {
                result.add((DBNNode)element);
            }
            ++n2;
        }
        return result;
    }

    protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
        Class folderItemsClass = folder.getChildrenClass();
        return folderItemsClass != null && (DBSObjectContainer.class.isAssignableFrom(folderItemsClass) || DBSEntity.class.isAssignableFrom(folderItemsClass));
    }

    protected boolean isDatabaseObjectVisible(DBSObject obj) {
        return obj instanceof DBSInstance || obj instanceof DBSObjectContainer || obj instanceof DBSDataContainer && obj instanceof DBSEntity;
    }

    protected boolean isDataSourceVisible(DBNDataSource dataSource) {
        return true;
    }

    protected boolean isFolderVisible(DBNLocalFolder folder) {
        return true;
    }

    protected void onSelectionChange(Object element) {
    }

    public void refreshNodes() {
        this.dataSourceTree.getViewer().refresh();
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.dataSourceTree.getViewer().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.dataSourceTree.getViewer().getSelection();
    }
}

