#!/usr/bin/env python3

import http.server
import socketserver
import argparse
import sys

DIRECTORY = "WebUI"
EXIT_CODE_ADDRESS_IN_USE = 1

class Handler(http.server.SimpleHTTPRequestHandler):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, directory=DIRECTORY, **kwargs)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--port", nargs=1, help="HTTP server port.")

    args = parser.parse_args()
    port = int(args.port[0])

    try:
        with socketserver.TCPServer(("127.0.0.1", port), Handler) as httpd:
            httpd.serve_forever()
    except Exception as e:
        if (e.errno == 98 or e.errno == 10048):
            sys.exit(EXIT_CODE_ADDRESS_IN_USE)

    sys.exit(-1)

if __name__ == "__main__":
    main()
